// -*- Java -*-
/*!
 * @file  MultipleSimulatorImpl.java
 * @brief ModuleDescription
 * @date  $Date$
 *
 * $Id$
 */

import RTC.TimedDoubleSeq;
import RTC.TimedShortSeq;
import jp.go.aist.rtm.RTC.DataFlowComponentBase;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.port.InPort;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.util.DataRef;
import RTC.ReturnCode_t;
import RTC.Time;

import javax.vecmath.*;


/*!
 * @class MultipleSimulatorImpl
 * @brief ModuleDescription
 *
 */
public class MultipleSimulatorImpl extends DataFlowComponentBase {
	
	
	int robotNum=5;
	MultipleRobotSimulator mySim = new MultipleRobotSimulator();
	DataReadFromConfigureFile readFileClass = new DataReadFromConfigureFile();
	String  fileName ="robot.conf";

  /*!
   * @brief constructor
   * @param manager Maneger Object
   */
	public MultipleSimulatorImpl(Manager manager) {  
        super(manager);
        // <rtc-template block="initializer">
        m_velIn_val = new TimedDoubleSeq(new Time(0,0), new double[0]);
        m_velIn = new DataRef<TimedDoubleSeq>(m_velIn_val);
        m_velInPortIn = new InPort<TimedDoubleSeq>("velInPort", m_velIn);
        
        m_imageRGB_val = new TimedShortSeq(new Time(0,0), new short[0]);
        m_imageRGB = new DataRef<TimedShortSeq>(m_imageRGB_val);
        m_imageOutPortOut = new OutPort<TimedShortSeq>("imageOutPort", m_imageRGB);
        
        m_lrfDistance_val = new TimedShortSeq(new Time(0,0), new short[0]);
        m_lrfDistance = new DataRef<TimedShortSeq>(m_lrfDistance_val);
        m_lrfOutPortOut = new OutPort<TimedShortSeq>("lrfOutPort", m_lrfDistance);
        
        m_velOut_val = new TimedDoubleSeq(new Time(0,0), new double[0]);
        m_velOut = new DataRef<TimedDoubleSeq>(m_velOut_val);
        m_velOutPortOut = new OutPort<TimedDoubleSeq>("velOutPort", m_velOut);
        
        m_position_val = new TimedDoubleSeq(new Time(0,0), new double[0]);
        m_position = new DataRef<TimedDoubleSeq>(m_position_val);
        m_posOutPortOut = new OutPort<TimedDoubleSeq>("posOutPort", m_position);
        // </rtc-template>

    }

    /**
     *
     * The initialize action (on CREATED->ALIVE transition)
     * formaer rtc_init_entry() 
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onInitialize() {
        // Registration: InPort/OutPort/Service
        // <rtc-template block="registration">
        // Set InPort buffers
        addInPort("velInPort", m_velInPortIn);
        
        // Set OutPort buffer
        addOutPort("imageOutPort", m_imageOutPortOut);
        addOutPort("lrfOutPort", m_lrfOutPortOut);
        addOutPort("posOutPort", m_posOutPortOut);
        addOutPort("velOutPort", m_velOutPortOut);
        // </rtc-template>
        
		System.out.println("start");

		//シミュレータの起動
		//シミュレータの初期設定
		mySim.robotNum=readFileClass.initRobotFromConfigureFile(fileName);
		robotNum=mySim.robotNum;

		//スレッドの開始
		Thread simulatorThread = new Thread(mySim);
		simulatorThread.start();
		
        return super.onInitialize();
    }

    /***
     *
     * The finalize action (on ALIVE->END transition)
     * formaer rtc_exiting_entry()
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onFinalize() {
//        return super.onFinalize();
//    }

    /***
     *
     * The startup action when ExecutionContext startup
     * former rtc_starting_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onStartup(int ec_id) {
//        return super.onStartup(ec_id);
//    }

    /***
     *
     * The shutdown action when ExecutionContext stop
     * former rtc_stopping_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onShutdown(int ec_id) {
//        return super.onShutdown(ec_id);
//    }

    /***
     *
     * The activated action (Active state entry action)
     * former rtc_active_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onActivated(int ec_id) {
//        return super.onActivated(ec_id);
//    }

    /***
     *
     * The deactivated action (Active state exit action)
     * former rtc_active_exit()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onDeactivated(int ec_id) {
//        return super.onDeactivated(ec_id);
//    }

    /***
     *
     * The execution action that is invoked periodically
     * former rtc_active_do()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onExecute(int ec_id) {
    	
    	//位置情報の出力
    	if(mySim.robotPosition2 !=null){
        	m_position_val.data = new double[mySim.robotNum*3];

        	int count=0;
        	for(int i=0;i<mySim.robotPosition2.length;i++){
        		m_position_val.data[count]=mySim.robotPosition2[i].x;
        		count++;
        		m_position_val.data[count]=mySim.robotPosition2[i].y;
        		count++;
        		m_position_val.data[count]=mySim.robotPosition2[i].z;
        		count++;
        	}
       		m_posOutPortOut.write();
    	}
    	//lrf情報の出力
    	if(mySim.lrfDataGlobal != null){
    		if(mySim.lrfDistance[0] !=null){
        		m_lrfDistance_val.data = new short[mySim.robotNum*mySim.lrfDistance[0].length];
        		int count=0;
        		for(int i=0;i<mySim.robotNum;i++){
        			for(int k=0;k<mySim.lrfDistance[i].length;k++){
            			m_lrfDistance_val.data[count] = (short)mySim.lrfDistance[i][k];
            			count++;
        			}
        		}
    		}
    		m_lrfOutPortOut.write();
    	}
    	
    	//速度データの出力
		if(m_velIn.v.data !=null){
			m_velOut_val.data = m_velIn.v.data;
			m_velOutPortOut.write();
		}    	
		
    	
    	
    	//速度データの受け取り
    	if(m_velInPortIn.isNew()){
    		m_velInPortIn.read();
    		System.out.println("input size:"+m_velIn.v.data.length);
    		if(m_velIn.v.data !=null){
    			int velNum=m_velIn.v.data.length;
//    			System.out.println("velNum:"+velNum);
        		mySim.velData=new Point2d[velNum/2];
        		double x=0,y=0;
        		int robotNumVel=0;
            	for(int i=0;i<velNum;i++){
            		if(i%2==0)	x=m_velIn.v.data[i];
            		if(i%2==1){
            			y=m_velIn.v.data[i];
            			mySim.velData[robotNumVel]=new Point2d(x,y);
            			robotNumVel++;
            		}
            	}
            	
//            	for(int i=0;i<mySim.velData.length;i++){
//            		System.out.println("mySim.velData["+i+"]:"+mySim.velData[i]);
//            		System.out.println("myEnv.velData["+i+"]:"+mySim.myEnv.robots[i].tv+","+mySim.myEnv.robots[i].rv);
//            	}
    		}
    		
    	}
    	
    	
        return super.onExecute(ec_id);
    }

    /***
     *
     * The aborting action when main logic error occurred.
     * former rtc_aborting_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//  @Override
//  public ReturnCode_t onAborting(int ec_id) {
//      return super.onAborting(ec_id);
//  }

    /***
     *
     * The error action in ERROR state
     * former rtc_error_do()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    public ReturnCode_t onError(int ec_id) {
//        return super.onError(ec_id);
//    }

    /***
     *
     * The reset action that is invoked resetting
     * This is same but different the former rtc_init_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onReset(int ec_id) {
//        return super.onReset(ec_id);
//    }

    /***
     *
     * The state update action that is invoked after onExecute() action
     * no corresponding operation exists in OpenRTm-aist-0.2.0
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onStateUpdate(int ec_id) {
//        return super.onStateUpdate(ec_id);
//    }

    /***
     *
     * The action that is invoked when execution context's rate is changed
     * no corresponding operation exists in OpenRTm-aist-0.2.0
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onRateChanged(int ec_id) {
//        return super.onRateChanged(ec_id);
//    }
//
    // DataInPort declaration
    // <rtc-template block="inport_declare">
    protected TimedDoubleSeq m_velIn_val;
    protected DataRef<TimedDoubleSeq> m_velIn;
    /*!
     */
    protected InPort<TimedDoubleSeq> m_velInPortIn;

    
    // </rtc-template>

    // DataOutPort declaration
    // <rtc-template block="outport_declare">
    protected TimedShortSeq m_imageRGB_val;
    protected DataRef<TimedShortSeq> m_imageRGB;
    /*!
     */
    protected OutPort<TimedShortSeq> m_imageOutPortOut;

    protected TimedShortSeq m_lrfDistance_val;
    protected DataRef<TimedShortSeq> m_lrfDistance;
    /*!
     */
    protected OutPort<TimedShortSeq> m_lrfOutPortOut;

    protected TimedDoubleSeq m_velOut_val;
    protected DataRef<TimedDoubleSeq> m_velOut;
    /*!
     */
    protected OutPort<TimedDoubleSeq> m_velOutPortOut;

    protected TimedDoubleSeq m_position_val;
    protected DataRef<TimedDoubleSeq> m_position;
    /*!
     */
    protected OutPort<TimedDoubleSeq> m_posOutPortOut;

    
    // </rtc-template>

    // CORBA Port declaration
    // <rtc-template block="corbaport_declare">
    
    // </rtc-template>

    // Service declaration
    // <rtc-template block="service_declare">
    
    // </rtc-template>

    // Consumer declaration
    // <rtc-template block="consumer_declare">
    
    // </rtc-template>


}
