import javax.media.j3d.Transform3D;
import javax.vecmath.*;

import simbad.sim.Agent;
import simbad.sim.CameraSensor;
import simbad.sim.RangeSensorBelt;

    /** Describe the robot */
    public class SimbadRobot extends Agent {

    	public double tv=0.0;
    	public double rv=0.0;

    	public Point3d pos=new Point3d(0,0,0);
    	public Transform3D rotationMatrix=new Transform3D();

    	int sensorNum=180;
    	float maxDistance=5.6f;	//[mm]
    	float minDistance=0.0f;
    	int[] distance;	//[mm]
    	double[] angleSeq; //[rad]

        RangeSensorBelt sonars;
        CameraSensor camera;

        public SimbadRobot(Vector3d position, String name) {
            super(position, name);
            // Add camera
//            camera = RobotFactory.addCameraSensor(this);
            // Add sonars
            double d = this.getHeight();
            double d1 = this.getRadius();
            sonars = new RangeSensorBelt((float)d1, minDistance, maxDistance, sensorNum, 2, 0);
            //[計測回数/秒]
            sonars.setUpdatePerSecond(20D);
            //センサ取り付け位置：真中が高さなので注意
            Vector3d vector3d = new Vector3d(0.0D, d / 4D, 0.0D);
            this.addSensorDevice(sonars, vector3d, 0.0D);

        }

        /** This method is called by the simulator engine on reset. */
        public void initBehavior() {
            // nothing particular in this case
        	distance= new int[sensorNum];
        	angleSeq = new double[sensorNum];
        }

        /** This method is call cyclically (20 times per second)  by the simulator engine. */
        public void performBehavior() {

        	//速度を指令
        	setTranslationalVelocity(tv);
        	setRotationalVelocity(rv);

           	if(getCounter()%1 ==0){
            	//x,z,yの座標取得
            	getCoords(pos);
            	//角度算出用に回転行列を取得
            	getRotationTransform(rotationMatrix);

            	//distanceとangleゲット
        	  for(int i=0; i<sonars.getNumSensors();i++){
        		  double range = (sonars.getMeasurement(i)+getRadius())*1000.0;
        		  double angle = sonars.getSensorAngle(i);
        		  distance[i]=(int)range;
        		  angleSeq[i] = angle;
//        		  boolean hit = sonars.hasHit(i);
//        		  System.out.println("Sonar at angle "+Math.toDegrees(angle)+" measured range ="+range+" has hit something;"+hit);
        	  }
        	}
        }
    }