import javax.vecmath.*;

public class MultipleRobotSimulator  implements Runnable{

	public SimbadEnv myEnv=null;

	public int robotNum=1;
	public Point3d[] robotPosition=null;
	public Point2d[][] lrfDataGlobal=null;
	public Point2d[][] lrfDataRobot=null;
	public int[][] lrfDistance = null;
	public Point2d[] velData=null;

	public Point3d[] robotPosition2=null;
	public Point2d[][] lrfDataGlobal2=null;

	public int waitTime=100;


	public void run() {
		// TODO 自動生成されたメソッド・スタブ

		//シミュレータ起動
        // request antialising
        System.setProperty("j3d.implicitAntialiasing", "true");
        // create Simbad instance with given environment

        myEnv=new SimbadEnv(robotNum);

        System.out.println("robotNum in myEnv:"+robotNum);
        myEnv.setUsePhysics(true);
        try{
            Thread.sleep(300);
        }catch(Exception e){

        }

        MySimbad frame = new MySimbad(myEnv, false);

        frame.setTitle("Multiple Robot Simulator");
        velData = new Point2d[robotNum];
        for(int i=0;i<robotNum;i++){
        	velData[i]=new Point2d(0,0);
        }

		//LRF関係の処理
        for(int i=0;i<robotNum;i++){
    		lrfDistance = new int[robotNum][myEnv.robots[i].sensorNum];
    		lrfDataRobot = new Point2d[robotNum][myEnv.robots[i].sensorNum];
    		lrfDataGlobal = new Point2d[robotNum][myEnv.robots[i].sensorNum];
			robotPosition = new Point3d[robotNum];

			robotPosition2 = new Point3d[robotNum];
    		lrfDataGlobal2 = new Point2d[robotNum][myEnv.robots[i].sensorNum];

        }

		while(true){
			try {
				//スリープと組み合わせて、タイマー的な処理を作る。
				Thread.sleep(waitTime);
			}catch(Exception xe){
					xe.getStackTrace();
			}

			for(int i=0; i<robotNum;i++){
				if(myEnv.robots[i] != null){

					//速度をシミュレータに渡す
//					if(velData != null){
//						if(velData[i] != null){
//							myEnv.robots[i].tv=velData[i].x/20.0;
//							myEnv.robots[i].rv=velData[i].y/20.0;
//							System.out.println("in Env:"+velData[i]);
//						}
//					}

					//自己位置を算出
					double[] test4= new double[16];
					myEnv.robots[i].rotationMatrix.get(test4);
					//回転行列から角度を算出
					double robotangle = -Math.atan2(test4[2],test4[0]);
					//位置ベクトルに入れる
					robotPosition[i] = new Point3d(myEnv.robots[i].pos.x*1000,-myEnv.robots[i].pos.z*1000, robotangle);


					if(myEnv.robots[i].distance != null){
						for(int j=0; j<myEnv.robots[i].sensorNum;j++){
							//LRFの距離データを配列に保存する
							lrfDistance[i][j]= myEnv.robots[i].distance[j];

							//ロボット座標でのLRFデータ
							if(lrfDistance[i][j] >myEnv.robots[i].maxDistance*1000.0){
								lrfDistance[i][j] = (int)(myEnv.robots[i].maxDistance*1000.0);

							}
							double x= lrfDistance[i][j] * Math.cos(myEnv.robots[i].angleSeq[j]);
			    			double y= lrfDistance[i][j] * Math.sin(myEnv.robots[i].angleSeq[j]);
			    			lrfDataRobot[i][j] = new Point2d(x, y);

							//速度をシミュレータに渡す
							if(velData != null){
								if(velData[i] != null){
									myEnv.robots[i].tv=velData[i].x;
									myEnv.robots[i].rv=velData[i].y;
								}
							}

							//自己位置を算出
							test4= new double[16];
							myEnv.robots[i].rotationMatrix.get(test4);
							//回転行列から角度を算出
							robotangle = -Math.atan2(test4[2],test4[0]);
							//位置ベクトルに入れる
							robotPosition[i] = new Point3d(myEnv.robots[i].pos.x*1000,-myEnv.robots[i].pos.z*1000, robotangle);

							//グローバル座標に変換
			    			//ロボット座標系からグローバルマップ系に変換
			    			//回転行列
			    			Matrix3d Rz = new Matrix3d(); // マトリクスを作成
			    			Rz.rotZ(-robotPosition[i].z); // 回転マトリクスをセット
			    			//並進ベクトル
			    			Vector3d transV = new Vector3d(robotPosition[i].x, robotPosition[i].y, 0);
			    			//同次変換行列の作成
			    			Matrix4d transAll = new Matrix4d();
			    			transAll.set(Rz, transV, 1);
			    			Vector4d v = new Vector4d(x, y, 0, 1); // ベクトルの初期値
			    			transAll.transform(v);	// TransAll を v に作用させる
			    			lrfDataGlobal[i][j] = new Point2d(v.x, v.y);
						}
					}
					robotPosition2=robotPosition;
					lrfDataGlobal2=lrfDataGlobal;


				}
			}
		}
	}
}
