import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
//import java.util.ArrayList;
import javax.swing.*;
import simbad.demo.BaseDemo;
import simbad.demo.DemoManager;
import simbad.sim.*;
import simbad.gui.*;

public class MySimbad extends JFrame
    implements ActionListener
{
    public MySimbad(EnvironmentDescription environmentdescription, boolean flag)
    {
        super("Simbad  - version 1.4");
        worldWindow = null;
        controlWindow = null;
        console = null;
        agentInspector = null;
        simbadInstance = this;
        backgroundMode = flag;
        desktop = new JDesktopPane();
        setDefaultCloseOperation(3);
        setSize(SIZEX, SIZEY);
        createGUI();
        start(environmentdescription);
        setVisible(true);
    }
    private void createGUI()
    {
        desktop.setFocusable(true);
        getContentPane().add(desktop);
        //menubar = new JMenuBar();
        //menubar.add(DemoManager.createMenu(this));
        //setJMenuBar(menubar);
    }
    private void start(EnvironmentDescription environmentdescription)
    {
        System.out.println("Starting environmentDescription: " + environmentdescription.getClass().getName());
        world = new World(environmentdescription);
        simulator = new Simulator(desktop, world, environmentdescription);
        createInternalFrames();
        if(backgroundMode)
            runBackgroundMode();
    }
    private void releaseRessources()
    {
        simulator.dispose();
        world.dispose();
        disposeInternalFrames();
    }
    private void createInternalFrames()
    {
        worldWindow = new WorldWindow(world);
        desktop.add(worldWindow);
        worldWindow.show();
        worldWindow.setLocation(30, 20);
        //agentInspector = createAgentInspector(simulator, 20, 20);
        if(!backgroundMode)
        {
            controlWindow = new ControlWindow(world, simulator);
            desktop.add(controlWindow);
            controlWindow.show();
            controlWindow.setLocation(60, 450);
            simulator.startSimulation();
        }
    }
    private void disposeInternalFrames()
    {
        simulator.dispose();
        worldWindow.dispose();
        if(agentInspector != null)
            agentInspector.dispose();
        if(controlWindow != null)
            controlWindow.dispose();
    }
//    private AgentInspector createAgentInspector(Simulator simulator1, int i, int j)
//    {
//        ArrayList arraylist = simulator1.getAgentList();
//        SimpleAgent simpleagent = (SimpleAgent)arraylist.get(0);
//        if(simpleagent instanceof Agent)
//        {
//            AgentInspector agentinspector = new AgentInspector((Agent)simpleagent, !backgroundMode, simulator1);
//            desktop.add(agentinspector);
//            agentinspector.show();
//            agentinspector.setLocation(i, j);
//            return agentinspector;
//        } else
//        {
//            return null;
//        }
//    }
    public void actionPerformed(ActionEvent actionevent)
    {
        if(actionevent.getActionCommand() == "demo")
        {
            releaseRessources();
            start(DemoManager.getDemoFromActionEvent(actionevent));
        }
    }
    private void runBackgroundMode()
    {
        setTitle(getTitle() + " - Background Mode");
        System.out.println("---------------------------------------------");
        System.out.println("Simbad is running in 'Background Mode");
        System.out.println("World is rendered very rarely. UI is disabled");
        System.out.println("--------------------------------------------");
        agentInspector.setFramesPerSecond(0.5F);
        JInternalFrame jinternalframe = new JInternalFrame();
        JPanel jpanel = new JPanel();
        jpanel.add(new JLabel("BACKGROUND MODE"));
        jinternalframe.setContentPane(jpanel);
        jinternalframe.setClosable(false);
        jinternalframe.pack();
        jinternalframe.setLocation(SIZEX / 2, (SIZEY * 3) / 4);
        desktop.add(jinternalframe);
        jinternalframe.show();
        world.changeViewPoint(1, null);
        simulator.startBackgroundMode();
    }
    public static void main(String args[])
    {
        boolean flag = false;
        for(int i = 0; i < args.length; i++)
            if("-bg".compareTo(args[i]) == 0)
                flag = true;
        try
        {
            Class.forName("javax.media.j3d.VirtualUniverse");
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            JOptionPane.showMessageDialog(null, "Simbad requires Java 3D", "Simbad 3D", 0);
            System.exit(-1);
        }
        System.setProperty("j3d.implicitAntialiasing", "true");
        new Simbad(new BaseDemo(), flag);
    }
    public JDesktopPane getDesktopPane()
    {
        return desktop;
    }
    public static MySimbad getSimbadInstance()
    {
        return simbadInstance;
    }
    private static final long serialVersionUID = 1L;
    static final String version = "1.4";
    static int SIZEX = 480;
    static int SIZEY = 700;
    JMenuBar menubar;
    JDesktopPane desktop;
    WorldWindow worldWindow;
    ControlWindow controlWindow;
    World world;
    Simulator simulator;
    Console console;
    AgentInspector agentInspector;
    boolean backgroundMode;
    static MySimbad simbadInstance = null;
}

/*
	DECOMPILATION REPORT

	Decompiled from: C:\Program Files\Java\jdk1.6.0_16\jre\lib\ext\simbad-1.4.jar
	Total time: 281 ms
	Jad reported messages/errors:
	Exit status: 0
	Caught exceptions:
*/