import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import simbad.sim.Box;
import simbad.sim.EnvironmentDescription;
import simbad.sim.Wall;


/** Describe the environement */
public class SimbadEnv extends EnvironmentDescription {

	SimbadRobot[] robots = null;

    public SimbadEnv( int robotNum) {
    	System.out.println("num:"+robotNum);

    	robots=new SimbadRobot[robotNum];
    	for(int i=0; i<robots.length;i++){
        	String robotName="robot"+i;
    		robots[i]= new SimbadRobot(new Vector3d(-i*0.8, 0, 0), robotName);
    	}

        light1IsOn = true;
        light2IsOn = false;
        Wall w1 = new Wall(new Vector3d(9, 0, 0), 19, 1, this);
        w1.rotate90(1);
        add(w1);
        Wall w2 = new Wall(new Vector3d(-9, 0, 0), 19, 2, this);
        w2.rotate90(1);
        add(w2);
        Wall w3 = new Wall(new Vector3d(0, 0, 9), 19, 1, this);
        add(w3);
        Wall w4 = new Wall(new Vector3d(0, 0, -9), 19, 2, this);
        add(w4);
        Box b1 = new Box(new Vector3d(-3, 0, -3), new Vector3f(7, 1, 5),
                this);
        add(b1);
        Box b2 = new Box(new Vector3d(3, 0, 3), new Vector3f(2, 1, 3),
                this);
        add(b2);

        Box b3 = new Box(new Vector3d(-3, 0, 3), new Vector3f(2, 1, 5),
                this);
        add(b3);
        Box b4 = new Box(new Vector3d(6, 0, -6), new Vector3f(3, 1, 6),
                this);
        add(b4);

        Wall w5 = new Wall(new Vector3d(9, 0, 3), 6, 2, this);
        add(w5);
        Wall w6 = new Wall(new Vector3d(0, 0, 6), 3, 2, this);
        add(w6);
        Wall w7 = new Wall(new Vector3d(-5, 0, 5), 5, 2, this);
        add(w7);

//        add(new Arch(new Vector3d(3, 0, -3), this));
        for(int i=0;i<robotNum;i++){
            add(robots[i]);
        }

    }
}