/*+---------------------------------------------------------------------------+
  |   Programming Tools for Robot Control in MatsunoLab(PTRC).      	      |
  |   copyright @ Kazuyuki Kon 											      |
  +---------------------------------------------------------------------------+*/
  /*!
	@file CVelocity2D.h
	@brief 
	@author Kazuyuki Kon, Kyoto University
  */
/*-----------------------------------------------------------------------------*/

#ifndef CVELOCITY2D_H
#define CVELOCITY2D_H

namespace ptrc
{
	namespace poses
	{
		/*---------------------------------------------------------------*/
		/*!
		*	@class Velocity2D
		*/
		/*---------------------------------------------------------------*/
		class CVelocity2D
		{
		private:
			int id;		//!< id
			double v;	//!< ix[m/sec]
			double w;	//!< ]px[rad/sec]

		public:
			/*!
			*	@brief Rs[RXgN^
			*	@param[in] id0 
			*	@param[in] v0 
			*	@param[in] w0 
			*/
			CVelocity2D(void)
			{
				id = 0;
				v  = 0.0;
				w  = 0.0;
			};

			/*!
			*	@brief Rs[RXgN^
			*	@param[in] v0 
			*	@param[in] w0 
			*/
			CVelocity2D(double v0,double w0)
			{
				v = v0;
				w = w0;
			};

			/*!
			*	@brief Rs[RXgN^
			*	@param[in] id0 
			*	@param[in] v0 
			*	@param[in] w0 
			*/
			CVelocity2D(int id0,double v0,double w0)
			{
				id = id0;
				v = v0;
				w = w0;
			};
			
			/*!
			*	@brief fXgN^
			*/
			~CVelocity2D(){};

			/*!
			*	@brief idZbg
			*	@param[in] id0
			*/
			void setID(int id0){id = id0;};

			/*!
			*	@brief idZbg
			*	@param[in] v0 
			*/
			void setV(double v0){v = v0;};
			
			/*!
			*	@brief idZbg
			*	@param[in] w0
			*/
			void setW(double w0){w = w0;};
			
			/*!
			*	@brief idZbg
			*	@param[in] v0
			*	@param[in] w0
			*/
			void setVW(double v0,double w0)
			{
				v = v0; 
				w = w0;
			};

			/*!
			*	@brief id擾
			*	@retval id
			*/
			int getID(void){return id;};

			/*!
			*	@brief v擾
			*	@retval v
			*/
			double getV(void){return v;};
			
			/*!
			*	@brief w擾
			*	@retval w
			*/			
			double getW(void){return w;};
		 
			/*!
			*	@brief oϐ
			*/		
			void clear(void)
			{
				id = 0;
				v = 0.0;
				w = 0.0;
			};

			/*!
			*	@brief Operator=
			*/
			CVelocity2D operator=(const CVelocity2D &vel0)
			{
				this->id = vel0.id;
				this->v  = vel0.v;
				this->w  = vel0.w;
				return *this;
			};

			/*!
			*	@brief Operator+
			*/
			CVelocity2D operator+(const CVelocity2D &vel0)
			{
				CVelocity2D temp;
				temp.v  = v + vel0.v;
				temp.w  = w + vel0.w;
				return temp;
			};
			
			/*!
			*	@brief Operator-
			*/
			CVelocity2D operator-(const CVelocity2D &vel0)
			{
				CVelocity2D temp;
				temp.v  = v - vel0.v;
				temp.w  = w - vel0.w;
				return temp;
			};
		};

	}
}

#endif

