/*****************************************************************************************************
RVC2011 RT-Component
Copyright (c) 2011, Kyoto Univ.
All rights reserved.

Contact us if you use this software for sell.
If you use this software not for sell, you can use this software under BSD lisence.
See the files LICENSE.TXT and LICENSE-BSD.TXT for more details.                     
*****************************************************************************************************/
/****************************************************************************************************/
/*!
*	@file myTimer.h
*	@brief class for timer 
*/
/****************************************************************************************************/
#ifndef __MYTIMER_H
#define __MYTIMER_H

#ifdef WIN32
	#include <Windows.h>
#else
	#include <sys/time.h>
#endif
#include <stdio.h>
#include <iostream>

/****************************************************************************************************/
/*!
*	@class myTimer
*/
/****************************************************************************************************/
class myTimer
{
private:
	bool   m_isStart;		//!< is timer start
	double m_timeOut;		//!< Timeout[sec]
	double m_dataTime;		//!< [sec]

public:

	/*!
	*	@brief Default constructor
	*/
	myTimer()
	{
		reset();
	}

	/*!
	*	@brief Default constructor
	*	@param[in] t0 Timeout[sec]
	*/
	myTimer(double _timeOut)
	{
		reset();
		m_timeOut = _timeOut;
	}

	/*!
	*	@brief Destructor
	*/
	~myTimer(){}

	/*!
	*	@brief Set current time to timer (i.e. reset timer)
	*/
	void setCurrentTime(void)
	{
		m_dataTime = getTime();
		if(!m_isStart)m_isStart = true;
	}

	/*!
	*	@brief Get time 
	*	@retval current time [sec] 
	*/
	double getTime(void)
	{
#ifdef WIN32
		LARGE_INTEGER freq, new_time;
		QueryPerformanceFrequency(&freq);
		QueryPerformanceCounter(&new_time);
		return (double)((new_time.QuadPart)*1000000/freq.QuadPart)/1000000;
#else
		struct timeval t1;
		gettimeofday(&t1,NULL);
		return ToSec(t1);
#endif
	}

	/*!
	*	@brief Get time 
	*	@retval current time [sec] 
	*/
	double getTimeFromPre(void)
	{
		return getTime() - m_dataTime;
	}

	/*!
	*	@brief Get time 
	*	@retval current time [sec] 
	*/
	double toSec(timeval _t0)
	{
		return (double)_t0.tv_sec + (double)_t0.tv_usec/1000000;
	}

	/*!
	*	@brief Reset timer 
	*	@retval current time [sec] 
	*/
	void reset(void)
	{
		m_isStart = false;
		m_timeOut = 0;
		m_dataTime = 0;
	}

	/*!
	*	@brief Get connection
	*	@retval connection status (true: connected, false: not connected)
	*/
	bool isConnect(void)
	{
		if(m_isStart && getTimeFromPre() <= m_timeOut)return true;
		else return false;		
	}

	/*!
	*	@brief Get time 
	*	@param[in] current time [sec] 
	*/
	void setTimeout(double _timeOut)
	{
		m_timeOut = _timeOut;
	}

};



#endif
