/*****************************************************************************************************
RVC2011 RT-Component
Copyright (c) 2011, Kyoto Univ.
All rights reserved.

Contact us if you use this software for sell.
If you use this software not for sell, you can use this software under BSD lisence.
See the files LICENSE.TXT and LICENSE-BSD.TXT for more details.                     
*****************************************************************************************************/
/*+---------------------------------------------------------------------------+
  |   Programming Tools for Robot Control in MatsunoLab(PTRC).      	      |
  |   copyright @ Kazuyuki Kon 											      |
  +---------------------------------------------------------------------------+*/
/*!
	@file CPoint2D.h
	@brief 
	@author Kazuyuki Kon, Kyoto University
*/
#ifndef CPOINTBASE_H
#define CPOINTBASE_H

#include <iostream>
#include <math.h>
#include <stdexcept>


namespace ptrc
{
	namespace poses
	{
		/*---------------------------------------------------------------*/
		/*!
		*	@class 
		*/
		/*---------------------------------------------------------------*/
		class CPointBase
		{
		public:

			/*!
			*	@brief default constructor
			*/
			CPointBase(void)
			{
				m_time = 0;
			}

			/*!
			*	@brief destructor
			*/
			~CPointBase(void){}

			/*!
			*	@brief override of operator=
			*	@param point 
			*/
			 CPointBase& operator=(const CPointBase& point)
			{
				m_time = point.m_time;
				return *this;
			};
			
			/*!
			*	@brief override of operator=
			*	@param point 
			*/
			virtual CPointBase operator+(CPointBase point)
			{
				CPointBase temp;
				return temp;
			};
			
			/*!
			*	@brief override of operator=
			*	@param point 
			*/
			virtual CPointBase operator-(CPointBase point)
			{
				CPointBase temp;
				return temp;
			};

			/*!
			*	@brief get timestamp data
			*	@retval time0 timestamp data[msec]
			*/
			double getTime(){return m_time;};

			/*!
			*	@brief set timestamp data
			*	@param time0 timestamp data[msec]
			*/
			void setTime(double time0){m_time = time0;};

			/*!
			*	@brief
			*/
			virtual void printData(void)
			{
				std::cout<<m_time<<std::endl;
			}

		protected:
			double m_time;	//!< timestamp[msec]

		};
	}
}

#endif
