/****************************************************************************************************/
/*!
*	@file myBitmap.h
*	@brief Class for managing bitmap file
*/
/****************************************************************************************************/
#ifndef _MYBITMAP_H
#define _MYBITMAP_H

#include <iostream>
#include <string.h>
#include <fstream>
using namespace std;

typedef long  LONG;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef unsigned char BYTE;


///*BITMAPFILEHEADER*/
struct myBITMAPFILEHEADER
{
	WORD  bfType;
	DWORD bfSize;
	WORD  bfReserved1;
	WORD  bfReserved2;
	DWORD bfOffBits;
};
//
///*BITMAPINFOHEADER*/
struct myBITMAPINFOHEADER
{
	DWORD biSize;
	LONG  biWidth;
	LONG  biHeight;
	WORD  biPlanes;
	WORD  biBitCount;
	DWORD biCompression;
	DWORD biSizeImage;
	LONG  biXPelsPerMeter;
	LONG  biYPelsPerMeter;
	DWORD biClrUsed;
	DWORD biClrImportant;
};

/*!
*	@struct COLOR24
*/
struct COLOR24
{
	BYTE r, g, b;
};

const COLOR24 COLOR24_BLACK = {0, 0, 0};
const COLOR24 COLOR24_WHITE = {255, 255, 255};
const COLOR24 COLOR24_RED   = {255, 0, 0};
#define BI_RGB  0L;

/*!
*	@struct MY_BITMAP
*/
struct MY_BITMAP
{
	myBITMAPFILEHEADER bmf;
	myBITMAPINFOHEADER bmi;
};


/****************************************************************************************************/
/*!
*	@class myBitmap
*	@brief class for handling a bitmap iamge
*/
/****************************************************************************************************/
class myBitmap
{
private:
	int m_Width;			//!< 
	int m_Height;			//!< 
	MY_BITMAP m_Header;		//!< 
	void *m_Buffer;			//!< 
	COLOR24 m_OutColor;		//!< 

private:
public:
	myBitmap();
	myBitmap(int width, int height);
	virtual ~myBitmap();

	void InitHeader();
	void Delete();
	void Resize(int width, int height);
	void Copy(myBitmap *obj);
	void Load(string filename);
	void Save(string filename);

	int GetWidth() {return m_Width;};
	int GetHeight() {return m_Height;};
	MY_BITMAP *GetHeader() {return &m_Header;};
	void SetHeader(MY_BITMAP *header) {m_Header = *header;};
	void *GetBuffer() {return m_Buffer;};
	void *GetPixelAddress(int x, int y);

	void *GetPixelAddressNC(int x, int y){return (BYTE *)m_Buffer + ((m_Width * y + x) * sizeof(COLOR24));};

	void SetPixel(int x, int y, COLOR24 *color);
	COLOR24 GetPixel(int x, int y);
	COLOR24 GetOutColor() {return m_OutColor;};
	void SetOutColor(COLOR24 color) {m_OutColor = color;};
};



#endif