// -*- C++ -*-
/*!
 * @file  KobukiAutoMove.cpp
 * @brief Kobuki auto move component
 * @date $Date$
 *
 * $Id$
 */

#include <coil/Time.h>
#include "KobukiAutoMove.h"

// Module specification
// <rtc-template block="module_spec">
static const char* kobukiautomove_spec[] =
  {
    "implementation_id", "KobukiAutoMove",
    "type_name",         "KobukiAutoMove",
    "description",       "Kobuki auto move component",
    "version",           "1.0.0",
    "vendor",            "AIST",
    "category",          "Category",
    "activity_type",     "PERIODIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    ""
  };
// </rtc-template>

/*!
 * @brief constructor
 * @param manager Maneger Object
 */
KobukiAutoMove::KobukiAutoMove(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_bumperIn("bumper", m_bumper),
    m_targetVelocityOut("targetVelocity", m_targetVelocity)

    // </rtc-template>
{
}

/*!
 * @brief destructor
 */
KobukiAutoMove::~KobukiAutoMove()
{
}



RTC::ReturnCode_t KobukiAutoMove::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("bumper", m_bumperIn);
  
  // Set OutPort buffer
  addOutPort("targetVelocity", m_targetVelocityOut);
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  
  // </rtc-template>

  // <rtc-template block="bind_config">
  // </rtc-template>
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t KobukiAutoMove::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t KobukiAutoMove::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t KobukiAutoMove::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


RTC::ReturnCode_t KobukiAutoMove::onActivated(RTC::UniqueId ec_id)
{
	m_bumper_flg = false;
	kobuki_straight(0.25);	// Oi

  return RTC::RTC_OK;
}


RTC::ReturnCode_t KobukiAutoMove::onDeactivated(RTC::UniqueId ec_id)
{
	kobuki_stop();

	return RTC::RTC_OK;
}


RTC::ReturnCode_t KobukiAutoMove::onExecute(RTC::UniqueId ec_id)
{
	if (m_bumperIn.isNew())
	{
		m_bumperIn.read();
		check_bumper_status();
		if (m_bumper_flg)
		{
			// 
			for (int i(10); i < 30; ++i,++i)
			{
				kobuki_straight(i / -100.0);
#ifdef _WIN32
				Sleep(40);
#else
				coil::sleep(coil::TimeValue(0.04));		// 40msec
#endif
			}
			for (int i(30); i > 0; --i,--i)
			{
				kobuki_straight(i / -100.0);
#ifdef _WIN32
				Sleep(40);
#else
				coil::sleep(coil::TimeValue(0.04));
#endif
			}
	
			// ɐ
			for (int i(0); i < 20; ++i)
			{
				kobuki_turn(i / 20.0);
#ifdef _WIN32
				Sleep(20);
#else
				coil::sleep(coil::TimeValue(0.02));
#endif
			}

			for (int i(20); i > 0; --i)
			{
				kobuki_turn(i / 20.0);
#ifdef _WIN32
				Sleep(20);
#else
				coil::sleep(coil::TimeValue(0.02));
#endif
			}

			m_bumper_flg = false;
			for (int i(0); i < 20; ++i)
			{
				kobuki_straight(i / 100.0);
#ifdef _WIN32
				Sleep(20);
#else
				coil::sleep(coil::TimeValue(0.02));
#endif
			}
		}
	}

	return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t KobukiAutoMove::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t KobukiAutoMove::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t KobukiAutoMove::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t KobukiAutoMove::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t KobukiAutoMove::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

void KobukiAutoMove::check_bumper_status(void)
{
	bool flg = true;

	if (m_bumper.data[RIGHT_BUMPER])
	{
		output_msg("RIGHT_BUMPER");		// op[̐ڐG
	}
	else if (m_bumper.data[CENTER_BUMPER])
	{
		output_msg("CENTER_BUMPER");
	}
	else if (m_bumper.data[LEFT_BUMPER])
	{	
		output_msg("LEFT_BUMPER");
	}
	else if (m_bumper.data[RIGHT_WHEEL_DROP])
	{
		output_msg("RIGHT_WHEEL_DROP");		// ԗւ̗
	}
	else if (m_bumper.data[LEFT_WHEEL_DROP])
	{
		output_msg("LEFT_WHEEL_DROP");
	}
	else if (m_bumper.data[RIGHT_CLIFF])
	{
		output_msg("RIGHT_CLIFF");				// ̐ԊOZT̔ 
	}
	else if (m_bumper.data[CENTER_CLIFF])
	{
		output_msg("CENTER_CLIFF");
	}
	else if (m_bumper.data[LEFT_CLIFF])
	{
		output_msg("LEFT_CLIFF");
	}
	else
	{
		// QȂ
		flg = false;
	}
	m_bumper_flg = flg;

	return;
}

void KobukiAutoMove::output_msg(std::string msg)
{
	std::cout << "m_bumper::" << msg << std::endl;

	return;
}

void KobukiAutoMove::kobuki_move(MOVE_PARAM prm)
{
	m_targetVelocity.data.vx = prm.vx;
	m_targetVelocity.data.vy = prm.vy;
	m_targetVelocity.data.va = prm.va;
	m_targetVelocityOut.write();

	return;
}

void KobukiAutoMove::kobuki_stop(void)
{
	MOVE_PARAM prm;
	prm.vx = 0;
	prm.vy = 0;
	prm.va = 0;
	kobuki_move(prm);

	return;
}

void KobukiAutoMove::kobuki_straight(double vel)
{
	MOVE_PARAM prm;
	prm.vx = vel;
	prm.vy = 0;
	prm.va = 0;
	kobuki_move(prm);

	return;
}

void KobukiAutoMove::kobuki_turn(double vel)
{
	MOVE_PARAM prm;
	prm.vx = 0;
	prm.vy = 0;
	prm.va = vel;
	kobuki_move(prm);

	return;
}


extern "C"
{
 
  void KobukiAutoMoveInit(RTC::Manager* manager)
  {
    coil::Properties profile(kobukiautomove_spec);
    manager->registerFactory(profile,
                             RTC::Create<KobukiAutoMove>,
                             RTC::Delete<KobukiAutoMove>);
  }
  
};


