#include <opencv/cv.h>
#include <opencv/highgui.h>

#include "curvature.h"
#include "distance3.h"
#include "main.h"

int compare (const void * a, const void * b)
{
	if(*(double*)a - *(double*)b>0) return 1;
	else return -1;
}

int Learning()
{
	IplImage *image = 0;  //Black and White image
	IplImage *image2 = 0; //copy of image inversed
	IplImage *image3 = 0;
	IplImage *image4 = 0;
	IplImage *image5 = 0; //color results
	IplImage *img = 0;
	IplImage *disimage = 0;  //distance transformed image
	IplImage *bufimage = 0;  //for temporary calculations
	IplImage **train=(IplImage**)calloc(Ltrain,sizeof(IplImage*));

	CvSeq **contours; // contours of training images
	int contours_num[Ltrain];  // number of contours on the training images
	int trainkeret[Ltrain][4];      // the bounding of box of the training objects
	double traincentx[Ltrain],traincenty[Ltrain]; // the center of training objects
	double trainpitch[Ltrain],trainyaw[Ltrain];  // orientation of the object
	double **profilesall;  // every candidate profile before clustering
	double *profilesallcentx;  // vector from the Peek point the center of object
	double *profilesallcenty;
	double *profilesalldirection; //direction of the circle center (osculating circle)
	double *profilesallpeekx,*profilesallpeeky;  //position of the profile on the training image
	double *profilesallcurve;  //curvature at the peak 
	int *profilesallorigin;   // index of training image where the actual profile came from
	double *profilesallpitch,*profilesallyaw;  // degree and radius
	int profilesallnumber=0;  // number of candidate profiles chosen in the first phase

	double *profilesalllength; // length from peek to center

	clock_t start, end;  //to calculate framerate
	double clockavg=0.05; //exponentially relaxed time average for the frame rate

	int i,j; // for cycles
	char filename [50];

	//memory allocation
	contours=(CvSeq**)calloc( Ltrain, sizeof(CvSeq*) ); 
	CvMemStorage **storage = (CvMemStorage**)calloc( Ltrain, sizeof(CvMemStorage*) );
	for(i=0;i<Ltrain;i++) storage[i] = cvCreateMemStorage(0);
	image = cvCreateImage( cvSize( Iwidth,Iheight ), IPL_DEPTH_8U, 1 );
	image2 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );			
	image3 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
	image4 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
	image5 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 3 );
	img = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
	disimage = cvCreateImage( cvGetSize( image ), IPL_DEPTH_32F, 1 );
	bufimage = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
	for(i=0;i<Ltrain;i++) train[i]=cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
	int edge_count = 0;
	int k0 =0,k1=0,k2=0,k3=0;

	// feature extraction(zeroth phase)

	//  loading training images
	for(i=0;i<Ltrain;i++){  
		sprintf_s(filename, "train\\pic%03dcanny.png", i);
		if((image=cvLoadImage(filename,CV_LOAD_IMAGE_GRAYSCALE))==0){
			printf("Unable to open %s\n",filename);	
			return 3;
		}	
		cvCopy(image,train[i]);

		//loading bounding box information
		sprintf_s(filename, "train\\boundingbox%03d.png", i);
		FILE *fp;
		errno_t err;
		if( (err  = fopen_s( &fp, filename, "r" )) !=0 ){
			printf("Unable to open %s\n",filename);	
			return 3;
		}
		fscanf_s( fp, "%d %d %d %d",&trainkeret[i][0],&trainkeret[i][1],&trainkeret[i][2],&trainkeret[i][3]);
		float scan4; 
		fscanf_s( fp, "%g ",&scan4); trainpitch[i]=scan4;
		fscanf_s( fp, "%g ",&scan4); trainyaw[i]=scan4;
		fclose( fp );
		traincentx[i]=((double)(trainkeret[i][2])+(double)(trainkeret[i][0]))/2;
		traincenty[i]=((double)(trainkeret[i][3])+(double)(trainkeret[i][1]))/2;

		//finding contours
#ifdef labels
		cvCopy(image,img);

		for(int i2=0;i2<Iwidth;i2++) // show nothing outside the frame
			for(int i3=0;i3<Iheight;i3++)
				if((i2<trainkeret[i][0]-3) || (i2>trainkeret[i][2]+3) || (i3<trainkeret[i][1]-3) || (i3>trainkeret[i][3]+3))
					cvSetReal2D( img, i3,i2, 0 );

#endif
		CvSeq* contoursbe = 0;
		contours_num[i] = cvFindContours( img, storage[i], &contoursbe, sizeof(CvContour),
			CV_RETR_LIST, CV_CHAIN_APPROX_NONE, cvPoint(0,0) );
		CvSeq* contours2 = contoursbe;
		contours[i]=contoursbe;
		printf("i:%d contour number:%d\n",i,contours_num[i]);
		cvZero( image5 );
		for( ; contours2 != 0; contours2 = contours2->h_next )
		{            
			if(contours2->total<50){
				//printf("%d torolve",contours2->total);
				cvClearSeq(contours2);
				continue;
			}
			CvPoint *ptArray;
			ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
			cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);


			//finding extremas
			int vonalfeaturenumber;   //needed
			int *vonalMaximums=NULL;
			CvPoint2D64f *vonalPeek2=NULL;  //needed
			double *vonalCurve2=NULL;
			double *vonalDirections=NULL;  //needed
			CvPoint2D64f *vonalCenter2=NULL;

			int cyclic=0; //the contour is closed
			if((abs(ptArray[0].x-ptArray[contours2->total-1].x)<=1) && (abs(ptArray[0].y-ptArray[contours2->total-1].y)<=1)) cyclic=1;
			if(cyclic) vonalfeaturenumber=features(ptArray,contours2->total,&vonalMaximums,&vonalPeek2,&vonalCurve2,&vonalDirections,&vonalCenter2);
			else vonalfeaturenumber=features2(ptArray,contours2->total,&vonalMaximums,&vonalPeek2,&vonalCurve2,&vonalDirections,&vonalCenter2);

			double **temp=(double **)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double*));
			for(int i1=0;i1<profilesallnumber;i1++) temp[i1]=profilesall[i1];
			double *tempcentx=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *tempcenty=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *tempdirection=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *temppeekx=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *temppeeky=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *tempcurve=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			int *temporigin=(int*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(int));
			double *temppitch=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *tempyaw=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));
			double *templength=(double*)calloc(vonalfeaturenumber+profilesallnumber,sizeof(double));				
			for(int i1=0;i1<profilesallnumber;i1++){ 
				tempcentx[i1]=profilesallcentx[i1]; 
				tempcenty[i1]=profilesallcenty[i1]; 
				tempdirection[i1]=profilesalldirection[i1]; 
				temppeekx[i1]=profilesallpeekx[i1]; 
				temppeeky[i1]=profilesallpeeky[i1];
				tempcurve[i1]=profilesallcurve[i1];
				temporigin[i1]=profilesallorigin[i1];
				temppitch[i1]=profilesallpitch[i1]; 
				tempyaw[i1]=profilesallyaw[i1];
				templength[i1]=profilesalllength[i1];
			}

			//calculating & storing radius profiles
			double *vonallength = (double*)calloc(vonalfeaturenumber , sizeof(double) );				

			for(int i1=0;i1<vonalfeaturenumber;i1++){

				double *radiusspectrum=(double*)calloc(2*Nsp+1 , sizeof(double) );

				if(cyclic){ 
					vonallength[i1] =  getradiusspectrum(ptArray,contours2->total,vonalPeek2[i1],vonalCurve2[i1],vonalDirections[i1],vonalCenter2[i1],radiusspectrum, image5);
				}else{
					vonallength[i1] = getradiusspectrum2(ptArray,contours2->total,vonalPeek2[i1],vonalCurve2[i1],vonalDirections[i1],vonalCenter2[i1],radiusspectrum, image5);
				}					

				temp[profilesallnumber+i1]=radiusspectrum;
				tempcentx[profilesallnumber+i1]=traincentx[i]-vonalPeek2[i1].x;
				tempcenty[profilesallnumber+i1]=traincenty[i]-vonalPeek2[i1].y;
				tempdirection[profilesallnumber+i1]=vonalDirections[i1];
				temppeekx[profilesallnumber+i1]=vonalPeek2[i1].x;
				temppeeky[profilesallnumber+i1]=vonalPeek2[i1].y;
				tempcurve[profilesallnumber+i1]=vonalCurve2[i1];
				temporigin[profilesallnumber+i1]=i;
				temppitch[profilesallnumber+i1]=trainpitch[i];
				tempyaw[profilesallnumber+i1]=trainyaw[i];
				templength[profilesallnumber+i1]=vonallength[i1];

				cvCircle(image5,cvPoint(vonalPeek2[i1].x,vonalPeek2[i1].y),5,CV_RGB(0,0,255),1,8,0);

			}
			if(profilesallnumber>0){ 
				free(profilesall); 
				free(profilesallcentx); free(profilesallcenty); free(profilesalldirection);
				free(profilesallpeekx); free(profilesallpeeky); free(profilesallcurve);
				free(profilesallorigin); free(profilesallpitch); free(profilesallyaw);
				free(profilesalllength);
			}
			profilesall=temp;
			profilesallcentx=tempcentx;
			profilesallcenty=tempcenty;
			profilesalldirection=tempdirection;
			profilesallpeekx=temppeekx;
			profilesallpeeky=temppeeky;
			profilesallcurve=tempcurve;
			profilesallorigin=temporigin;
			profilesallpitch=temppitch;
			profilesallyaw=tempyaw;
			profilesalllength=templength;

			profilesallnumber+=vonalfeaturenumber;
			printf("profilesallnumber;%d\n",profilesallnumber);

#ifdef	labels			
			int szin1=(rand()&255);
			int szin2=(rand()&255);
			int szin3=(rand()&255);


			for(j=0;j<contours2->total;j++)			
			{
				cvSet2D( image5, ptArray[j].y,ptArray[j].x ,CV_RGB( szin1,szin2,szin3)); 
			}

			edge_count++;

			//cvShowImage( "contours",image5);

#endif

			if(vonalfeaturenumber>0){ 
				free(vonalMaximums); free(vonalPeek2); free(vonalCurve2); free(vonalDirections); free(vonalCenter2); free(vonallength);
			}
			free( ptArray );   
		}		
	}

	//saving phase0 results (radius profiles)
	sprintf_s (filename, "phase0.res");
	printf("Saving zeroth phase results to %s...\n",filename);
	FILE *fp;
	errno_t err;
	if( (err  = fopen_s( &fp, filename, "w" )) !=0 ){
		printf("Unable to open %s\n",filename);	
		return 3;
	}
	fprintf( fp, "%d ",profilesallnumber);
	for(i=0;i<profilesallnumber;i++) for(j=0;j<2*Nsp+1;j++) fprintf( fp, "%g ",profilesall[i][j]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallcentx[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallcenty[i]);	
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesalldirection[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallpeekx[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallpeeky[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallcurve[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%d ",profilesallorigin[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallpitch[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesallyaw[i]);
	for(i=0;i<profilesallnumber;i++) fprintf( fp, "%g ",profilesalllength[i]);

	fclose( fp );
	//printf("ready\n");
	for(i=0;i<profilesallnumber;i++) free(profilesall[i]);  //releasing memory
	free(profilesall);
	free(profilesallcentx);
	free(profilesallcenty);
	free(profilesalldirection);
	free(profilesallpeekx);
	free(profilesallpeeky);
	free(profilesallcurve);
	free(profilesallorigin);
	free(profilesallpitch);
	free(profilesallyaw);
	free(profilesalllength);

	//clustering (deleting too similar feature candidates)(phase 2)

	//loading phase0 results
	sprintf_s (filename, "phase0.res");
	printf("Loading phase0 results from %s...\n",filename);
	//FILE *fp;
	//errno_t err;
	if( (err  = fopen_s( &fp, filename, "r" )) !=0 ){
		printf("Unable to open %s\n",filename);	
		return 3;
	}
	fscanf_s( fp, "%d ",&profilesallnumber);
	profilesall=(double**)calloc(profilesallnumber,sizeof(double*));
	for(i=0;i<profilesallnumber;i++) profilesall[i]=(double*)calloc(2*Nsp+1,sizeof(double));
	profilesallcentx=(double*)calloc(profilesallnumber,sizeof(double));
	profilesallcenty=(double*)calloc(profilesallnumber,sizeof(double));
	profilesalldirection=(double*)calloc(profilesallnumber,sizeof(double));
	profilesallpeekx=(double*)calloc(profilesallnumber,sizeof(double));
	profilesallpeeky=(double*)calloc(profilesallnumber,sizeof(double));
	profilesallcurve=(double*)calloc(profilesallnumber,sizeof(double));
	profilesallorigin=(int*)calloc(profilesallnumber,sizeof(int));
	profilesallpitch=(double*)calloc(profilesallnumber,sizeof(double));
	profilesallyaw=(double*)calloc(profilesallnumber,sizeof(double));
	profilesalllength=(double*)calloc(profilesallnumber,sizeof(double));

	float scan4; 
	for(i=0;i<profilesallnumber;i++) for(j=0;j<2*Nsp+1;j++) {fscanf_s( fp, "%g ",&scan4); profilesall[i][j]=(double) scan4;}
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallcentx[i]=(double) scan4;}
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallcenty[i]=(double) scan4;}
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesalldirection[i]=(double) scan4; }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallpeekx[i]=(double) scan4; }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallpeeky[i]=(double) scan4; }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallcurve[i]=(double) scan4; }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%d ",&profilesallorigin[i]); }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallpitch[i]=(double) scan4; }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallyaw[i]=(double) scan4; }
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesalllength[i]=(double) scan4; }

	fclose(fp);

	//clustering
	double **distance=(double**)calloc( profilesallnumber, sizeof(double*) );  //distances of contour candidates of each other
	for(i=0;i<profilesallnumber;i++) distance[i]=(double*)calloc(profilesallnumber , sizeof(double) );
	//printf("Calculating line segment distances...\n");
	start = clock();

	//printf("profilesallnumber = %d\n",profilesallnumber);

	//FLANN
	cv::Mat matD(cv::Size(2*Nsp+1,profilesallnumber), CV_32FC1);
	for(j=0;j<profilesallnumber;j++){
		for(i=0;i<2*Nsp+1;i++){
			matD.at<float>(j,i) = (float)profilesall[j][i];
		}
	}

	// find nearest neighbors using FLANN
	cv::flann::Index flann_index(matD, cv::flann::KDTreeIndexParams(4));  // using 4 randomized kdtrees

	int* indices_ptr;
	float* dists_ptr;	

	int i2,i3;

	for(i3=0;i3<profilesallnumber;i3++){
		for(i2=0;i2<profilesallnumber;i2++){
			distance[i3][i2] = 100000;
		}
	}
	//choosing every fit with FLANN
	if(profilesallnumber > 10){
		for(i3=0;i3<profilesallnumber;i3++){
			cv::Mat matE(cv::Size(2*Nsp+1, 1), CV_32FC1);
			cv::Mat m_indices(1, 10, CV_32S);  //NG[摜~2̍s
			cv::Mat m_dists(1, 10, CV_32F);
			for(i2=0;i2<2*Nsp+1;i2++){
				matE.at<float>(0,i2) = (float)profilesall[i3][i2];
			}
			flann_index.knnSearch(matE, m_indices, m_dists, 10, cv::flann::SearchParams(73) ); // maximum number of leafs checked
			indices_ptr = m_indices.ptr<int>(0);
			dists_ptr = m_dists.ptr<float>(0);

			int tmp_idx; 
			float tmp_dist; 

			//storing results
			for(i2=0;i2<10;i2++) {
				tmp_idx = indices_ptr[i2];
				tmp_dist = dists_ptr[i2];
				distance[i3][tmp_idx]=(double)tmp_dist;
			}
		}			
	}


	for(int i1=0;i1<profilesallnumber;i1++)  // making the matrix symmetical
		for(int i2=0;i2<profilesallnumber;i2++)
			distance[i1][i2]=max(distance[i1][i2],distance[i2][i1]);
	end = clock();
	//printf("distance calculaion time:%g\n",(double)( end - start )/CLOCKS_PER_SEC);
	//printf("Clustering...\n");
	start = clock();
	int *cluster;  // clusters' representative elements
	cluster=(int*)calloc( profilesallnumber, sizeof(int) );
	for(i=0;i<profilesallnumber;i++) cluster[i]=i;
	int clusternumber=profilesallnumber;

	while(1){  // agglomerative hierarchical clustering
		//searching smallest distance
		if(clusternumber==1) break;
		double distancemin=1000000000.0; //distance[0][1];
		int min1=0,min2=1;
		for(int i1=0;i1<clusternumber;i1++)
			for(int i2=0;i2<clusternumber;i2++){ 
				if(i1==i2) continue;
				if(profilesallorigin[cluster[i1]]==profilesallorigin[cluster[i2]]){ // the profiles are from the same training image (very strict condition)

					if(distance[i1][i2]<distancemin){ 
						double temprotatedcentxi1=profilesallcentx[cluster[i1]]*cos(-profilesallyaw[cluster[i1]])-profilesallcenty[cluster[i1]]*sin(-profilesallyaw[cluster[i1]]);
						double temprotatedcentyi1=profilesallcentx[cluster[i1]]*sin(-profilesallyaw[cluster[i1]])+profilesallcenty[cluster[i1]]*cos(-profilesallyaw[cluster[i1]]);
						double temprotatedcentxi2=profilesallcentx[cluster[i2]]*cos(-profilesallyaw[cluster[i2]])-profilesallcenty[cluster[i2]]*sin(-profilesallyaw[cluster[i2]]);
						double temprotatedcentyi2=profilesallcentx[cluster[i2]]*sin(-profilesallyaw[cluster[i2]])+profilesallcenty[cluster[i2]]*cos(-profilesallyaw[cluster[i2]]);
						if(sqrt((temprotatedcentxi1-temprotatedcentxi2)*(temprotatedcentxi1-temprotatedcentxi2)
							+(temprotatedcentyi1-temprotatedcentyi2)*(temprotatedcentyi1-temprotatedcentyi2))<5 ||
							sqrt((temprotatedcentxi1+temprotatedcentxi2)*(temprotatedcentxi1+temprotatedcentxi2)  // because yaw goes from 0 to pi only
							+(temprotatedcentyi1+temprotatedcentyi2)*(temprotatedcentyi1+temprotatedcentyi2))<5 ){

								distancemin=distance[i1][i2];
								min1=i1;
								min2=i2;


						}
					}
				}
			}
			//merging clusters
			if(distancemin<THcl){

				for(int i1=0;i1<clusternumber;i1++)	distance[min1][i1]=max(distance[min1][i1],distance[min2][i1]);
				for(int i1=0;i1<clusternumber;i1++)	distance[i1][min1]=max(distance[i1][min1],distance[i1][min2]);
				//matrix shrink
				for(int i1=min2;i1<clusternumber-1;i1++)
					for(int i2=0;i2<clusternumber;i2++){
						//printf("i1:%d i2:%d  ",i1,i2);
						distance[i1][i2]=distance[i1+1][i2];
					}
					for(int i1=min2;i1<clusternumber-1;i1++)
						for(int i2=0;i2<clusternumber;i2++)
							distance[i2][i1]=distance[i2][i1+1];	
					//cluster
					for(int i1=min2;i1<clusternumber-1;i1++) cluster[i1]=cluster[i1+1];
					//clusternumber
					clusternumber--;
					//printf("ready. new clusternumber:%d\n",clusternumber);
					continue;
			}		
			break;
	}

	// reindexing remaining contour
	double **profilesall2;
	double *profilesallcentx2;
	double *profilesallcenty2;
	double *profilesalldirection2;
	double *profilesallpeekx2;
	double *profilesallpeeky2;
	double *profilesallcurve2;
	int *profilesallorigin2;
	double *profilesallpitch2;
	double *profilesallyaw2;
	double *profilesalllength2;	

	int profilesallnumber2=clusternumber;
	//printf("number of final clusters:%d\n",clusternumber);
	profilesall2=(double**)calloc(profilesallnumber2,sizeof(double*));
	for(i=0;i<profilesallnumber2;i++) profilesall2[i]=(double*)calloc(2*Nsp+1,sizeof(double));
	profilesallcentx2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesallcenty2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesalldirection2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesallpeekx2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesallpeeky2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesallcurve2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesallorigin2=(int*)calloc(profilesallnumber2,sizeof(int));
	profilesallpitch2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesallyaw2=(double*)calloc(profilesallnumber2,sizeof(double));
	profilesalllength2=(double*)calloc(profilesallnumber2,sizeof(double));		
	for(i=0;i<profilesallnumber2;i++){
		profilesall2[i]=profilesall[cluster[i]];
		profilesallcentx2[i]	=profilesallcentx[cluster[i]];
		profilesallcenty2[i]	=profilesallcenty[cluster[i]];
		profilesalldirection2[i]=profilesalldirection[cluster[i]];
		profilesallpeekx2[i]=profilesallpeekx[cluster[i]];
		profilesallpeeky2[i]=profilesallpeeky[cluster[i]];
		profilesallcurve2[i]=profilesallcurve[cluster[i]];
		profilesallorigin2[i]	=profilesallorigin[cluster[i]];
		profilesallpitch2[i]	=profilesallpitch[cluster[i]];
		profilesallyaw2[i]		=profilesallyaw[cluster[i]];
		profilesalllength2[i]	=profilesalllength[cluster[i]];		
	}
	free(cluster);
	for(i=0;i<profilesallnumber;i++) free(distance[i]);
	free(distance);
	end = clock();
	//printf("clustering time:%g\n",(double)( end - start )/CLOCKS_PER_SEC);

	//saving phase2 results
	sprintf_s (filename, "phase2.res");
	printf("Saving second phase results to %s...\n",filename);
	if( (err  = fopen_s( &fp, filename, "w" )) !=0 ){
		printf("Unable to open %s\n",filename);	
		return 3;
	}
	fprintf( fp, "%d ",profilesallnumber2);
	for(i=0;i<profilesallnumber2;i++) for(j=0;j<2*Nsp+1;j++) fprintf( fp, "%g ",profilesall2[i][j]);
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallcentx2[i]);
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallcenty2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesalldirection2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallpeekx2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallpeeky2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallcurve2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%d ",profilesallorigin2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallpitch2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesallyaw2[i]);	
	for(i=0;i<profilesallnumber2;i++) fprintf( fp, "%g ",profilesalllength2[i]);	

	fclose( fp );
	//printf("ready\n");
	for(i=0;i<profilesallnumber2;i++) free(profilesall2[i]);  //releasing memory
	free(profilesall2);
	free(profilesallcentx2);
	free(profilesallcenty2);
	free(profilesalldirection2);
	free(profilesallpeekx2);
	free(profilesallpeeky2);
	free(profilesallcurve2);
	free(profilesallorigin2);
	free(profilesallpitch2);
	free(profilesallyaw2);
	free(profilesalllength2);


	cvReleaseImage(&image);
	cvReleaseImage(&image2);
	cvReleaseImage(&image3);
	cvReleaseImage(&image4);
	cvReleaseImage(&image5);
	cvReleaseImage(&img);
	cvReleaseImage(&disimage);
	cvReleaseImage(&bufimage);

	for(i=0;i<Ltrain;i++) cvReleaseImage(&train[i]);

	return 0;
}