#include <opencv/cv.h>
#include "MakeRotation.h"

void MakeRotation(double mat[20], double grx, double gry, double roll, double pitch, double yaw){

	//y]
	CvMat *Rot_roll = cvCreateMat(3,3,CV_32FC1);
	cvmSet(Rot_roll,0,0,cos(roll));
	cvmSet(Rot_roll,0,1,-sin(roll));
	cvmSet(Rot_roll,0,2,0);
	cvmSet(Rot_roll,1,0,sin(roll));
	cvmSet(Rot_roll,1,1,cos(roll));
	cvmSet(Rot_roll,1,2,0);
	cvmSet(Rot_roll,2,0,0);
	cvmSet(Rot_roll,2,1,0);
	cvmSet(Rot_roll,2,2,1);

	//x]
	CvMat *Rot_pitch = cvCreateMat(3,3,CV_32FC1);
	cvmSet(Rot_pitch,0,0,cos(pitch));
	cvmSet(Rot_pitch,0,1,0);
	cvmSet(Rot_pitch,0,2,-sin(pitch));
	cvmSet(Rot_pitch,1,0,0);
	cvmSet(Rot_pitch,1,1,1);
	cvmSet(Rot_pitch,1,2,0);
	cvmSet(Rot_pitch,2,0,sin(pitch));
	cvmSet(Rot_pitch,2,1,0);
	cvmSet(Rot_pitch,2,2,cos(pitch));

	//w]
	CvMat *Rot_yaw = cvCreateMat(3,3,CV_32FC1);
	cvmSet(Rot_yaw,0,0,1);
	cvmSet(Rot_yaw,0,1,0);
	cvmSet(Rot_yaw,0,2,0);
	cvmSet(Rot_yaw,1,0,0);
	cvmSet(Rot_yaw,1,1,cos(yaw));
	cvmSet(Rot_yaw,1,2,-sin(yaw));
	cvmSet(Rot_yaw,2,0,0);
	cvmSet(Rot_yaw,2,1,sin(yaw));
	cvmSet(Rot_yaw,2,2,cos(yaw));

	CvMat *Tmp3 = cvCreateMat(3,3,CV_32FC1);
	CvMat *Tmp4 = cvCreateMat(3,3,CV_32FC1);

	cvmMul(Rot_pitch,Rot_yaw,Tmp3);	
	cvmMul(Rot_roll,Tmp3,Tmp4);

    //he
	mat[0]  = 0;
	mat[1]  = 0;
	mat[2]  = 0;
	mat[3]  = 0;
	mat[4]  = 0;
	mat[5]  = 0;
	mat[6]  = 0;
	mat[7]  = 0;
	mat[8]  = cvGet2D(Tmp4,0,0).val[0];
	mat[9]  = cvGet2D(Tmp4,0,1).val[0];
	mat[10] = cvGet2D(Tmp4,0,2).val[0];
	mat[11] = grx; 
	mat[12] = cvGet2D(Tmp4,1,0).val[0];
	mat[13] = cvGet2D(Tmp4,1,1).val[0];
	mat[14] = cvGet2D(Tmp4,1,2).val[0];
	mat[15] = gry;
	mat[16] = cvGet2D(Tmp4,2,0).val[0];
	mat[17] = cvGet2D(Tmp4,2,1).val[0];
	mat[18] = cvGet2D(Tmp4,2,2).val[0];
	mat[19] = 0;
}