// -*- C++ -*-
/*!
 * @file  PartialEdge.cpp
 * @brief ModuleDescription
 * @date $Date$
 *
 * $Id$
 */

#include "PartialEdge.h"
#include "Spectrum.h"

// Module specification
// <rtc-template block="module_spec">
static const char* partialedge_spec[] =
  {
    "implementation_id", "PartialEdge",
    "type_name",         "PartialEdge",
    "description",       "ModuleDescription",
    "version",           "1.0.0",
    "vendor",            "TSB",
    "category",          "Category",
    "activity_type",     "PERIODIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    ""
  };
// </rtc-template>

PartialEdge::PartialEdge(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
		m_ModelID(1),
    m_positionOut("position", m_position),
    m_triggerPort("trigger"),
		m_recogPort(&m_ModelID),
    // </rtc-template>
		dummy(0)
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  
  // Set OutPort buffer
  registerOutPort("position", m_positionOut);
  
  // Set service provider to Ports
  m_triggerPort.registerProvider("recogPort", "RecognitionService", m_recogPort);
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  registerPort(m_triggerPort);
  
  // </rtc-template>

}

PartialEdge::~PartialEdge()
{
}


/*
RTC::ReturnCode_t PartialEdge::onInitialize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


RTC::ReturnCode_t PartialEdge::onActivated(RTC::UniqueId ec_id)
{
  if (SpectrumInit() == false) return RTC::RTC_ERROR;

  return RTC::RTC_OK;
}



RTC::ReturnCode_t PartialEdge::onDeactivated(RTC::UniqueId ec_id)
{
  SpectrumFinish();

  return RTC::RTC_OK;
}



RTC::ReturnCode_t PartialEdge::onExecute(RTC::UniqueId ec_id)
{
  double result[20];
  SpectrumProcess(result);

  long j;
  m_position.data.length(20);
  for(j=0;j<20;j++){
	m_position.data[j] = result[j];
  }
  m_positionOut.write(m_position); 	
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t PartialEdge::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdge::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{
 
  void PartialEdgeInit(RTC::Manager* manager)
  {
    RTC::Properties profile(partialedge_spec);
    manager->registerFactory(profile,
                             RTC::Create<PartialEdge>,
                             RTC::Delete<PartialEdge>);
  }
  
};


