#include <opencv/cv.h>
#include <opencv/highgui.h>
#include <stdio.h>

#define _USE_MATH_DEFINES
#include <math.h>

#include "main.h"

int keret[4];  // to store the bounding box of the object minx,miny,maxx,maxy
int saveneeded=0;
int possearch=0;

void on_mouse( int event, int x, int y, int flags, void* param )
{
	if( event == CV_EVENT_LBUTTONDOWN )
	{
		int d1=(x-keret[0])*(x-keret[0])+(y-keret[1])*(y-keret[1]);  //top left
		int d2=(x-keret[2])*(x-keret[2])+(y-keret[1])*(y-keret[1]);  //top right
		int d3=(x-keret[0])*(x-keret[0])+(y-keret[3])*(y-keret[3]);  //bottom left
		int d4=(x-keret[2])*(x-keret[2])+(y-keret[3])*(y-keret[3]);  //bottom right
		int dmin=d1; int mincorner=1;
		if(d2<dmin){dmin=d2; mincorner=2;}
		if(d3<dmin){dmin=d3; mincorner=3;}
		if(d4<dmin){dmin=d4; mincorner=4;}
		if(mincorner==1){
			keret[0]=x;
			keret[1]=y;
		}
		else if(mincorner==2){
			keret[2]=x;
			keret[1]=y;
		}
		else if(mincorner==3){
			keret[0]=x;
			keret[3]=y;
		}
		else{
			keret[2]=x;
			keret[3]=y;
		}
		saveneeded=1;
		possearch=1;
	}
	if( event == CV_EVENT_RBUTTONDOWN )
	{
		int d1=(x-keret[0])*(x-keret[0]);  //left
		int d2=(x-keret[2])*(x-keret[2]);  //right
		int d3=(y-keret[1])*(y-keret[1]);  //top
		int d4=(y-keret[3])*(y-keret[3]);  //bottom
		int dmin=d1; int mincorner=1;
		if(d2<dmin){dmin=d2; mincorner=2;}
		if(d3<dmin){dmin=d3; mincorner=3;}
		if(d4<dmin){dmin=d4; mincorner=4;}
		if(mincorner==1){
			keret[0]=x;
		}
		else if(mincorner==2){
			keret[2]=x;
		}
		else if(mincorner==3){
			keret[1]=y;
		}
		else{
			keret[3]=y;
		}
		saveneeded=1;
		possearch=1;
	}
}

int PictureSaver()
{
	// Canny threshold
	int TH_1 = 50;
	int TH_2 = 130;

	IplImage *frame0 = 0; 
	IplImage *frame = 0;  //captured frame

	frame = cvCreateImage( cvSize( Iwidth, Iheight ), IPL_DEPTH_8U, 3 );

	IplImage *image = 0;  //Black and White image
	IplImage *image2 = 0; //copy of image inversed
	IplImage *image3 = 0;
	IplImage *image4 = 0;
	IplImage *image5 = 0;  //to store the frame of the object
	IplImage *img = 0;
	IplImage *disimage = 0;  //distance transformed image
	IplImage *bufimage = 0;  //for temporary calculations
	int kepszam=-1; // saving the images starting from above this number 

	int keret2[4];  //earlier box
	double pitch=0,pitch2=0; // pitch rotation (degree)
	double yaw=0,yaw2=0; // yaw rotation (radian)

	CvSeq* contours = 0;

	clock_t start, end;  //to calculate framerate
	double clockavg=0.05; //exponentially relaxed time average fot the frame rate

	int kiirva=0; // writing initial parameters on the screen only once
	int c;   // pressed key
	int i,j; // for cycles
	char filename [50];

	CvMemStorage* storagesave = cvCreateMemStorage(0);
	CvSeq* contourstemp = 0;


	//Capture round
	CvCapture *capture = 0;

	capture = cvCaptureFromCAM( 0 );

	//Error
	if( !capture ){
		fprintf( stderr, "Could not initialize capturing...\n");
		return -1;
	}

	printf("s - Save an image & search object frame\n");
	printf("ESC - Start recognition \n");

	//printf("1 - move frame's LEFT border LEFT\n");
	//printf("2 - move frame's LEFT border RIGHT\n");
	//printf("3 - move frame's UPPER border UP\n");
	//printf("4 - move frame's UPPER border DOWN\n");
	//printf("5 - move frame's RIGHT border LEFT\n");
	//printf("6 - move frame's RIGHT border RIGHT\n");
	//printf("7 - move frame's LOWER border UP\n");
	//printf("8 - move frame's LOWER border DOWN\n");
	//printf("9 - decrease next picture's number\n");
	//printf("0 - increase next picture's number\n");
	//printf("Y - use last saved object's border\n");
	//printf("I - move frame up\n");
	//printf("J - move frame left\n");
	//printf("K - move frame right\n");
	//printf("M - move frame down\n");
	//printf("Q - decrease pitch(or roll) value\n");
	//printf("W - increase pitch(or roll) value\n");
	//printf("E - rotate left by 0.5 degree\n");
	//printf("R - rotate right by 0.5 degree\n");
	//printf("D - rotate left by 10 degrees\n");
	//printf("F - rotate right by 10 degrees\n");
	//printf("T - rotate right by 90 degrees\n");
	//printf("mouse left click - move closest corner\n");
	//printf("mouse right click - move closest line\n");

	cvNamedWindow( "frame", 1 );
	cvNamedWindow( "canny", 1 );
	cvNamedWindow( "contours", 1 );
	cvNamedWindow( "contours2", 1 );
	cvSetMouseCallback( "contours2", on_mouse, 0 );

	// Canny_Threshold
	cvCreateTrackbar("Canny_1","canny",&TH_1,256);
	cvCreateTrackbar("Canny_2","canny",&TH_2,256);

	start = clock();
	while(1){ // main cycle

		frame0 = cvQueryFrame( capture ); //Read frame
		if( !frame0 )
			break;
		cvResize(frame0, frame, CV_INTER_LINEAR);	

		//Secure image memory
		if( !image ){
			printf("width:%d height:%d\n",frame->width, frame->height);
			image = cvCreateImage( cvSize( frame->width, frame->height ), IPL_DEPTH_8U, 1 );
			image2 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );			
			image3 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
			image4 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
			image5 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
			img = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
			disimage = cvCreateImage( cvGetSize( image ), IPL_DEPTH_32F, 1 );
			bufimage = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
		}

		//Grayscale conversion, edge extraction
		cvCvtColor( frame, image, CV_BGR2GRAY );
		cvSmooth( image, image, CV_GAUSSIAN, 7, 7 );
		cvCanny( image, image, TH_1, TH_2, 3 );
		cvCopy(image,image2);

		//Contour extraction
		cvCopy(image,img);
		int contours_num;
		CvMemStorage* storage = cvCreateMemStorage(0);
		contours_num = cvFindContours( img, storage, &contourstemp, sizeof(CvContour),
			CV_RETR_LIST, CV_CHAIN_APPROX_NONE, cvPoint(0,0) );
		CvSeq* contours2 = contourstemp;
		cvZero( image4 );		

		for( ; contours2 != 0; contours2 = contours2->h_next )
		{
			CvPoint *ptArray;
			if(contours2->total<50){
				cvClearSeq(contours2);
			}
			ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
			cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);
			for(i=0;i<contours2->total;i++)			
			{
				cvSetReal2D( image4, ptArray[i].y,ptArray[i].x ,255 );			
			}
			free( ptArray );   
		}
		kiirva=1;

		end = clock();
		clockavg=clockavg*0.8+0.2*(double)( end - start )/CLOCKS_PER_SEC;
		cvShowImage( "frame",frame);
		cvShowImage( "canny",image);

		cvShowImage( "contours",image4); // contours found without the short ones
		start = clock();

		c = cvWaitKey(10);
		if( c == 27 )
			break;
		else if (c=='s'){
			kepszam++;
			printf("saving image #%d...\n",kepszam);

			contours_num = cvFindContours( img, storagesave, &contours, sizeof(CvContour),
				CV_RETR_LIST, CV_CHAIN_APPROX_NONE, cvPoint(0,0) );
			CvSeq* contours2 = contours;
			for( ; contours2 != 0; contours2 = contours2->h_next )
			{
				if(contours2->total<50){
					cvClearSeq(contours2);
				}  
			}

			sprintf_s (filename, "train\\pic%03d.png", kepszam);
			cvSaveImage( filename, frame );
			sprintf_s (filename, "train\\pic%03dcanny.png", kepszam);
			cvSaveImage( filename, image );
			sprintf_s (filename, "train\\pic%03dcont.png", kepszam);
			cvSaveImage( filename, image4 );	
			cvCopy(image4,image5);

			//searching the bounding box automatically
			contours2=contours;
			keret2[0]=keret[0];keret2[1]=keret[1];keret2[2]=keret[2];keret2[3]=keret[3]; pitch2=pitch;yaw2=yaw;
			keret[0]=frame->width-1;
			keret[1]=frame->height-1;
			keret[2]=0;
			keret[3]=0;
			int innercontours=0; // contours inside 100x100 center of the image
			for( ; contours2 != 0; contours2 = contours2->h_next )
			{
				CvPoint *ptArray;
				ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
				cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);

				for(i=0;i<contours2->total;i++)			
				{
					cvSetReal2D( image4, ptArray[i].y,ptArray[i].x ,255 );			
					if((ptArray[i].y>=frame->height/2-75) && (ptArray[i].y<=frame->height/2+75)
						&& (ptArray[i].x>=frame->width/2-75) && (ptArray[i].x<=frame->width/2+75)){
							innercontours++;
							for(j=0;j<contours2->total;j++){
								if(ptArray[j].x<keret[0]) keret[0]=ptArray[j].x;
								if(ptArray[j].x>keret[2]) keret[2]=ptArray[j].x;
								if(ptArray[j].y<keret[1]) keret[1]=ptArray[j].y;
								if(ptArray[j].y>keret[3]) keret[3]=ptArray[j].y;
							}		
							break;
					}
				}

				free( ptArray );   
			}

			printf("minx:%d miny:%d maxx:%d maxy:%d\n",keret[0],keret[1],keret[2],keret[3]);
			//searching yaw value
			double tempcentx=(double)(keret[0]+keret[2])/2;
			double tempcenty=(double)(keret[1]+keret[3])/2;
			double yawdistmax=0;
			for(double angle=0;angle<M_PI;angle+=M_PI/180.0/2.0){
				double distmax=0;
				contours2=contours;
				for( ; contours2 != 0; contours2 = contours2->h_next ){
					CvPoint *ptArray;
					ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
					cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);

					for(i=0;i<contours2->total;i++){
						if(ptArray[i].x<keret[0]) continue;  //searching only within the bounding frame
						if(ptArray[i].x>keret[2]) continue;
						if(ptArray[i].y<keret[1]) continue;
						if(ptArray[i].y>keret[3]) continue;
						double dist1=(ptArray[i].x-tempcentx)*cos(angle)+(ptArray[i].y-tempcenty)*sin(angle);

						distmax+=dist1*dist1;
					}
					free( ptArray );   
				}
				if(yawdistmax<distmax){
					yawdistmax=distmax;
					yaw=angle;
				}
			}
			//searching bounding rectangle
			double dista=0,distb=0,distc=0,distd=0; // rotated bounding rectangle distances from the center
			contours2=contours;
			for( ; contours2 != 0; contours2 = contours2->h_next ){
				CvPoint *ptArray;
				ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
				cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);

				for(i=0;i<contours2->total;i++){
					if(ptArray[i].x<keret[0]) continue;  //searching only within the bounding frame
					if(ptArray[i].x>keret[2]) continue;
					if(ptArray[i].y<keret[1]) continue;
					if(ptArray[i].y>keret[3]) continue;

					double dist1=(ptArray[i].x-tempcentx)*cos(yaw)+(ptArray[i].y-tempcenty)*sin(yaw);
					if(dist1>dista) dista=dist1;
					if(-dist1>distb) distb=-dist1;
					dist1=(ptArray[i].x-tempcentx)*cos(yaw-M_PI/2)+(ptArray[i].y-tempcenty)*sin(yaw-M_PI/2);
					if(dist1>distc) distc=dist1;
					if(-dist1>distd) distd=-dist1;
				}
				free( ptArray );   
			}

			for ( i=keret[0];i<=keret[2];i++ ){
				cvSetReal2D( image5, keret[1], i,255-cvGetReal2D( image5, keret[1], i) );  //y,x!
				cvSetReal2D( image5, keret[3], i,255-cvGetReal2D( image5, keret[3], i) );
			}
			for ( i=keret[1];i<=keret[3];i++ ){
				cvSetReal2D( image5, i,keret[0],255-cvGetReal2D( image5, i,keret[0]) );  //y,x!
				cvSetReal2D( image5, i,keret[2],255-cvGetReal2D( image5, i,keret[2]) );
			}
			tempcentx=(double)(keret[0]+keret[2])/2;
			tempcenty=(double)(keret[1]+keret[3])/2;
			cvLine(image5,cvPoint((int)tempcentx,(int)tempcenty),cvPoint((int)(tempcentx+70*cos(yaw)),(int)(tempcenty+70*sin(yaw))),cvScalar(255) );
			cvLine(image5,cvPoint((int)tempcentx,(int)tempcenty),cvPoint((int)(tempcentx+30*cos(yaw-M_PI/2)),(int)(tempcenty+30*sin(yaw-M_PI/2))),cvScalar(255) );
			//drawing rotated bounding rectangle
			//printf("dista:%g distb:%g distc:%g distd:%g\n",dista,distb,distc,distd);
			cvLine(image5,cvPoint((int)(tempcentx+cos(yaw)*dista+cos(yaw-M_PI/2)*distc),(int)(tempcenty+sin(yaw)*dista+sin(yaw-M_PI/2)*distc)),
				cvPoint((int)(tempcentx-cos(yaw)*distb+cos(yaw-M_PI/2)*distc),(int)(tempcenty-sin(yaw)*distb+sin(yaw-M_PI/2)*distc)),cvScalar(100) );
			cvLine(image5,cvPoint((int)(tempcentx+cos(yaw)*dista-cos(yaw-M_PI/2)*distd),(int)(tempcenty+sin(yaw)*dista-sin(yaw-M_PI/2)*distd)),
				cvPoint((int)(tempcentx-cos(yaw)*distb-cos(yaw-M_PI/2)*distd),(int)(tempcenty-sin(yaw)*distb-sin(yaw-M_PI/2)*distd)),cvScalar(100) );
			cvLine(image5,cvPoint((int)(tempcentx+cos(yaw)*dista+cos(yaw-M_PI/2)*distc),(int)(tempcenty+sin(yaw)*dista+sin(yaw-M_PI/2)*distc)),
				cvPoint((int)(tempcentx+cos(yaw)*dista-cos(yaw-M_PI/2)*distd),(int)(tempcenty+sin(yaw)*dista-sin(yaw-M_PI/2)*distd)),cvScalar(100) );
			cvLine(image5,cvPoint((int)(tempcentx-cos(yaw)*distb+cos(yaw-M_PI/2)*distc),(int)(tempcenty-sin(yaw)*distb+sin(yaw-M_PI/2)*distc)),
				cvPoint((int)(tempcentx-cos(yaw)*distb-cos(yaw-M_PI/2)*distd),(int)(tempcenty-sin(yaw)*distb-sin(yaw-M_PI/2)*distd)),cvScalar(100) );
			cvShowImage( "contours2",image5);
			sprintf_s (filename, "train\\boundingbox%03d.png", kepszam);

			FILE *fp;
			fp = fopen( filename, "w" );
			fprintf( fp, "%d %d %d %d %g %g",keret[0],keret[1],keret[2],keret[3],pitch,yaw);
			printf("yaw:%g \n",yaw*180/M_PI);
			fclose( fp );
			sprintf_s (filename, "train\\pic%03dbox.png", kepszam);
			cvSaveImage( filename, image5 );

		}
		else if(c=='1')	{keret[0]--; saveneeded=1;possearch=1;}
		else if(c=='2')	{keret[0]++; saveneeded=1;possearch=1;}
		else if(c=='3')	{keret[1]--; saveneeded=1;possearch=1;}
		else if(c=='4')	{keret[1]++; saveneeded=1;possearch=1;}
		else if(c=='5')	{keret[2]--; saveneeded=1;possearch=1;}
		else if(c=='6')	{keret[2]++; saveneeded=1;possearch=1;}
		else if(c=='7')	{keret[3]--; saveneeded=1;possearch=1;}
		else if(c=='8')	{keret[3]++; saveneeded=1;possearch=1;}
		else if(c=='9'){kepszam--; printf("next file number:%d\n",kepszam+1);}
		else if(c=='0'){kepszam++; printf("next file number:%d\n",kepszam+1);}
		else if(c=='y'){keret[0]=keret2[0];keret[1]=keret2[1];keret[2]=keret2[2];keret[3]=keret2[3];yaw=yaw2; saveneeded=1;}
		else if(c=='i'){keret[1]--;keret[3]--; saveneeded=1;possearch=1;}
		else if(c=='j'){keret[0]--;keret[2]--; saveneeded=1;possearch=1;}
		else if(c=='k'){keret[0]++;keret[2]++; saveneeded=1;possearch=1;}
		else if(c=='m'){keret[1]++;keret[3]++; saveneeded=1;possearch=1;}
		else if(c=='q'){pitch=pitch-1; saveneeded=1;printf("pitch:%g\n",pitch);}
		else if(c=='w'){pitch=pitch+1; saveneeded=1;printf("pitch:%g\n",pitch);}
		else if(c=='e'){yaw=yaw+M_PI/360.0; if(yaw>=M_PI) yaw-=M_PI; saveneeded=1;printf("yaw:%g\n",yaw*180/M_PI);}
		else if(c=='r'){yaw=yaw-M_PI/360.0; if(yaw<0) yaw+=M_PI; saveneeded=1;printf("yaw:%g\n",yaw*180/M_PI);}
		else if(c=='d'){yaw=yaw+M_PI/18.0; if(yaw>=M_PI) yaw-=M_PI; saveneeded=1;printf("yaw:%g\n",yaw*180/M_PI);}
		else if(c=='f'){yaw=yaw-M_PI/18.0; if(yaw<0) yaw+=M_PI; saveneeded=1;printf("yaw:%g\n",yaw*180/M_PI);}
		else if(c=='t'){yaw=yaw-M_PI/2; if(yaw<0) yaw+=M_PI; saveneeded=1;printf("yaw:%g\n",yaw*180/M_PI);}

		if(possearch){
			double tempcentx=(double)(keret[0]+keret[2])/2;
			double tempcenty=(double)(keret[1]+keret[3])/2;
			double yawdistmax=0;
			for(double angle=0;angle<M_PI;angle+=M_PI/180.0/2.0){
				double distmax=0;
				contours2=contours;
				for( ; contours2 != 0; contours2 = contours2->h_next ){
					CvPoint *ptArray;
					ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
					cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);

					for(i=0;i<contours2->total;i++){
						if(ptArray[i].x<keret[0]) continue;  //searching only within the bounding frame
						if(ptArray[i].x>keret[2]) continue;
						if(ptArray[i].y<keret[1]) continue;
						if(ptArray[i].y>keret[3]) continue;
						double dist1=(ptArray[i].x-tempcentx)*cos(angle)+(ptArray[i].y-tempcenty)*sin(angle);
						distmax+=dist1*dist1;
					}
					free( ptArray );   
				}
				if(yawdistmax<distmax){
					yawdistmax=distmax;
					yaw=angle;
				}
			}
			possearch=0;
		}
		if(saveneeded==1){
			cvCopy(image4,image5);

			for ( i=keret[0];i<=keret[2];i++ ){
				cvSetReal2D( image5, keret[1], i,255-cvGetReal2D( image5, keret[1], i) );  //y,x!
				cvSetReal2D( image5, keret[3], i,255-cvGetReal2D( image5, keret[3], i) );
			}
			for ( i=keret[1];i<=keret[3];i++ ){
				cvSetReal2D( image5, i,keret[0],255-cvGetReal2D( image5, i,keret[0]) );  //y,x!
				cvSetReal2D( image5, i,keret[2],255-cvGetReal2D( image5, i,keret[2]) );
			}			
			double tempcentx=(double)(keret[0]+keret[2])/2;
			double tempcenty=(double)(keret[1]+keret[3])/2;
			//searching bounding rectangle
			double dista=0,distb=0,distc=0,distd=0; // rotated bounding rectangle distances from the center
			contours2=contours;
			for( ; contours2 != 0; contours2 = contours2->h_next ){
				CvPoint *ptArray;
				ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
				cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);
				for(i=0;i<contours2->total;i++){
					if(ptArray[i].x<keret[0]) continue;  //searching only within the bounding frame
					if(ptArray[i].x>keret[2]) continue;
					if(ptArray[i].y<keret[1]) continue;
					if(ptArray[i].y>keret[3]) continue;
					double dist1=(ptArray[i].x-tempcentx)*cos(yaw)+(ptArray[i].y-tempcenty)*sin(yaw);
					if(dist1>dista) dista=dist1;
					if(-dist1>distb) distb=-dist1;
					dist1=(ptArray[i].x-tempcentx)*cos(yaw-M_PI/2)+(ptArray[i].y-tempcenty)*sin(yaw-M_PI/2);
					if(dist1>distc) distc=dist1;
					if(-dist1>distd) distd=-dist1;
				}
				free( ptArray );   
			}
			cvLine(image5,cvPoint((int)tempcentx,(int)tempcenty),cvPoint((int)(tempcentx+70*cos(yaw)),(int)(tempcenty+70*sin(yaw))),cvScalar(255) );
			cvLine(image5,cvPoint((int)tempcentx,(int)tempcenty),cvPoint((int)(tempcentx+30*cos(yaw-M_PI/2)),(int)(tempcenty+30*sin(yaw-M_PI/2))),cvScalar(255) );

			cvLine(image5,cvPoint((int)(tempcentx+cos(yaw)*dista+cos(yaw-M_PI/2)*distc),(int)(tempcenty+sin(yaw)*dista+sin(yaw-M_PI/2)*distc)),
				cvPoint((int)(tempcentx-cos(yaw)*distb+cos(yaw-M_PI/2)*distc),(int)(tempcenty-sin(yaw)*distb+sin(yaw-M_PI/2)*distc)),cvScalar(100) );
			cvLine(image5,cvPoint((int)(tempcentx+cos(yaw)*dista-cos(yaw-M_PI/2)*distd),(int)(tempcenty+sin(yaw)*dista-sin(yaw-M_PI/2)*distd)),
				cvPoint((int)(tempcentx-cos(yaw)*distb-cos(yaw-M_PI/2)*distd),(int)(tempcenty-sin(yaw)*distb-sin(yaw-M_PI/2)*distd)),cvScalar(100) );
			cvLine(image5,cvPoint((int)(tempcentx+cos(yaw)*dista+cos(yaw-M_PI/2)*distc),(int)(tempcenty+sin(yaw)*dista+sin(yaw-M_PI/2)*distc)),
				cvPoint((int)(tempcentx+cos(yaw)*dista-cos(yaw-M_PI/2)*distd),(int)(tempcenty+sin(yaw)*dista-sin(yaw-M_PI/2)*distd)),cvScalar(100) );
			cvLine(image5,cvPoint((int)(tempcentx-cos(yaw)*distb+cos(yaw-M_PI/2)*distc),(int)(tempcenty-sin(yaw)*distb+sin(yaw-M_PI/2)*distc)),
				cvPoint((int)(tempcentx-cos(yaw)*distb-cos(yaw-M_PI/2)*distd),(int)(tempcenty-sin(yaw)*distb-sin(yaw-M_PI/2)*distd)),cvScalar(100) );
			cvShowImage( "contours2",image5);
			sprintf_s (filename, "train\\boundingbox%03d.png", kepszam);
			FILE *fp;
			fp = fopen( filename, "w" );
			fprintf( fp, "%d %d %d %d %g %g",keret[0],keret[1],keret[2],keret[3],pitch,yaw);
			fclose( fp );
			sprintf_s (filename, "train\\pic%03dbox.png", kepszam);
			cvSaveImage( filename, image5 );
			saveneeded=0;
		}
		cvReleaseMemStorage( &storage );


	}// end of main cycle
	// releasing image memory

	cvDestroyWindow("frame");
	cvDestroyWindow("canny");
	cvDestroyWindow("contours");
	cvDestroyWindow("contours2");

	cvReleaseCapture( &capture );
	cvReleaseImage( &image );
	cvReleaseImage( &image2 );
	cvReleaseImage( &image3 );
	cvReleaseImage( &image4 );
	cvReleaseImage( &image5 );
	cvReleaseImage( &img );
	cvReleaseImage( &disimage );
	cvReleaseImage( &bufimage );

	return 0;


}