#include <opencv/cv.h>
#include <opencv/highgui.h>

#define _USE_MATH_DEFINES
#include <math.h>

#include "Learning.h"
#include "MakeRotation.h"
#include "writeFPS.h"
#include "curvature.h"
#include "distance3.h"
#include "Spectrum.h"
#include "main.h"

#define SAFE_FREE(x) {if(x!=NULL){free(x);x=NULL;}}
#define SAFE_DELETE(x) {if(x!=NULL){delete x;x=NULL;}}

#define RATIOMAX 25

// Canny threshold
int TH1 = 20;
int TH2 = 50;	

IplImage *frame = NULL;  //captured frame
IplImage *image = NULL;  //Black and White image
IplImage *image2 = NULL; //copy of image inversed
IplImage *image3 = NULL;
IplImage *image5 = NULL;  //color image of contours
IplImage *imageHough = NULL;  //color image of Hough voting
IplImage *img = NULL;
IplImage *imagemixed = NULL;  // to show camera image and training images
IplImage *imagemixed2 = NULL;  // (backup)
IplImage *modelimage = NULL;
IplImage **train = NULL;

CvSeq* contours = 0;

clock_t start, end;  //to calculate framerate
double clockavg=0.05; //exponentially relaxed time average fot the frame rate
DWORD time0,time1,time2,time3,time4,time5,time6,time7,time8;

double **profilesall = NULL;      // profiles of learning images
double *profilesallcentx = NULL;  // vector from the center of radius to the center of object
double *profilesallcenty = NULL;
double *profilesalldirection = NULL; // direction of the osculating circle
double *profilesallpeekx = NULL;
double *profilesallpeeky = NULL;
double *profilesallcurve = NULL;
int *profilesallorigin = NULL;
double *profilesallpitch = NULL;
double *profilesallyaw = NULL;
double *profilesalllength = NULL;
int profilesallnumber=0;   // number of profiles

double **Houghspace = NULL;  // to store Hough votes
double ***Houghspaceyaw = NULL;  // to store Hough votes for yaw angle
double **HoughGauss = NULL; // the Gauss function used for the Hough-voting
int Houghspace_ratio[RATIOMAX];
CvCapture *capture = NULL;

int trainkeret[Ltrain][4];      // the bounding box of the training objects
int trainoffsetx[Ltrain],trainoffsety[Ltrain];  // how much the training object is pushed from its original position

int trainmaxx1=0;
int trainmaxx2=0;
int trainsumy3=0;

char filename [50];

cv::Mat *matD = NULL;
cv::flann::Index* flann_index = NULL;

bool SpectrumInit()
{
	//Learning the model
	if (Learning() != 0) {
		fprintf(stderr, "Learning() failed...\n");
		return false;
	}

	//Capture round
	capture = cvCaptureFromCAM( 0 );
	//Error
	if( !capture ){
		fprintf( stderr, "Could not initialize capturing...\n");
		return false;
	}

	//Recognition
	int i;

	Houghspaceyaw=(double***)calloc(36,sizeof(double**));
	HoughGauss=(double**)calloc(4*dc+1,sizeof(double*));

	for(i=0;i<4*dc+1;i++) HoughGauss[i]=(double*)calloc(4*dc+1,sizeof(double));
	for(int i1=0;i1<4*dc+1;i1++){
		for(int i2=0;i2<4*dc+1;i2++){
			if((i1-2*dc)*(i1-2*dc)+(i2-2*dc)*(i2-2*dc)<=2*dc*2*dc){
				HoughGauss[i1][i2]=exp(-(double)((i1-2*dc)*(i1-2*dc)+(i2-2*dc)*(i2-2*dc))/(2*dc*dc));  
			}
			else HoughGauss[i1][i2]=0;
		}
	}

	//loading training images
	train=(IplImage**)calloc(Ltrain,sizeof(IplImage*));  // to store the training images for the visualisation

	int trainsumy1=0;
	int trainsumy2=0;

	for(i=0;i<Ltrain;i++){  
		train[i]=cvCreateImage( cvSize( Iwidth, Iheight ), IPL_DEPTH_8U, 1 );
		sprintf_s(filename, "train\\pic%03dcont.png", i);
		if((train[i]=cvLoadImage(filename,CV_LOAD_IMAGE_GRAYSCALE))==0){
			printf("Unable to open %s\n",filename);	
			return false;
		}

		//loading bounding box information
		sprintf_s(filename, "train\\boundingbox%03d.png", i);
		FILE *fp;
		errno_t err;
		if( (err  = fopen_s( &fp, filename, "r" )) !=0 ){
			printf("Unable to open %s\n",filename);	
			return false;
		}
		fscanf_s( fp, "%d %d %d %d",&trainkeret[i][0],&trainkeret[i][1],&trainkeret[i][2],&trainkeret[i][3]);

		trainoffsetx[i]=0-(trainkeret[i][0]-2);
		trainoffsety[i]=trainsumy1-(trainkeret[i][1]-2);
		trainsumy1+=trainkeret[i][3]-trainkeret[i][1]+5;
		if(trainkeret[i][2]-trainkeret[i][0]+5>trainmaxx1) trainmaxx1=trainkeret[i][2]-trainkeret[i][0]+5;

		fclose( fp );
	}

	trainsumy3=trainsumy1>trainsumy2 ? trainsumy1 : trainsumy2;

	//loading phase0 results
	//loading phase2 results	
	sprintf_s (filename, "phase2.res");
	printf("Loading phase2 results from %s...",filename);
	FILE *fp;
	errno_t err;
	if( (err  = fopen_s( &fp, filename, "r" )) !=0 ){
		printf("Unable to open %s\n",filename);	
		return false;
	}

	int scanfszam;
	scanfszam=fscanf_s( fp, "%d",&profilesallnumber);
	profilesall = (double**)calloc( profilesallnumber, sizeof(double*) );
	profilesallcentx=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesallcenty=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesalldirection=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesallpeekx=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesallpeeky=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesallcurve=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesallorigin=(int*)calloc( profilesallnumber, sizeof(int) );
	profilesallpitch=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesallyaw=(double*)calloc( profilesallnumber, sizeof(double) );
	profilesalllength=(double*)calloc( profilesallnumber, sizeof(double) );

	for(i=0;i<profilesallnumber;i++) profilesall[i] = (double*)calloc(2*Nsp+1 , sizeof(double) );

	float scan4;
	for(i=0;i<profilesallnumber;i++) for(int j=0;j<2*Nsp+1;j++){ scanfszam=fscanf_s( fp, "%f",&scan4); profilesall[i][j]=(double)scan4;}
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallcentx[i]=(double)scan4;}
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallcenty[i]=(double)scan4;}
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesalldirection[i]=(double)scan4;}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallpeekx[i]=(double)scan4;}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallpeeky[i]=(double)scan4;}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallcurve[i]=(double)scan4;}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%d ",&profilesallorigin[i]);}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallpitch[i]=(double)scan4;}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesallyaw[i]=(double)scan4;}	
	for(i=0;i<profilesallnumber;i++) {fscanf_s( fp, "%g ",&scan4); profilesalllength[i]=(double)scan4;}

	fclose( fp );

	//f摜̓_iɒlj
	modelimage = cvCreateImage( cvSize( Iwidth, Iheight ), IPL_DEPTH_8U, 3 );
	cvZero(modelimage);
	for(i=0;i<profilesallnumber;i++){
		cvCircle(modelimage,cvPoint(profilesallpeekx[i],profilesallpeeky[i]),3,CV_RGB(255,255,0),1,8,0);
	}

	for(i=0;i<profilesallnumber;i++){
		cvCircle(modelimage,cvPoint(profilesallpeekx[i],profilesallpeeky[i]),3,CV_RGB(255,255,0),1,8,0);
	}


	//FLANN
	matD = new cv::Mat(cv::Size(2*Nsp+1,profilesallnumber), CV_32FC1);
	int j;
	for(j=0;j<profilesallnumber;j++){
		for(i=0;i<2*Nsp+1;i++){
			matD->at<float>(j,i) = (float)profilesall[j][i];
		}
	}

	// find nearest neighbors using FLANN
	// using 4 randomized kdtrees
	flann_index = new cv::flann::Index(*matD, cv::flann::KDTreeIndexParams(4));

	//----------------------
	cvNamedWindow( "canny", 1 );
	cvNamedWindow( "combined results", 1 );

	// Canny_Threshold
	cvCreateTrackbar("Canny_1","canny",&TH1,256);
	cvCreateTrackbar("Canny_2","canny",&TH2,256);

	return true;
}

bool SpectrumProcess(double result[20])
{
	int i;
	int i0, i1, i2;

	// clear result
	for(i=0;i<20;i++) result[i]=0.0;
	result[8] = result[13] = result[18] = 1.0;

	frame = cvQueryFrame( capture ); //Read frame
	if( !frame ) {
		fprintf(stderr, "cvQueryFrame() failed...\n");	
		return true;
	}
	if (image == NULL) {
		image = cvCreateImage( cvSize( frame->width, frame->height ), IPL_DEPTH_8U, 1 );
		image2 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );			
		image3 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
		image5 = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 3 );

		imageHough = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 3 );
		img = cvCreateImage( cvGetSize( image ), IPL_DEPTH_8U, 1 );
		Houghspace=(double**)calloc(frame->height,sizeof(double*));
		for(int i1=0;i1<frame->height;i1++) {
			Houghspace[i1]=(double*)calloc(frame->width,sizeof(double));
		}

		for(int i0=0;i0<36;i0++){
			Houghspaceyaw[i0]=(double**)calloc(frame->height,sizeof(double*));
			for(int i1=0;i1<frame->height;i1++) Houghspaceyaw[i0][i1]=(double*)calloc(frame->width,sizeof(double));
		}

		//g[jO摜̏
		trainsumy3=trainsumy3>frame->height ? trainsumy3 : frame->height;
		imagemixed  = cvCreateImage( cvSize( frame->width+trainmaxx1+trainmaxx2, trainsumy3 ), IPL_DEPTH_8U, 3 );
		imagemixed2 = cvCreateImage( cvSize( frame->width+trainmaxx1+trainmaxx2, trainsumy3 ), IPL_DEPTH_8U, 3 );
	}

	time0 = GetTickCount();
	time2=0; time3=0;
	time6=0;time7=0;time8=0;

	memset(Houghspace_ratio,0x00,sizeof(Houghspace_ratio));

	cvZero(imagemixed); cvZero(imagemixed2);

	//g[jO摜ʕ\̉ɕ\
	for(i=0;i<Ltrain;i++){
		for(i1=trainkeret[i][1]-2;i1<trainkeret[i][3]+2;i1++){  //y
			for(i2=trainkeret[i][0]-2;i2<trainkeret[i][2]+2;i2++){  //x
				int tempcolor=(int)cvGetReal2D(train[i],i1,i2);
				cvSet2D(imagemixed2,i1+trainoffsety[i],i2+trainoffsetx[i], CV_RGB(tempcolor,tempcolor,tempcolor));
			}
		}
	}

	//g[jO摜(f摜)ɋɒl
	for(i=0;i<profilesallnumber;i++){
		cvCircle(imagemixed2,cvPoint(profilesallpeekx[i]+trainoffsetx[0],profilesallpeeky[i]+trainoffsety[0]),3,CV_RGB(255,255,0),1,8,0);
	}

	//Grayscale conversion, edge extraction
	cvCvtColor( frame, image, CV_BGR2GRAY );
	cvSmooth( image, image, CV_GAUSSIAN, 7, 7 );
	cvCanny( image, image, TH1, TH2, 3 );
	cvCopy(image,image2);

	//Contour extraction
	cvCopy(image,img);
	int contours_num;
	CvMemStorage* storage = cvCreateMemStorage(0);
	contours_num = cvFindContours( img, storage, &contours, sizeof(CvContour),
		CV_RETR_LIST, CV_CHAIN_APPROX_NONE, cvPoint(0,0) );
	CvSeq* contours2 = contours;
	cvZero( image5 );	
	int featurenumbersum=0;

	//decleasing Hough
	for(int i1=0;i1<frame->height;i1++) for(int i2=0;i2<frame->width;i2++) Houghspace[i1][i2]*=0.1;
	for(i0=0;i0<36;i0++) for(int i1=0;i1<frame->height;i1++) for(int i2=0;i2<frame->width;i2++) Houghspaceyaw[i0][i1][i2]*=0.1;		

	int temp2dc=2*dc;
	int tempstart0;
	int tempend0;
	int tempstart;
	int tempend;

	//preparing combined results window
	cvCopy(imagemixed2,imagemixed);
	int imagemixedcamy=(imagemixed->height-frame->height)/2;
	cvSetImageROI(imagemixed,cvRect(trainmaxx1,imagemixedcamy,frame->width,frame->height)); 
	cvSetImageROI(frame,cvRect(0,0,frame->width,frame->height));
	cvCopy(frame,imagemixed);
	cvResetImageROI(imagemixed);
	cvResetImageROI(frame);

	int osszcyclic=0;		
	for( ; contours2 != 0; contours2 = contours2->h_next )
	{
		time5=GetTickCount();
		double szin=255; 
		CvPoint *ptArray = NULL;
		if(contours2->total<50){
			cvClearSeq(contours2);
			continue;
		}
		ptArray = (CvPoint*)calloc(contours2->total , sizeof(CvPoint) );
		cvCvtSeqToArray(contours2, ptArray, CV_WHOLE_SEQ);
		for(i=0;i<contours2->total;i++)			
		{	
			cvSet2D( image5, ptArray[i].y,ptArray[i].x ,CV_RGB(0,255,0) );			
		}
		int cyclic=0; //the contour is closed
		if((abs(ptArray[0].x-ptArray[contours2->total-1].x)<=1) && (abs(ptArray[0].y-ptArray[contours2->total-1].y)<=1)){ cyclic=1;osszcyclic++;}

		int featurenumber;
		int *Maximums=NULL;
		CvPoint2D64f *Peek2=NULL;
		double *Curve2=NULL;
		double *Directions=NULL;
		CvPoint2D64f *Center2=NULL;

		if(cyclic) featurenumber=features(ptArray,contours2->total,&Maximums,&Peek2,&Curve2,&Directions,&Center2);
		else featurenumber=features2(ptArray,contours2->total,&Maximums,&Peek2,&Curve2,&Directions,&Center2);
		featurenumbersum+=featurenumber;

		time6+=GetTickCount()-time5;
		//calculating radius profiles at the feature points
		double *Length2;
		Length2 = (double*)calloc(featurenumber , sizeof(double) );

		for(int i1=0;i1<featurenumber;i1++){
			time1 = GetTickCount();
			double *radiusspectrum=(double*)calloc(2*Nsp+1 , sizeof(double) );
			if(cyclic){
				Length2[i1] = getradiusspectrum(ptArray,contours2->total,Peek2[i1],Curve2[i1],Directions[i1],Center2[i1],radiusspectrum, image5);
			}else{
				Length2[i1] = getradiusspectrum2(ptArray,contours2->total,Peek2[i1],Curve2[i1],Directions[i1],Center2[i1],radiusspectrum, image5);
			}

			//FLANN
			cv::Mat m_indices(1, 2, CV_32S);  //NG[摜̐~2̍s
			cv::Mat m_dists(1, 2, CV_32F);		 
			cv::Mat matE(cv::Size(2*Nsp+1, 1), CV_32FC1);
			for(i=0;i<2*Nsp+1;i++){
				matE.at<float>(0,i) = radiusspectrum[i];
			}

			flann_index->knnSearch(matE, m_indices, m_dists, 2, cv::flann::SearchParams(64)); // maximum number of leafs checked
			int* indices_ptr = m_indices.ptr<int>(0);
			float* dists_ptr = m_dists.ptr<float>(0);

			int nnIdx[1]; 
			float dists[2]; 
			nnIdx[0] = indices_ptr[0]; 
			dists[0] = dists_ptr[0];
			dists[1] = dists_ptr[1];

			time2 += GetTickCount()-time1;

			for(int i2=0;i2<1;i2++){
				if(0.7*dists[1] < dists[0]) break;
				if(dists[i2]<10000){   

					double tmp_ratio = Length2[i1]/profilesalllength[nnIdx[i2]];
					if((int)(tmp_ratio*10) < RATIOMAX-1 && (int)(tmp_ratio*10) > 0){
						Houghspace_ratio[(int)(tmp_ratio*10)-1] += 1;							
						Houghspace_ratio[(int)(tmp_ratio*10)  ] += 2;
						Houghspace_ratio[(int)(tmp_ratio*10)+1] += 1;
					}						

					double tempcentx=Peek2[i1].x + tmp_ratio * (profilesallcentx[nnIdx[i2]]*cos(Directions[i1]-profilesalldirection[nnIdx[i2]])
						-profilesallcenty[nnIdx[i2]]*sin(Directions[i1]-profilesalldirection[nnIdx[i2]])) ;
					double tempcenty=Peek2[i1].y + tmp_ratio * (profilesallcentx[nnIdx[i2]]*sin(Directions[i1]-profilesalldirection[nnIdx[i2]])
						+profilesallcenty[nnIdx[i2]]*cos(Directions[i1]-profilesalldirection[nnIdx[i2]])) ;

					double tempyaw = profilesallyaw[nnIdx[i2]] + Directions[i1] - profilesalldirection[nnIdx[i2]];

					//line draws to the features
					int tempcolor1=rand()%256;
					int tempcolor2=rand()%256;
					int tempcolor3=rand()%256;			

					//line1
					cvLine(imagemixed,cvPoint(profilesallpeekx[nnIdx[i2]]+trainoffsetx[0],profilesallpeeky[nnIdx[i2]]+trainoffsety[0]),cvPoint((int)Peek2[i1].x+trainmaxx1,(int)Peek2[i1].y),CV_RGB(0,0,255),1,8,0);								  
					cvCircle(imagemixed,cvPoint((int)Peek2[i1].x+trainmaxx1,(int)Peek2[i1].y),3,CV_RGB(255,0,0),1,8,1);

					for(int r1=-2*dc; r1<=2*dc; r1++){
						if((int)(tempcentx+r1)<0) continue;
						if((int)(tempcentx+r1)>image5->width-1) continue;
						for(int r2=-2*dc;r2<=2*dc;r2++){
							if((int)(tempcenty+r2)<0) continue;
							if((int)(tempcenty+r2)>image5->height-1) continue;
							Houghspace[(int)(tempcenty+r2)][(int)(tempcentx+r1)]+=0.6*HoughGauss[r2+2*dc][r1+2*dc]; 
						}
					}

					int yawcent=( (int) floor( (tempyaw+M_PI/36+2*M_PI) *18.0/M_PI) )%36;  			
					int yawcent1=(yawcent+1)%36;  //neighbouring yaw angle positions
					int yawcent2=(yawcent-1+36)%36;
					tempstart0=max(-tempcentx,(double)(-temp2dc));
					tempend0=min(image5->width-1-tempcentx,(double)temp2dc);

					for(int r1=tempstart0; r1<=tempend0; r1++){   // -temp2dc...temp2dc
						tempstart=max(-tempcenty,(double)(-temp2dc));
						tempend=min(image5->height-1-tempcenty,(double)temp2dc);
						for(int r2=tempstart;r2<=tempend;r2++){   // -temp2dc...temp2dc
							Houghspaceyaw[yawcent][(int)(tempcenty+r2)][(int)(tempcentx+r1)]+=0.4*HoughGauss[r2+temp2dc][r1+temp2dc];
							Houghspaceyaw[yawcent1][(int)(tempcenty+r2)][(int)(tempcentx+r1)]+=0.2*HoughGauss[r2+temp2dc][r1+temp2dc];
							Houghspaceyaw[yawcent2][(int)(tempcenty+r2)][(int)(tempcentx+r1)]+=0.2*HoughGauss[r2+temp2dc][r1+temp2dc];
						}
					}
				}
			}

			SAFE_FREE(radiusspectrum);
			time3 += GetTickCount()-time1;

		} // end of for(int i1=0;i1<featurenumber;i1++)

		time7+=GetTickCount()-time5;

		//showing results
		for(int i=0;i<featurenumber;i++){
			cvSet2D( image5,max(0,min(image5->height-1,(int) floor(Peek2[i].y))),
				max(0,min(image5->width-1,(int)floor(Peek2[i].x))) ,
				CV_RGB(255,0,0) );
			cvSet2D( image5,max(0,min(image5->height-1,(int) floor(Center2[i].y))),
				max(0,min(image5->width-1,(int)floor(Center2[i].x))) ,
				CV_RGB(255,255,255) );
		}

		SAFE_FREE(Maximums)
		SAFE_FREE(Peek2);
		SAFE_FREE(Curve2);	
		SAFE_FREE(Directions);
		SAFE_FREE(Center2);
		SAFE_FREE(Length2);
		SAFE_FREE(ptArray); 

		time8+=GetTickCount()-time5;

	} // end of for( ; contours2 != 0; contours2 = contours2->h_next )

	//showing Hough-voting results
	cvCopy(image5,imageHough);
	for(int i1=0;i1<imageHough->height;i1++){
		for(int i2=0;i2<imageHough->width;i2++){
			if(Houghspace[i1][i2]>4) cvSet2D(imageHough,i1,i2,CV_RGB(255,255,0));
			else if(Houghspace[i1][i2]>2) cvSet2D(imageHough,i1,i2,CV_RGB((int)(100+(Houghspace[i1][i2]-10)*15),0,0));
			else if(Houghspace[i1][i2]>0.13) cvSet2D(imageHough,i1,i2,CV_RGB(0,0,(int)(Houghspace[i1][i2]*25)));
		}
	}
	//search max
	double hough_max = 0.0;
	int hough_max_x = 0;
	int hough_max_y = 0;
	for(int i1=0;i1<imageHough->height;i1++){
		for(int i2=0;i2<imageHough->width;i2++){
			if(Houghspace[i1][i2] > hough_max){
				hough_max = Houghspace[i1][i2];
				hough_max_x = i2;
				hough_max_y = i1;
			}
		}
	}
	cvCircle(imageHough,cvPoint(hough_max_x,hough_max_y),5,CV_RGB(0,0,0),2,8,0);

	//search max yaw
	double hough_max_yaw_vote = 0.0;
	int hough_max_yaw = 0;
	tempstart0=max(-hough_max_x,-temp2dc);
	tempend0=min(image5->width-1-hough_max_x,temp2dc);
	tempstart=max(-hough_max_y,-temp2dc);
	tempend=min(image5->height-1-hough_max_y,temp2dc);

	for(i0=0;i0<36;i0++){
		for(int r1=tempstart0; r1<=tempend0; r1++){ 
			for(int r2=tempstart;r2<=tempend;r2++){ 
				if(Houghspaceyaw[i0][hough_max_y+r2][hough_max_x+r1] > hough_max_yaw_vote){
					hough_max_yaw_vote = Houghspaceyaw[i0][hough_max_y+r2][hough_max_x+r1];
					hough_max_yaw = i0;
				}
			}
		}
	}

	// preparation of boundary box
	CvBox2D bbox;
	bbox.center.x = hough_max_x;
	bbox.center.y = hough_max_y;

	double d_box_cx = 0;
	double d_box_cy = 0;
	double d_box_ang = 0;
	d_box_cx = bbox.center.x;
	d_box_cy = bbox.center.y;

	int max_ratio_vote = 0;
	int max_ratio_i = 0;
	for(i=0;i<RATIOMAX;i++){
		if(Houghspace_ratio[i] > max_ratio_vote){
			max_ratio_i = i;
			max_ratio_vote = Houghspace_ratio[i];
		}
	}

	double true_ratio = max_ratio_i/10.0;

	float vx = true_ratio * (float)(trainkeret[0][2]-trainkeret[0][0]+5);
	float vy = true_ratio * (float)(trainkeret[0][3]-trainkeret[0][1]+5);

	bbox.size.width = vx;
	bbox.size.height = vy;

	bbox.angle = hough_max_yaw*10;
	d_box_ang = hough_max_yaw*10;

	MakeRotation(result, d_box_cx, d_box_cy, d_box_ang*M_PI/180.0, 0, 0);

	CvPoint2D32f boxp[4];
	cvBoxPoints(bbox,boxp);

	CvPoint boxp0;
	boxp0.x = (int)boxp[3].x+ trainmaxx1; 
	boxp0.y = (int)boxp[3].y;
	for(i=0;i<4;i++){
		cvLine(imagemixed,boxp0,cvPoint((int)boxp[i].x + trainmaxx1, (int)boxp[i].y),CV_RGB(255,0,0),3,8,0); 
		boxp0.x = (int)boxp[i].x+ trainmaxx1; 
		boxp0.y = (int)boxp[i].y;		
	}

	::end = clock();
	clockavg=clockavg*0.8+0.2*(double)( ::end - start )/CLOCKS_PER_SEC;
	writeFPS( start, ::end, clockavg, image );
	cvShowImage( "canny",image);

	start = clock();
	cvReleaseMemStorage( &storage );

	cvShowImage("combined results",imagemixed);		

	int c = cvWaitKey(10);
	if( c == 27 ){
		return false;
	}else if(c=='s'){
		sprintf_s (filename, "picHough.png");
		cvSaveImage( filename, imageHough );
		sprintf_s (filename, "piccurv.png");
		cvSaveImage( filename, image5 );
	}
	time4 = GetTickCount();

	return true;
}



void SpectrumFinish()
{
	cvDestroyAllWindows();
	cvReleaseCapture(&capture);

	cvReleaseImage( &image );
	cvReleaseImage( &image2 );
	cvReleaseImage( &image3 );
	cvReleaseImage( &image5 );
	cvReleaseImage( &imageHough );
	cvReleaseImage( &img );

	int i, i0, i1;

	if (Houghspaceyaw != NULL) {
		for(i0=0;i0<36;i0++) {
			for(i1=0;i1<frame->height;i1++) free(Houghspaceyaw[i0][i1]);
			free(Houghspaceyaw[i0]);
		}
		free(Houghspaceyaw);
		Houghspaceyaw = NULL;
	}

	if (Houghspace != NULL) {
		for(i1=0;i1<frame->height;i1++) free(Houghspace[i1]);
		free(Houghspace);
		Houghspace = NULL;
	}
	if (profilesall != NULL) {
		for(i=0;i<profilesallnumber;i++) free(profilesall[i]);  
		free(profilesall);
		profilesall = NULL;
	}

	SAFE_FREE(profilesallcentx);
	SAFE_FREE(profilesallcenty);
	SAFE_FREE(profilesalldirection);

	SAFE_DELETE(matD);
	SAFE_DELETE(flann_index);
}

int SpectrumDebugMain()
{
	bool rv;
	double result[20];

	if (SpectrumInit() == false) return 3;

	start = clock();
	while(1){
		rv = SpectrumProcess(result);
		if (rv == false) break;
	}

	SpectrumFinish();

	return 0;
}


