#include "curvature.h"

//true maximum position on the original curve may be needed too, if that works better
//derivation should be doubled-point errorproof!

#define LM 15

//Finds curvature maximum and minimum points along the cyclic contour
int features(CvPoint *PointArray,int length, int **Maximums, CvPoint2D64f **Peek2,double **Curve2,double **Directions, CvPoint2D64f **Center2){
	//const int LM = 40;//15;  // interval radius of fitting

	double Curr_x, Curr_y, Priv_x, Priv_y, Next_x, Next_y, Diff11_x, Diff12_x, Diff11_y, Diff12_y;
	double RT;

	CvPoint* PointArray2;       // points used for the local fit	
	CvPoint2D64f* PointArray3;  // smoothed curve points
	CvPoint2D64f* Deriv1;       // first order derivatives
	CvPoint2D64f* Deriv2;	    // second order derivatives
	double* Deriv1Curve;        // first order derivative of the curvature
	double* Curve;              // curvature
	double* Radius;             // local radius
	double* Ratio; 
	int* ZeroCross;      // curvature maximum at the place or before it has 1 value
	CvPoint2D64f* Peek;  // true maximum on the fitted curve
	double TH = 0.02; //0.0007  // threshold for curve max search

	PointArray2 = (CvPoint*)malloc( (2*LM+1)*sizeof(CvPoint) );
	PointArray3 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );
	Deriv1 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );
	Deriv2 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );
	Curve = (double*)malloc( length*sizeof(double) );
	Deriv1Curve = (double*)malloc( length*sizeof(double) );

	Radius = (double*)malloc( length*sizeof(double) );
	Ratio = (double*)malloc( length*sizeof(double) );
	ZeroCross = (int*)malloc( length*sizeof(int) );  
	Peek = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );

	for(int position=0; position<length; position++){  // calculating derivatives on fitted curves
		int ktot=0; // number of points used for the fit (2*LM+1)
		for( int i = position - LM + length; i < position + LM +length; i++ ){
			//PointArray2ɂ́APointArray̏\{glB
			PointArray2[ktot].x = PointArray[i%length].x - PointArray[position%length].x;
			PointArray2[ktot].y = PointArray[i%length].y - PointArray[position%length].y;
			ktot++;	
		}

		//w-Least-squares fitting (with 4th order polynomial)
		CvMat* AXmat = cvCreateMat(5,1,CV_64F);  // result of fitting
		CvMat* Xmat = cvCreateMat(ktot,5,CV_64F);  // input matrix
		CvMat* Ymat = cvCreateMat(ktot,1,CV_64F);  // input vector

		for(int i=0;i<ktot;i++){
			double fi = (double)i;
			double fx = (double)PointArray2[i].x; 
			cvmSet(Xmat,i,0,1.0);
			cvmSet(Xmat,i,1,fi);
			cvmSet(Xmat,i,2,fi*fi);			
			cvmSet(Xmat,i,3,fi*fi*fi);
			cvmSet(Xmat,i,4,fi*fi*fi*fi);
			cvmSet(Ymat,i,0, fx);
			//printf(" x %f %f \n",fi, fx);
		}	
		cvSolve(Xmat,Ymat,AXmat,CV_SVD);
		// Make quadratic function
		Curr_x = PointArray[position].x + cvmGet(AXmat,0,0) + cvmGet(AXmat,1,0)*LM + cvmGet(AXmat,2,0)*LM*LM + cvmGet(AXmat,3,0)*LM*LM*LM + cvmGet(AXmat,4,0)*LM*LM*LM*LM; 
		PointArray3[position].x = Curr_x;
		Priv_x = PointArray[position].x + cvmGet(AXmat,0,0) + cvmGet(AXmat,1,0)*(LM-1) + cvmGet(AXmat,2,0)*(LM-1)*(LM-1) + cvmGet(AXmat,3,0)*(LM-1)*(LM-1)*(LM-1) + cvmGet(AXmat,4,0)*(LM-1)*(LM-1)*(LM-1)*(LM-1);
		Next_x = PointArray[position].x + cvmGet(AXmat,0,0) + cvmGet(AXmat,1,0)*(LM+1) + cvmGet(AXmat,2,0)*(LM+1)*(LM+1) + cvmGet(AXmat,3,0)*(LM+1)*(LM+1)*(LM+1) + cvmGet(AXmat,4,0)*(LM+1)*(LM+1)*(LM+1)*(LM+1);

		// 1st Derivative 
		Diff11_x = Curr_x - Priv_x;
		Diff12_x = Next_x - Curr_x;
		Deriv1[position].x = cvmGet(AXmat,1,0) + 2*cvmGet(AXmat,2,0)*LM + 3*cvmGet(AXmat,3,0)*LM*LM + 4*cvmGet(AXmat,4,0)*LM*LM*LM; //(Diff11_x + Diff12_x)/2.0;
		// 2nd Derivative 
		Deriv2[position].x = 2*cvmGet(AXmat,2,0) + 6*cvmGet(AXmat,3,0)*LM + 12*cvmGet(AXmat,4,0)*LM*LM; //Diff12_x - Diff11_x;

		//x-Least-squares fitting (with 4th order polynomial)
		CvMat* AYmat = cvCreateMat(5,1,CV_64F); // result of fitting
		for(int i=0;i<ktot;i++){
			double fi = (double)i;
			double fy = (double)PointArray2[i].y; 
			cvmSet(Xmat,i,0,1.0);
			cvmSet(Xmat,i,1,fi);
			cvmSet(Xmat,i,2,fi*fi);							
			cvmSet(Xmat,i,3,fi*fi*fi);
			cvmSet(Xmat,i,4,fi*fi*fi*fi);
			cvmSet(Ymat,i,0, fy);
			//printf(" y %f %f \n",fi, fy);
		}
		cvSolve(Xmat,Ymat,AYmat,CV_SVD);
		//Make quadratic function
		Curr_y = PointArray[position].y + cvmGet(AYmat,0,0) + cvmGet(AYmat,1,0)*LM + cvmGet(AYmat,2,0)*LM*LM + cvmGet(AYmat,3,0)*LM*LM*LM + cvmGet(AYmat,4,0)*LM*LM*LM*LM;
		PointArray3[position].y = Curr_y;
		Priv_y = PointArray[position].y + cvmGet(AYmat,0,0) + cvmGet(AYmat,1,0)*(LM-1) + cvmGet(AYmat,2,0)*(LM-1)*(LM-1) + cvmGet(AYmat,3,0)*(LM-1)*(LM-1)*(LM-1) + cvmGet(AYmat,4,0)*(LM-1)*(LM-1)*(LM-1)*(LM-1);
		Next_y = PointArray[position].y + cvmGet(AYmat,0,0) + cvmGet(AYmat,1,0)*(LM+1) + cvmGet(AYmat,2,0)*(LM+1)*(LM+1) + cvmGet(AYmat,3,0)*(LM+1)*(LM+1)*(LM+1) + cvmGet(AYmat,4,0)*(LM+1)*(LM+1)*(LM+1)*(LM+1);

		// 1st Derivative
		Diff11_y = Curr_y - Priv_y;
		Diff12_y = Next_y - Curr_y; 
		Deriv1[position].y = cvmGet(AYmat,1,0) + 2*cvmGet(AYmat,2,0)*LM + 3*cvmGet(AYmat,3,0)*LM*LM + 4*cvmGet(AYmat,4,0)*LM*LM*LM; // (Diff11_y + Diff12_y)/2.0;
		// 2nd Derivative
		Deriv2[position].y = 2*cvmGet(AYmat,2,0) + 6*cvmGet(AYmat,3,0)*LM + 12*cvmGet(AYmat,4,0)*LM*LM; //Diff12_y - Diff11_y;
		//Calculate the curvature ratio by 1st, 2nd  Derivative of Least-squares fitting 
		RT = sqrt(Deriv1[position].x * Deriv1[position].x + Deriv1[position].y * Deriv1[position].y);
		Curve[position] = (Deriv1[position].x * Deriv2[position].y - Deriv2[position].x * Deriv1[position].y)/(RT*RT*RT);
		//printf("Curve %f \n",Curve[position] );
		//Radius[position] = 1/Curve[position];
		ZeroCross[position] = 0;
		cvReleaseMat(&AXmat);
		cvReleaseMat(&Xmat);
		cvReleaseMat(&Ymat);
		cvReleaseMat(&AYmat);
	}
	//1st Derivative of the curvature ratio
	for(int position = 0; position < length ; position++){
		Deriv1Curve[position] = (Curve[position]-Curve[(position-1+length)%length] + Curve[(position+1)%length] - Curve[position])/2.0;
		//printf("DerivCurve= %f \n",Deriv1Curve[position] );		
	}
	//Calculate true extreme value ( sub-pixel level )
	CvPoint2D64f* Center1;
	Center1 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );	

	int featurenumber=0;  // ember of maxima and minima of corvature
	bool flag1= false;
	double NormDrTrx_C, NormDrTry_C;
	for(int position = 0; position < length ; position++){  
		if(Deriv1Curve[position] <= 0.0 && Deriv1Curve[(position-1+length)%length] > 0.0 && fabs(Curve[position]) > TH){ 
			double wid1x = PointArray3[position].x - PointArray3[(position-1+length)%length].x;
			double wid1y = PointArray3[position].y - PointArray3[(position-1+length)%length].y;
			Ratio[position] = Deriv1Curve[(position-1+length)%length]/(Deriv1Curve[(position-1+length)%length]-Deriv1Curve[position]);
			//true extreme value ( sub-pixel level )
			Peek[position].x = PointArray3[(position-1+length)%length].x + wid1x*Ratio[position] ;
			Peek[position].y = PointArray3[(position-1+length)%length].y + wid1y*Ratio[position] ;				
			ZeroCross[position] = 1;//printf("Zero+ %d  \n",position);			
			Radius[position] = 1/Curve[position]; //printf("Radius %f \n",Radius[position]);
			flag1 = true;
		}
		if(Deriv1Curve[position] >= 0.0 && Deriv1Curve[(position-1+length)%length] < 0.0 && fabs(Curve[position]) > TH){ 
			double wid2x = PointArray3[position].x - PointArray3[(position-1+length)%length].x;
			double wid2y = PointArray3[position].y - PointArray3[(position-1+length)%length].y;
			Ratio[position] = - Deriv1Curve[(position-1+length)%length]/(-Deriv1Curve[(position-1+length)%length]+Deriv1Curve[position]);
			//true extreme value ( sub-pixel level )
			Peek[position].x = PointArray3[(position-1+length)%length].x + wid2x * Ratio[position];
			Peek[position].y = PointArray3[(position-1+length)%length].y + wid2y * Ratio[position];					
			ZeroCross[position] = -1;//printf("Zero- %d \n",position);
			Radius[position] = 1/Curve[position]; //printf("Radius1=%f \n",Radius[position]);
			flag1 = true;
		}
		if(flag1 == true){
			
			//1st Derivative of near point of true extreme value ( sub-pixel level )
			//printf("dx,dy =(%f,%f) \n",Deriv1[(position-1+length)%length].x,Deriv1[(position-1+length)%length].y);	
			//printf("dx,dy =(%f,%f) \n",Deriv1[position].x,Deriv1[position].y);
			//printf("dx,dy =(%f,%f) \n",Deriv1[position+1].x,Deriv1[position+1].y);
			double DerivTrue_x = Deriv1[(position-1+length)%length].x + Ratio[position] * ( Deriv1[position].x - Deriv1[(position-1+length)%length].x);
			double DerivTrue_y = Deriv1[(position-1+length)%length].y + Ratio[position] * ( Deriv1[position].y - Deriv1[(position-1+length)%length].y);
			//printf("Dx,Dy =(%f,%f) \n",DerivTrue_x,DerivTrue_y);
			double Ldr = sqrt(DerivTrue_x * DerivTrue_x + DerivTrue_y * DerivTrue_y);
			double NormDrTrx = DerivTrue_x/Ldr ; double NormDrTry = DerivTrue_y/Ldr;
			//printf("Norm %f,%f \n",NormDrTrx,NormDrTry);
			NormDrTrx_C = -NormDrTry; NormDrTry_C = NormDrTrx;
			Center1[position].x = Peek[position].x + Radius[position] * NormDrTrx_C; 
			Center1[position].y = Peek[position].y + Radius[position] * NormDrTry_C;
			featurenumber++;
		}
		flag1 = false;
	}
	//collecting the maximums
	if(featurenumber>0){
		*Maximums = (int *)malloc( featurenumber*sizeof(int) );	
		*Peek2=(CvPoint2D64f*)malloc( featurenumber*sizeof(CvPoint2D64f));
		*Curve2=(double *)malloc( featurenumber*sizeof(double) );	
		*Directions=(double *)malloc( featurenumber*sizeof(double) );
		*Center2=(CvPoint2D64f *)malloc( featurenumber*sizeof(CvPoint2D64f) );
		int j=0;
		for(int i=0;i<length;i++){
			if(ZeroCross[i]!=0){
				(*Maximums)[j]=i; 
				(*Peek2)[j]=Peek[i]; 
				(*Curve2)[j]=Curve[i];  // approximately
				(*Directions)[j]=atan2( Center1[i].y-Peek[i].y, Center1[i].x-Peek[i].x); 
				(*Center2)[j]=Center1[i]; 
				j++;	
			}
		}
	}
	free(PointArray2);
	free(PointArray3);
	free(Deriv1);
	free(Deriv2);
	free(Curve);
	free(Deriv1Curve);
	free(Radius);
	free(Ratio);
	free(ZeroCross);
	free(Peek);
	free(Center1);
	return featurenumber;
}

//Finds curvature maximum and minimum points along the contour (acyclic)
int features2(CvPoint *PointArray,int length,int **Maximums,CvPoint2D64f **Peek2,double **Curve2,double **Directions,CvPoint2D64f **Center2){  // vissza: kor kep kozeppontja?
	//const int LM = 15;  // interval radius of fitting

	double Curr_x, Curr_y, Priv_x, Priv_y, Next_x, Next_y, Diff11_x, Diff12_x, Diff11_y, Diff12_y;
	double RT;

	CvPoint* PointArray2;       // points used for the local fit	
	CvPoint2D64f* PointArray3;  // smoothed curve points
	CvPoint2D64f* Deriv1;       // first order derivatives
	CvPoint2D64f* Deriv2;	    // second order derivatives
	double* Deriv1Curve;        // first order derivative of the curvature
	double* Curve;              // curvature
	double* Radius;             // local radius
	double* Ratio; 
	int* ZeroCross;      // curvature maximum at the place or before it has 1 value
	CvPoint2D64f* Peek;  // true maximum on the fitted curve
	double TH = 0.02; //0.0007  // threshold for curve max search

	PointArray2 = (CvPoint*)malloc( (2*LM+1)*sizeof(CvPoint) );
	PointArray3 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );
	Deriv1 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );
	Deriv2 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );
	Curve = (double*)malloc( length*sizeof(double) );
	Deriv1Curve = (double*)malloc( length*sizeof(double) );

	Radius = (double*)malloc( length*sizeof(double) );
	Ratio = (double*)malloc( length*sizeof(double) );
	ZeroCross = (int*)malloc( length*sizeof(int) );  
	Peek = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );

	for(int position=LM; position<length-LM; position++){  // calculating derivatives on fitted curves
		int ktot=0; // number of points used for the fit (2*LM+1)
		for( int i = position - LM; i < position + LM; i++ ){
			//PointArray2ɂ́APointArray̏\{glB
			PointArray2[ktot].x = PointArray[i].x - PointArray[position].x;
			PointArray2[ktot].y = PointArray[i].y - PointArray[position].y;
			ktot++;	
		}

		//w-Least-squares fitting (with 4th order polynomial)
		CvMat* AXmat = cvCreateMat(5,1,CV_64F);  // result of fitting
		CvMat* Xmat = cvCreateMat(ktot,5,CV_64F);  // input matrix
		CvMat* Ymat = cvCreateMat(ktot,1,CV_64F);  // input vector

		for(int i=0;i<ktot;i++){
			double fi = (double)i;
			double fx = (double)PointArray2[i].x; 
			cvmSet(Xmat,i,0,1.0);
			cvmSet(Xmat,i,1,fi);
			cvmSet(Xmat,i,2,fi*fi);			
			cvmSet(Xmat,i,3,fi*fi*fi);
			cvmSet(Xmat,i,4,fi*fi*fi*fi);
			cvmSet(Ymat,i,0, fx);
			//printf(" x %f %f \n",fi, fx);
		}	
		cvSolve(Xmat,Ymat,AXmat,CV_SVD);
		// Make quadratic function
		Curr_x = PointArray[position].x + cvmGet(AXmat,0,0) + cvmGet(AXmat,1,0)*LM + cvmGet(AXmat,2,0)*LM*LM + cvmGet(AXmat,3,0)*LM*LM*LM + cvmGet(AXmat,4,0)*LM*LM*LM*LM; 
		PointArray3[position].x = Curr_x;
		Priv_x = PointArray[position].x + cvmGet(AXmat,0,0) + cvmGet(AXmat,1,0)*(LM-1) + cvmGet(AXmat,2,0)*(LM-1)*(LM-1) + cvmGet(AXmat,3,0)*(LM-1)*(LM-1)*(LM-1) + cvmGet(AXmat,4,0)*(LM-1)*(LM-1)*(LM-1)*(LM-1);
		Next_x = PointArray[position].x + cvmGet(AXmat,0,0) + cvmGet(AXmat,1,0)*(LM+1) + cvmGet(AXmat,2,0)*(LM+1)*(LM+1) + cvmGet(AXmat,3,0)*(LM+1)*(LM+1)*(LM+1) + cvmGet(AXmat,4,0)*(LM+1)*(LM+1)*(LM+1)*(LM+1);

		// 1st Derivative 
		Diff11_x = Curr_x - Priv_x;
		Diff12_x = Next_x - Curr_x;
		Deriv1[position].x = cvmGet(AXmat,1,0) + 2*cvmGet(AXmat,2,0)*LM + 3*cvmGet(AXmat,3,0)*LM*LM + 4*cvmGet(AXmat,4,0)*LM*LM*LM; //(Diff11_x + Diff12_x)/2.0;
		// 2nd Derivative 
		Deriv2[position].x = 2*cvmGet(AXmat,2,0) + 6*cvmGet(AXmat,3,0)*LM + 12*cvmGet(AXmat,4,0)*LM*LM; //Diff12_x - Diff11_x;

		//x-Least-squares fitting (with 4th order polynomial)
		CvMat* AYmat = cvCreateMat(5,1,CV_64F); // result of fitting
		for(int i=0;i<ktot;i++){
			double fi = (double)i;
			double fy = (double)PointArray2[i].y; 
			cvmSet(Xmat,i,0,1.0);
			cvmSet(Xmat,i,1,fi);
			cvmSet(Xmat,i,2,fi*fi);							
			cvmSet(Xmat,i,3,fi*fi*fi);
			cvmSet(Xmat,i,4,fi*fi*fi*fi);
			cvmSet(Ymat,i,0, fy);
			//printf(" y %f %f \n",fi, fy);
		}
		cvSolve(Xmat,Ymat,AYmat,CV_SVD);
		//Make quadratic function
		Curr_y = PointArray[position].y + cvmGet(AYmat,0,0) + cvmGet(AYmat,1,0)*LM + cvmGet(AYmat,2,0)*LM*LM + cvmGet(AYmat,3,0)*LM*LM*LM + cvmGet(AYmat,4,0)*LM*LM*LM*LM;
		PointArray3[position].y = Curr_y;
		Priv_y = PointArray[position].y + cvmGet(AYmat,0,0) + cvmGet(AYmat,1,0)*(LM-1) + cvmGet(AYmat,2,0)*(LM-1)*(LM-1) + cvmGet(AYmat,3,0)*(LM-1)*(LM-1)*(LM-1) + cvmGet(AYmat,4,0)*(LM-1)*(LM-1)*(LM-1)*(LM-1);
		Next_y = PointArray[position].y + cvmGet(AYmat,0,0) + cvmGet(AYmat,1,0)*(LM+1) + cvmGet(AYmat,2,0)*(LM+1)*(LM+1) + cvmGet(AYmat,3,0)*(LM+1)*(LM+1)*(LM+1) + cvmGet(AYmat,4,0)*(LM+1)*(LM+1)*(LM+1)*(LM+1);

		// 1st Derivative
		Diff11_y = Curr_y - Priv_y;
		Diff12_y = Next_y - Curr_y; 
		Deriv1[position].y = cvmGet(AYmat,1,0) + 2*cvmGet(AYmat,2,0)*LM + 3*cvmGet(AYmat,3,0)*LM*LM + 4*cvmGet(AYmat,4,0)*LM*LM*LM; // (Diff11_y + Diff12_y)/2.0;
		// 2nd Derivative
		Deriv2[position].y = 2*cvmGet(AYmat,2,0) + 6*cvmGet(AYmat,3,0)*LM + 12*cvmGet(AYmat,4,0)*LM*LM; //Diff12_y - Diff11_y;

		//Calculate the curvature ratio by 1st, 2nd  Derivative of Least-squares fitting 
		RT = sqrt(Deriv1[position].x * Deriv1[position].x + Deriv1[position].y * Deriv1[position].y);
		Curve[position] = (Deriv1[position].x * Deriv2[position].y - Deriv2[position].x * Deriv1[position].y)/(RT*RT*RT);
		//printf("Curve %f \n",Curve[position] );
		//Radius[position] = 1/Curve[position];
		ZeroCross[position] = 0;


		cvReleaseMat(&AXmat);
		cvReleaseMat(&Xmat);
		cvReleaseMat(&Ymat);
		cvReleaseMat(&AYmat);


	}
	//1st Derivative of the curvature ratio
	for(int position = LM+1; position < length-LM-1 ; position++){
		Deriv1Curve[position] = (Curve[position]-Curve[position-1] + Curve[position+1] - Curve[position])/2.0;
		//printf("DerivCurve= %f \n",Deriv1Curve[position] );		
	}

	//Calculate true extreme value ( sub-pixel level )
	CvPoint2D64f* Center1;
	Center1 = (CvPoint2D64f*)malloc( length*sizeof(CvPoint2D64f) );	

	int featurenumber=0;  // ember of maxima and minima of corvature
	bool flag1= false;
	double NormDrTrx_C, NormDrTry_C;
	for(int position = LM+2; position < length-LM-1 ; position++){ 
		if(Deriv1Curve[position] <= 0.0 && Deriv1Curve[position-1] > 0.0 && fabs(Curve[position]) > TH){ 
			double wid1x = PointArray3[position].x - PointArray3[position-1].x;
			double wid1y = PointArray3[position].y - PointArray3[position-1].y;
			Ratio[position] = Deriv1Curve[position-1]/(Deriv1Curve[position-1]-Deriv1Curve[position]);
			//true extreme value ( sub-pixel level )
			Peek[position].x = PointArray3[position-1].x + wid1x*Ratio[position] ;
			Peek[position].y = PointArray3[position-1].y + wid1y*Ratio[position] ;				
			ZeroCross[position] = 1;//printf("Zero+ %d  \n",position);			
			Radius[position] = 1/Curve[position]; //printf("Radius %f \n",Radius[position]);
			flag1 = true;
		}
		if(Deriv1Curve[position] >= 0.0 && Deriv1Curve[position-1] < 0.0 && fabs(Curve[position]) > TH){ 
			double wid2x = PointArray3[position].x - PointArray3[position-1].x;
			double wid2y = PointArray3[position].y - PointArray3[position-1].y;
			Ratio[position] = - Deriv1Curve[position-1]/(-Deriv1Curve[position-1]+Deriv1Curve[position]);
			//true extreme value ( sub-pixel level )
			Peek[position].x = PointArray3[position-1].x + wid2x * Ratio[position];
			Peek[position].y = PointArray3[position-1].y + wid2y * Ratio[position];					
			ZeroCross[position] = -1;//printf("Zero- %d \n",position);
			Radius[position] = 1/Curve[position]; //printf("Radius1=%f \n",Radius[position]);
			flag1 = true;
		}
		if(flag1 == true){
			//1st Derivative of near point of true extreme value ( sub-pixel level )
			//printf("dx,dy =(%f,%f) \n",Deriv1[(position-1+length)%length].x,Deriv1[(position-1+length)%length].y);	
			//printf("dx,dy =(%f,%f) \n",Deriv1[position].x,Deriv1[position].y);
			//printf("dx,dy =(%f,%f) \n",Deriv1[position+1].x,Deriv1[position+1].y);
			double DerivTrue_x = Deriv1[position-1].x + Ratio[position] * ( Deriv1[position].x - Deriv1[position-1].x);
			double DerivTrue_y = Deriv1[position-1].y + Ratio[position] * ( Deriv1[position].y - Deriv1[position-1].y);
			//printf("Dx,Dy =(%f,%f) \n",DerivTrue_x,DerivTrue_y);
			double Ldr = sqrt(DerivTrue_x * DerivTrue_x + DerivTrue_y * DerivTrue_y);
			double NormDrTrx = DerivTrue_x/Ldr ; double NormDrTry = DerivTrue_y/Ldr;
			//printf("Norm %f,%f \n",NormDrTrx,NormDrTry);
			NormDrTrx_C = -NormDrTry; NormDrTry_C = NormDrTrx;
			Center1[position].x = Peek[position].x + Radius[position] * NormDrTrx_C; 
			Center1[position].y = Peek[position].y + Radius[position] * NormDrTry_C;
			featurenumber++;
		}
		flag1 = false;
	}
	//collecting the maximums
	if(featurenumber>0){
		*Maximums = (int *)malloc( featurenumber*sizeof(int) );	
		*Peek2=(CvPoint2D64f*)malloc( featurenumber*sizeof(CvPoint2D64f));
		*Curve2=(double *)malloc( featurenumber*sizeof(double) );	
		*Directions=(double *)malloc( featurenumber*sizeof(double) );
		*Center2=(CvPoint2D64f *)malloc( featurenumber*sizeof(CvPoint2D64f) );		
		
		int j=0;
		for(int i=LM+2;i<length-LM-1;i++){
			if(ZeroCross[i]!=0){
				(*Maximums)[j]=i; 
				(*Peek2)[j]=Peek[i]; 
				(*Curve2)[j]=Curve[i];  // approximately
				(*Directions)[j]=atan2( Center1[i].y-Peek[i].y, Center1[i].x-Peek[i].x); 
				(*Center2)[j]=Center1[i]; 
				j++;	
			}
		}
	}

	free(PointArray2);
	free(PointArray3);
	free(Deriv1);
	free(Deriv2);
	free(Curve);
	free(Deriv1Curve);
	free(Radius);
	free(Ratio);
	free(ZeroCross);
	free(Peek);
	free(Center1);

	return featurenumber;



}
