#include "writeFPS.h"

//writes fps to the image's top left corner
void writeFPS( clock_t start, clock_t end, double clockavg, IplImage *target )
{
	double fpst;
	char fps[128];

	//Fonts, character set
	CvFont dfont;
	cvInitFont( &dfont, CV_FONT_HERSHEY_PLAIN, 0.6f, 0.6f, 0.0f, 1, CV_AA);

	fpst = (double)( end - start )/CLOCKS_PER_SEC;

	sprintf_s( fps, "[fps : %2.5f]", 1/clockavg );
	cvRectangle( target, cvPoint(10,5), cvPoint(10+(int)(1/clockavg*5),20), CV_RGB( 255, 255, 255 ), CV_FILLED, 8, 0 );
	cvLine(target,cvPoint(10+(int)(1/fpst*5),5), cvPoint(10+(int)(1/fpst*5),20), cvScalar(128), 1, 8, 0 );  //

	cvPutText( target, fps, cvPoint(15, 15), &dfont, cvScalar(128) );
}