#include "CUIThread.h"

ThreadBase::ThreadBase()
: thread_(INVALID_HANDLE_VALUE), break_signal_(INVALID_HANDLE_VALUE), break_flag_(false)
{

}

ThreadBase::~ThreadBase()
{
	stop();
}

bool ThreadBase::start()
{
	if (thread_ != INVALID_HANDLE_VALUE) return false;
	
	if (break_signal_ != INVALID_HANDLE_VALUE) 	return false;
	break_signal_ = CreateEvent(NULL, FALSE, FALSE, NULL);

	thread_ = (HANDLE)_beginthreadex(
		NULL,
		0, 
		ThreadBase::entry_point_,
		(void *)this,
		0,
		NULL
		);

	return true;
}

void ThreadBase::stop()
{
	if (thread_ != INVALID_HANDLE_VALUE) {
		SetEvent(break_signal_);
		break_flag_ = true;
		::WaitForSingleObject(thread_, INFINITE);

		CloseHandle(break_signal_);
		break_signal_ = INVALID_HANDLE_VALUE;
		::CloseHandle(thread_);
		thread_ = INVALID_HANDLE_VALUE;
	}
}

bool ThreadBase::init()
{
	return true;
}

void ThreadBase::finish()
{

}

unsigned int __stdcall ThreadBase::entry_point_(void *data)
{
	ThreadBase *thread = (ThreadBase*)data;
	
	thread->break_flag_ = false;

	if (thread->init() == false) {
		_endthreadex(-1);
		return -1;
	}

	thread->run();

	thread->finish();

	_endthreadex(0);
	return 0;
}

CUIThread::CUIThread()
: thread_(INVALID_HANDLE_VALUE), break_signal_(INVALID_HANDLE_VALUE), break_flag_(false) 
{
};

CUIThread::~CUIThread()
{
	cui_stop();
};


bool CUIThread::cui_start()
{
	if (thread_ != INVALID_HANDLE_VALUE) return false;
	
	if (break_signal_ != INVALID_HANDLE_VALUE) 	return false;
	break_signal_ = CreateEvent(NULL, FALSE, FALSE, NULL);

	thread_ = (HANDLE)_beginthreadex(
		NULL,
		0, 
		CUIThread::cui_entry_point_,
		(void *)this,
		0,
		NULL
		);

	return true;
}

void CUIThread::cui_stop()
{
	if (thread_ != INVALID_HANDLE_VALUE) {
		SetEvent(break_signal_);
		break_flag_ = true;
		::WaitForSingleObject(thread_, INFINITE);

		CloseHandle(break_signal_);
		break_signal_ = INVALID_HANDLE_VALUE;
		::CloseHandle(thread_);
		thread_ = INVALID_HANDLE_VALUE;
	}
}

unsigned int __stdcall CUIThread::cui_entry_point_(void *data)
{
	CUIThread *thread = (CUIThread*)data;
	
	thread->break_flag_ = false;

	if (thread->cui_init() == false) return -1;

	while (!thread->break_flag_){
		thread->cui_run();
	}

	thread->cui_finish();
	_endthreadex(0);
	return 0;
};

bool CUIThread::cui_init()
{
	return true;
}

void CUIThread::cui_finish()
{
	
}

bool CUIThread::readline(char *buf, unsigned int buf_size, unsigned int &read_size) {
	memset(buf, 0, buf_size);
	read_size = 0;

	HANDLE std_in = GetStdHandle(STD_INPUT_HANDLE);
	SetConsoleMode(std_in, ENABLE_PROCESSED_INPUT);

	bool ret_val = false;
	while(true) {
		HANDLE h[2];
		h[0] = break_signal_;
		h[1] = std_in;
		DWORD rv = WaitForMultipleObjects(2, h, FALSE, INFINITE);

		DWORD err = GetLastError();
		if (rv == WAIT_OBJECT_0) {
			// abort
			memset(buf, 0, buf_size);
			read_size = 0;
			return false;
		}
		else {
			INPUT_RECORD input_record;
			DWORD s = 0;
			BOOL rv = ReadConsoleInput(std_in, &input_record, 1, &s);
			if (input_record.EventType == KEY_EVENT && input_record.Event.KeyEvent.bKeyDown) {
				switch(input_record.Event.KeyEvent.wVirtualKeyCode) {
				case VK_BACK:
					if (read_size > 0) {
						printf("\b \b");
						fflush(stdout);
						buf[read_size] = 0;
						read_size -= 1;
					}
					break;
				case VK_RETURN:
					printf("\n");
					fflush(stdout);
					return true;
				default:
					char c = (char)input_record.Event.KeyEvent.uChar.AsciiChar;
				
					if (read_size + 1 < buf_size) {
						// echo
						putc(c, stdout);
						fflush(stdout);

						buf[read_size] = c;
						read_size += 1;
					}
					break;
				}
			}
		}
	}
}

bool CUIThread::read_int_from_stdin(int &n)
{
	char buf[256];
	unsigned int read_size;
	bool rv = readline(buf, 256, read_size);
	n = atoi(buf);
	return rv;
}

bool CUIThread::read_float_from_stdin(float &f)
{
	char buf[256];
	unsigned int read_size;
	bool rv = readline(buf, 256, read_size);
	f = (float)atof(buf);
	return rv;
}
