#pragma once

#include <windows.h>
#include <stdio.h>
#include <process.h>

#define READ_INT_FROM_STDIN(x) {         \
  bool __rv__ = read_int_from_stdin(x);  \
  if (__rv__ == false) return;           \
}

#define READ_FLOAT_FROM_STDIN(x) {         \
  bool __rv__ = read_float_from_stdin(x);  \
  if (__rv__ == false) return;           \
}

class ThreadBase
{
protected:
	HANDLE thread_;
	bool break_flag_;
	HANDLE break_signal_;

public:
	ThreadBase();
	virtual ~ThreadBase();

	virtual bool start();
	virtual void stop();

protected:
	virtual bool init();
	virtual void finish();

	static unsigned int __stdcall entry_point_(void *data);

	virtual void run() = 0;
};

class CUIThread
{
protected:
	HANDLE thread_;
	bool break_flag_;
	HANDLE break_signal_;

public:
	CUIThread();
	virtual ~CUIThread();

	virtual bool cui_start();
	virtual void cui_stop();

protected:
	virtual bool cui_init();
	virtual void cui_finish();

	static unsigned int __stdcall cui_entry_point_(void *data);

	virtual void cui_run() = 0;

	bool readline(char *buf, unsigned int buf_size, unsigned int &read_size);
	bool read_int_from_stdin(int &n);
	bool read_float_from_stdin(float &f);
};
