// -*- C++ -*-
/*!
 * @file  PartialEdgeConsumer.cpp
 * @brief ModuleDescription
 * @date $Date$
 *
 * $Id$
 */

#include "PartialEdgeConsumer.h"

// Module specification
// <rtc-template block="module_spec">
static const char* partialedgeconsumer_spec[] =
  {
    "implementation_id", "PartialEdgeConsumer",
    "type_name",         "PartialEdgeConsumer",
    "description",       "ModuleDescription",
    "version",           "1.0.0",
    "vendor",            "TSB",
    "category",          "RecognitionService",
    "activity_type",     "PERIODIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    ""
  };
// </rtc-template>

PartialEdgeConsumer::PartialEdgeConsumer(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_positionIn("position", m_position),
    m_triggerPort("trigger"),
    // </rtc-template>
	dummy(0)
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  registerInPort("position", m_positionIn);
  
  // Set OutPort buffer
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  m_triggerPort.registerConsumer("recogPort", "RecognitionService", m_recogPort);
  
  // Set CORBA Service Ports
  registerPort(m_triggerPort);
  
  // </rtc-template>
}

PartialEdgeConsumer::~PartialEdgeConsumer()
{
}


/*
RTC::ReturnCode_t PartialEdgeConsumer::onInitialize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


RTC::ReturnCode_t PartialEdgeConsumer::onActivated(RTC::UniqueId ec_id)
{
  cui_start();
  on_execute_return_code = RTC::RTC_OK;
  printf("PartialEdgeConsumer::onActivated()\n");
  return RTC::RTC_OK;
}

RTC::ReturnCode_t PartialEdgeConsumer::onDeactivated(RTC::UniqueId ec_id)
{
  cui_stop();
  printf("PartialEdgeConsumer::onDeactivated()\n");
  return RTC::RTC_OK;
}

RTC::ReturnCode_t PartialEdgeConsumer::onExecute(RTC::UniqueId ec_id)
{
  return on_execute_return_code;
}

void PartialEdgeConsumer::cui_run()
{
  int vin,vout;
  int data = 0 ;

  printf("1:set value\n");
  printf("2:get value\n");
  printf("3:data display\n");
  READ_INT_FROM_STDIN(data);

  try {
  _CORBA_ULong bcd;
  switch(data){
  
   case 1:
		printf("enter value\n");
		READ_INT_FROM_STDIN(vout);
		m_recogPort->setModelID(vout);
	  break;

   case 2:
		 vin = m_recogPort->getModelID();
		 printf("%d\n",vin);
      break;
	 case 3:
			m_positionIn.read();
			bcd = m_position.data.length(); 
		  
			_CORBA_ULong j;
			printf("variable number = %d:  \n",bcd);
			for(j=0; j<bcd; j=j+1){
				printf("%f ",m_position.data[j]);
				if((j+1)%4==0)printf("\n");
			}
			printf("\n");
		 break;
   default:
	   break;
  }
  } catch(...) {
	  printf("Exception occured in PartialEdgeConsumer::cui_run()\n");
	  on_execute_return_code = RTC::RTC_ERROR;
  }
}

/*
RTC::ReturnCode_t PartialEdgeConsumer::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t PartialEdgeConsumer::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{
 
  void PartialEdgeConsumerInit(RTC::Manager* manager)
  {
    RTC::Properties profile(partialedgeconsumer_spec);
    manager->registerFactory(profile,
                             RTC::Create<PartialEdgeConsumer>,
                             RTC::Delete<PartialEdgeConsumer>);
  }
  
};


