#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file NAO_memory.py
 @brief Naoqi Memory Inserter
 @date $Date$


"""
import sys
import time
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist

import naoqi

# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>


# This module's spesification
# <rtc-template block="module_spec">
nao_memory_spec = ["implementation_id", "NAO_memory", 
		 "type_name",         "NAO_memory", 
		 "description",       "Naoqi Memory Inserter", 
		 "version",           "1.0.0", 
		 "vendor",            "Sugar Sweet Robotics", 
		 "category",          "Humanoi", 
		 "activity_type",     "STATIC", 
		 "max_instance",      "1", 
		 "language",          "Python", 
		 "lang_type",         "SCRIPT",
		 "conf.default.insert_key", "MyApplication/MyData",
		 "conf.default.extract_key", "MyApplication/MyData2",
                   "conf.default.ipaddress", "192.168.1.1",
                   "conf.default.port", "9559",

		 "conf.__widget__.key", "text",

         "conf.__type__.key", "string",

		 ""]
# </rtc-template>

##
# @class NAO_memory
# @brief Naoqi Memory Inserter
# 
# 
class NAO_memory(OpenRTM_aist.DataFlowComponentBase):
	
	##
	# @brief constructor
	# @param manager Maneger Object
	# 
	def __init__(self, manager):
		OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

		data_arg0 = [None] * ((len(RTC._d_TimedString) - 4) / 2)
		self._d_data = RTC.TimedString(*data_arg0)
		"""
		"""
		self._dataIn = OpenRTM_aist.InPort("data", self._d_data)

		data_arg1 = [None] * ((len(RTC._d_TimedString) - 4) / 2)
		self._d_e_data = RTC.TimedString(*data_arg1)
		"""
		"""
		self._extOut = OpenRTM_aist.OutPort("output", self._d_e_data)


		


		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
		"""
		
		 - Name:  key
		 - DefaultValue: nao_memory
		"""
		self._insert_key = ['nao_memory_from_RTM']
		self._extract_key = ['MyApplication/MyData2']
		self._ipaddress = ['192.168.252.116']
		self._port = [9559]
		
		# </rtc-template>


		 
	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
	def onInitialize(self):
		# Bind variables and configuration variable
		self.bindParameter("insert_key", self._insert_key, "nao_memory")
		self.bindParameter("extract_key", self._extract_key, "")
		self.bindParameter("ipaddress", self._ipaddress, "192.168.252.116")
		self.bindParameter("port", self._port, "9559")
		
		# Set InPort buffers
		self.addInPort("data",self._dataIn)
		
		# Set OutPort buffers
		self.addInPort("output",self._extOut)
		
		# Set service provider to Ports
		
		# Set service consumers to Ports
		
		# Set CORBA Service Ports
		
		return RTC.RTC_OK
	
	#	##
	#	# 
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The activated action (Active state entry action)
	#	# former rtc_active_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	# 
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	def onActivated(self, ec_id):
                print("Now connecting to NAO (%s:%s)" % (self._ipaddress[0], self._port[0]))
                
		self._proxy = naoqi.ALProxy("ALMemory", self._ipaddress[0], self._port[0])
		return RTC.RTC_OK
	
	#	##
	#	#
	#	# The deactivated action (Active state exit action)
	#	# former rtc_active_exit()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	def onDeactivated(self, ec_id):
		del self._proxy
		return RTC.RTC_OK
	
	#	##
	#	#
	#	# The execution action that is invoked periodically
	#	# former rtc_active_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	def onExecute(self, ec_id):
		
		if self._dataIn.isNew():
                
                        self._d_data = self._dataIn.read()
			
			value = self._d_data.data
                        print("Value is %s" % value)
			if len(self._insert_key[0]) > 0:
                                print("Key is %s" % self._insert_key[0])
				#self._proxy.insertData(self._insert_key[0], value)
                                self._proxy.raiseEvent(self._insert_key[0], value)

                print("Now checking %s data...." % self._extract_key[0]);
		if len(self._extract_key[0]) > 0:
                        try:
                                print("Extracting....");
                                value = self._proxy.getData(self._extract_key[0])
                                print("Extracted Data is %s" % value)

                                self._d_e_data.tm = RTC.Time(0,0)

                                self._d_e_data.data = value
                                self._extOut.write()
                        except:
                                pass
		return RTC.RTC_OK
	
	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK
	



def NAO_memoryInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=nao_memory_spec)
    manager.registerFactory(profile,
                            NAO_memory,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    NAO_memoryInit(manager)

    # Create a component
    comp = manager.createComponent("NAO_memory")

def main():
	mgr = OpenRTM_aist.Manager.init(sys.argv)
	mgr.setModuleInitProc(MyModuleInit)
	mgr.activateManager()
	mgr.runManager()

if __name__ == "__main__":
	main()

