#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file Test6.py
 @brief ModuleDescription
 @date $Date$


"""
import sys
import time
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist


# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>


# This module's spesification
# <rtc-template block="module_spec">
test6_spec = ["implementation_id", "Test6", 
		 "type_name",         "Test6", 
		 "description",       "ModuleDescription", 
		 "version",           "1.0.0", 
		 "vendor",            "yamaguchi", 
		 "category",          "proce", 
		 "activity_type",     "STATIC", 
		 "max_instance",      "1", 
		 "language",          "Python", 
		 "lang_type",         "SCRIPT",
		 ""]
# </rtc-template>

##
# @class Test6
# @brief ModuleDescription
# 
# 
class Test6(OpenRTM_aist.DataFlowComponentBase):
	
	##
	# @brief constructor
	# @param manager Maneger Object
	# 
	def __init__(self, manager):
		OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

		test6StringI1_arg = [None] * ((len(RTC._d_TimedString) - 4) / 2)
		self._d_test6StringI1 = RTC.TimedString(*test6StringI1_arg)
		"""
		"""
		self._test6StringI1In = OpenRTM_aist.InPort("test6StringI1", self._d_test6StringI1)
		test6Long1_arg = [None] * ((len(RTC._d_TimedLong) - 4) / 2)
		self._d_test6Long1 = RTC.TimedLong(*test6Long1_arg)
		"""
		"""
		self._test6Long1In = OpenRTM_aist.InPort("test6Long1", self._d_test6Long1)
		test6O1_arg = [None] * ((len(RTC._d_TimedLong) - 4) / 2)
		self._d_test6O1 = RTC.TimedLong(*test6O1_arg)
		"""
		"""
		self._test6O1Out = OpenRTM_aist.OutPort("test6O1", self._d_test6O1)


		


		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
		
		# </rtc-template>


		 
	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
	def onInitialize(self):
		# Bind variables and configuration variable
		
		# Set InPort buffers
		self.addInPort("test6StringI1",self._test6StringI1In)
		self.addInPort("test6Long1",self._test6Long1In)
		
		# Set OutPort buffers
		self._test6O1Out = RTC.TimedLong(RTC.Time(0,0),0)
		self._outport = OpenRTM_aist.OutPort("test6O1", self._test6O1Out)
		self.addOutPort("test6O1",self._outport)
		
		# Set service provider to Ports
		
		# Set service consumers to Ports
		
		# Set CORBA Service Ports
		
		return RTC.RTC_OK
	
	#	##
	#	# 
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK
	
		##
		#
		# The activated action (Active state entry action)
		# former rtc_active_entry()
		#
		# @param ec_id target ExecutionContext Id
		# 
		# @return RTC::ReturnCode_t
		#
		#
	def onActivated(self, ec_id):
	
		return RTC.RTC_OK
	
		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
	def onDeactivated(self, ec_id):
	
		return RTC.RTC_OK
	
		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
	def onExecute(self, ec_id):
#		print("Please Enter")
#		raw_input()
		if self._test6StringI1In.isNew():
			data = self._test6StringI1In.read()
			print("Recived: ",data)
			if data.data != "no":
				if self._test6Long1In.isNew():
					pulse = self._test6Long1In.read()
					print pulse.data
					if pulse.data == 1:
						data.data = "nao"
			if data.data == "green":
				self._test6O1Out.data = 1
				OpenRTM_aist.setTimestamp(self._test6O1Out)
				print("Sending to subscriber: ", data, self._test6O1Out.data)
				self._outport.write()
			elif data.data == "blue":
				self._test6O1Out.data = 2
				OpenRTM_aist.setTimestamp(self._test6O1Out)
				print("Sending to subscriber: ", data, self._test6O1Out.data)
				self._outport.write()
			elif data.data == "drink":
				self._test6O1Out.data = 3
				OpenRTM_aist.setTimestamp(self._test6O1Out)
				print("Sending to subscriber: ", data, self._test6O1Out.data)
				self._outport.write()
			elif data.data == "nao":
				self._test6O1Out.data = 4
				OpenRTM_aist.setTimestamp(self._test6O1Out)
				print("Sending to subscriber: ", data, self._test6O1Out.data)
				self._outport.write()
		return RTC.RTC_OK
	
	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK
	



def Test6Init(manager):
    profile = OpenRTM_aist.Properties(defaults_str=test6_spec)
    manager.registerFactory(profile,
                            Test6,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    Test6Init(manager)

    # Create a component
    comp = manager.createComponent("Test6")

def main():
	mgr = OpenRTM_aist.Manager.init(sys.argv)
	mgr.setModuleInitProc(MyModuleInit)
	mgr.activateManager()
	mgr.runManager()

if __name__ == "__main__":
	main()

