#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file AreaMonitor.py
 @brief ModuleDescription
 @date $Date$


"""
import sys
import time
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist

import SafetyManagerAreaChecker

# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>


# This module's spesification
# <rtc-template block="module_spec">
areamonitor_spec = ["implementation_id", "AreaMonitor", 
		 "type_name",         "AreaMonitor", 
		 "description",       "ModuleDescription", 
		 "version",           "1.0.0", 
		 "vendor",            "PAD", 
		 "category",          "-", 
		 "activity_type",     "STATIC", 
		 "max_instance",      "1", 
		 "language",          "Python", 
		 "lang_type",         "SCRIPT",
		 ""]
# </rtc-template>

##
# @class AreaMonitor
# @brief ModuleDescription
# 
# 
class AreaMonitor(OpenRTM_aist.DataFlowComponentBase):
	
	##
	# @brief constructor
	# @param manager Maneger Object
	# 
        def __init__(self, manager):
                self._r_checker = SafetyManagerAreaChecker.RangeChecker()
                OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

                _pose3D = RTC.Pose3D(RTC.Point3D(0.0, 0.0, 0.0),
                                     RTC.Orientation3D(0.0, 0.0, 0.0))
                _size3D = RTC.Size3D(0.0, 0.0, 0.0)
                _geometry3D = RTC.Geometry3D(_pose3D, _size3D)
                _rangeConfig = RTC.RangerConfig(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
                self._d_area_data = RTC.RangeData(RTC.Time(0,0),
                                                  [],
                                                  RTC.RangerGeometry(_geometry3D, []),
                                                  _rangeConfig)
                """
                """
                self._area_dataIn = OpenRTM_aist.InPort("area_data", self._d_area_data)
                self._d_is_object_detected = RTC.TimedBoolean(RTC.Time(0,0),False)
                """
                """
                self._is_object_detectedOut = OpenRTM_aist.OutPort("is_object_detected", self._d_is_object_detected)

		


		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
		
		# </rtc-template>


		 
	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
	def onInitialize(self):
		# Bind variables and configuration variable
		
		# Set InPort buffers
		self.addInPort("area_data",self._area_dataIn)
		
		# Set OutPort buffers
		self.addOutPort("is_object_detected",self._is_object_detectedOut)
		
		# Set service provider to Ports
		
		# Set service consumers to Ports
		
		# Set CORBA Service Ports
		
		return RTC.RTC_OK
	
	#	##
	#	# 
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The activated action (Active state entry action)
	#	# former rtc_active_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	# 
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onActivated(self, ec_id):
	#
	#	return RTC.RTC_OK
	
		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
	def onDeactivated(self, ec_id):
		self._r_checker.clear()
		return RTC.RTC_OK
	
		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
        def onExecute(self, ec_id):
                r = self._area_dataIn.read()
                RANGE_THRESHOULD_COUNT = 600
                RANGE_THRESHOULD_VALUE = 1.1

                self._r_checker.set_threshould(RANGE_THRESHOULD_COUNT,
                                               RANGE_THRESHOULD_VALUE)
                self._r_checker.set_range_data(r.ranges)
                if self._r_checker.is_detect():
                        self._d_is_object_detected.data = True
                else:
                        self._d_is_object_detected.data = False

                self._is_object_detectedOut.write()
                return RTC.RTC_OK
	
	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK
	



def AreaMonitorInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=areamonitor_spec)
    manager.registerFactory(profile,
                            AreaMonitor,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    AreaMonitorInit(manager)

    # Create a component
    comp = manager.createComponent("AreaMonitor")

def main():
	mgr = OpenRTM_aist.Manager.init(sys.argv)
	mgr.setModuleInitProc(MyModuleInit)
	mgr.activateManager()
	mgr.runManager()

if __name__ == "__main__":
	main()

