#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys


class RangeChecker:

    def __init__(self):
        self._th_cnt = 500
        self._th_val = 1.0
        self._detect = False
        self._detect_cnt = 0
        self._nodetect_cnt = 0

    def clear(self):
        self._detect = False
        self._detect_cnt = 0
        self._nodetect_cnt = 0

    def set_threshould(self, count, value):
        self._th_cnt = count
        self._th_val = value

    def set_range_data(self, ranges):
        count = 0
        for i in range(len(ranges)):
            if ranges[i] > self._th_val:
                count += 1

        if count < self._th_cnt:
            self._detect_cnt += 1
            self._nodetect_cnt = 0
            if self._detect_cnt > 5:
                self._detect = True
        else:
            self._detect_cnt = 0
            self._nodetect_cnt += 1
            if self._nodetect_cnt > 10:
                self._detect = False


    def is_detect(self):
        return self._detect
