#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

def is_valid_data(prev, now):
        return prev < now

def update_count(count, b):
        return count + 1 if b else 0

def is_count_over(count):
        return count >= 10

# 状態(valid/invalid)と異常データ/連続データの連続回数の更新
def mutual_check(p_valid, p_count, prev, now):
    if p_valid: # クラスが正常な場合
        # invalidの続いた回数を計算
        c = update_count(p_count, not is_valid_data(prev, now))
        # 回数が10回超えたら状態をinvalidにする
        if is_count_over(c):
            is_valid = False
            n_count = 0
        else:
            is_valid = True
            n_count = c
    else: # クラスが異常な場合
        # validの続いた回数を計算
        c = update_count(p_count, is_valid_data(prev, now))
        # 回数が10回超えたら状態をvalidにする
        if is_count_over(c):
            is_valid = True
            n_count = 0

        else:
            is_valid = False
            n_count = c

    return [is_valid, n_count]
