#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

import MutualMonitor_logic

test1_vector = [
        #状態が正常のとき
        [[True, 8, 0, 1], [True, 0]],           #データOK時のカウントリセット確認 (8->0)
        [[True, 8, 10000, 10001], [True, 0]],   #データOK時のカウントリセット確認 (8->0)
        [[True, 8, 0, 2], [True, 9]],           #データNOK時のカウントアップ確認 (8->9)
        [[True, 8, 10000, 10002], [True, 9]],   #データNOK時のカウントアップ確認 (8->9)
        [[True, 9, 0, 2], [False, 0]],          #状態変化のチェック
        [[True, 9, 10000, 10002], [False, 0]],  #状態変化のチェック
        [[True, 10, 0, 2], [False, 0]],         #状態変化のチェック
        [[True, 10, 10000, 10002], [False, 0]], #状態変化のチェック

        #状態が異常の時
        [[False, 8, 0, 2], [False, 0]],          #データNOK時のカウントリセット確認 (8->0)
        [[False, 8, 10000, 10002], [False, 0]],  #データNOK時のカウントリセット確認 (8->0)
        [[False, 8, 0, 1], [False, 9]],          #データOK時のカウントアップ確認 (8->9)
        [[False, 8, 10000, 10001], [False, 9]],  #データOK時のカウントアップ確認 (8->9)
        [[False, 9, 0, 1], [True, 0]],           #状態変化のチェック
        [[False, 9, 10000, 10001], [True, 0]],   #状態変化のチェック
        [[False, 10, 0, 1], [True, 0]],          #状態変化のチェック
        [[False, 10, 10000, 10001], [True, 0]],  #状態変化のチェック
]

def test1(v):
        inp = v[0]
        exp = v[1]

        i_v  = inp[0]
        i_c  = inp[1]
        i_d0 = inp[2]
        i_d1 = inp[3]
        is_valid, n_count = MutualMonitor_logic.mutual_check(i_v, i_c, i_d0, i_d1)

        if not (is_valid == exp[0] and n_count == exp[1]):
                print 'Fail:' \
                        + 'In:v,c,d0,d1=' + str(i_v) + ',' + str(i_c) + ',' + str(i_d0) + ',' + str(i_d1)\
                        + ' Out(Exp):v,c=' + str(is_valid) + '(' + str(exp[0]) + '),' + str(n_count) + '(' + str(exp[1]) + ')'
        else:
                print 'OK'

# mutual_checkのテスト
map(test1, test1_vector)
