#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file RobotArmSafetyController.py
 @brief ModuleDescription
 @date $Date$


"""
import sys
import time
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist


# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>


# This module's spesification
# <rtc-template block="module_spec">
robotarmsafetycontroller_spec = ["implementation_id", "RobotArmSafetyController", 
		 "type_name",         "RobotArmSafetyController", 
		 "description",       "ModuleDescription", 
		 "version",           "1.0.0", 
		 "vendor",            "PAD", 
		 "category",          "-", 
		 "activity_type",     "STATIC", 
		 "max_instance",      "1", 
		 "language",          "Python", 
		 "lang_type",         "SCRIPT",
		 ""]
# </rtc-template>

##
# @class RobotArmSafetyController
# @brief ModuleDescription
# 
# 
class RobotArmSafetyController(OpenRTM_aist.DataFlowComponentBase):
	
	##
	# @brief constructor
	# @param manager Maneger Object
	# 
	def __init__(self, manager):
		OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

		self._d_safety_mode = RTC.TimedBoolean(RTC.Time(0,0), False)
		"""
		"""
		self._safety_modeIn = OpenRTM_aist.InPort("safety_mode", self._d_safety_mode)
		self._d_robotarm_control_main = RTC.TimedFloatSeq(RTC.Time(0,0), [0 for i in range(7)])
		"""
		"""
		self._robotarm_control_mainIn = OpenRTM_aist.InPort("robotarm_control_main", self._d_robotarm_control_main)
		self._d_robotarm_status = RTC.TimedFloatSeq(RTC.Time(0,0), [0 for i in range(7)])
		"""
		"""
		self._robotarm_statusIn = OpenRTM_aist.InPort("robotarm_status", self._d_robotarm_status)
		self._d_robotarm_control_signal = RTC.TimedFloatSeq(RTC.Time(0,0), [0 for i in range(7)])
		"""
		"""
		self._robotarm_control_signalOut = OpenRTM_aist.OutPort("robotarm_control_signal", self._d_robotarm_control_signal)


		


		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
		
		# </rtc-template>


		 
	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
	def onInitialize(self):
		# Bind variables and configuration variable
		
		# Set InPort buffers
		self.addInPort("safety_mode",self._safety_modeIn)
		self.addInPort("robotarm_control_main",self._robotarm_control_mainIn)
		self.addInPort("robotarm_status",self._robotarm_statusIn)
		
		# Set OutPort buffers
		self.addOutPort("robotarm_control_signal",self._robotarm_control_signalOut)
		
		# Set service provider to Ports
		
		# Set service consumers to Ports
		
		# Set CORBA Service Ports
		
		return RTC.RTC_OK
	
	#	##
	#	# 
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The activated action (Active state entry action)
	#	# former rtc_active_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	# 
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onActivated(self, ec_id):
	#
	#	return RTC.RTC_OK
	
		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
	def onDeactivated(self, ec_id):
	
		return RTC.RTC_OK
	
		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
        def onExecute(self, ec_id):
                if self._safety_modeIn.read().data == False:
                        self._d_robotarm_control_signal.data = self._robotarm_statusIn.read().data
                else:
                        self._d_robotarm_control_signal.data = self._robotarm_control_mainIn.read().data
                self._robotarm_control_signalOut.write()
                return RTC.RTC_OK
	
	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK
	



def RobotArmSafetyControllerInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=robotarmsafetycontroller_spec)
    manager.registerFactory(profile,
                            RobotArmSafetyController,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    RobotArmSafetyControllerInit(manager)

    # Create a component
    comp = manager.createComponent("RobotArmSafetyController")

def main():
	mgr = OpenRTM_aist.Manager.init(sys.argv)
	mgr.setModuleInitProc(MyModuleInit)
	mgr.activateManager()
	mgr.runManager()

if __name__ == "__main__":
	main()

