#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file SignalSelector.py
 @brief ModuleDescription
 @date $Date$


"""
import sys
import time
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist


# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>


# This module's spesification
# <rtc-template block="module_spec">
signalselector_spec = ["implementation_id", "SignalSelector", 
		 "type_name",         "SignalSelector", 
		 "description",       "ModuleDescription", 
		 "version",           "1.0.0", 
		 "vendor",            "PAD", 
		 "category",          "Category", 
		 "activity_type",     "STATIC", 
		 "max_instance",      "1", 
		 "language",          "Python", 
		 "lang_type",         "SCRIPT",
		 ""]
# </rtc-template>

##
# @class SignalSelector
# @brief ModuleDescription
# 
# 
class SignalSelector(OpenRTM_aist.DataFlowComponentBase):

	##
	# @brief constructor
	# @param manager Maneger Object
	# 
	def __init__(self, manager):
		OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

		self._d_is_failuer_detected1 = RTC.TimedBoolean(RTC.Time(0, 0), 0)
		"""
		"""
		self._is_failuer_detected1In = OpenRTM_aist.InPort("is_failuer_detected1", self._d_is_failuer_detected1)
		self._d_is_failuer_detected2 = RTC.TimedBoolean(RTC.Time(0, 0), 0)
		"""
		"""
		self._is_failuer_detected2In = OpenRTM_aist.InPort("is_failuer_detected2", self._d_is_failuer_detected2)
		self._d_robotarm_control_signal1 = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
		"""
		"""
		self._robotarm_control_signal1In = OpenRTM_aist.InPort("robotarm_control_signal1", self._d_robotarm_control_signal1)
		self._d_robotarm_control_signal2 = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
		"""
		"""
		self._robotarm_control_signal2In = OpenRTM_aist.InPort("robotarm_control_signal2", self._d_robotarm_control_signal2)
		self._d_gripper_control_signal1 = RTC.TimedOctet(RTC.Time(0, 0), 0)
		"""
		"""
		self._gripper_control_signal1In = OpenRTM_aist.InPort("gripper_control_signal1", self._d_gripper_control_signal1)
		self._d_gripper_control_signal2 = RTC.TimedOctet(RTC.Time(0, 0), 0)
		"""
		"""
		self._gripper_control_signal2In = OpenRTM_aist.InPort("gripper_control_signal2", self._d_gripper_control_signal2)
		self._d_warning_signal = RTC.TimedBoolean(RTC.Time(0, 0), 0)
		"""
		"""
		self._warning_signalOut = OpenRTM_aist.OutPort("warning_signal", self._d_warning_signal)
		self._d_gripper_control_signal = RTC.TimedOctet(RTC.Time(0, 0), 0)
		"""
		"""
		self._gripper_control_signalOut = OpenRTM_aist.OutPort("gripper_control_signal", self._d_gripper_control_signal)
		self._d_robotarm_signal = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
		"""
		"""
		self._robotarm_signalOut = OpenRTM_aist.OutPort("robotarm_signal", self._d_robotarm_signal)


		


		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
		
		# </rtc-template>


		 
	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
	def onInitialize(self):
		# Bind variables and configuration variable
		
		# Set InPort buffers
		self.addInPort("is_failuer_detected1",self._is_failuer_detected1In)
		self.addInPort("is_failuer_detected2",self._is_failuer_detected2In)
		self.addInPort("robotarm_control_signal1",self._robotarm_control_signal1In)
		self.addInPort("robotarm_control_signal2",self._robotarm_control_signal2In)
		self.addInPort("gripper_control_signal1",self._gripper_control_signal1In)
		self.addInPort("gripper_control_signal2",self._gripper_control_signal2In)
		
		# Set OutPort buffers
		self.addOutPort("warning_signal",self._warning_signalOut)
		self.addOutPort("gripper_control_signal",self._gripper_control_signalOut)
		self.addOutPort("robotarm_signal",self._robotarm_signalOut)
		
		# Set service provider to Ports
		
		# Set service consumers to Ports
		
		# Set CORBA Service Ports
		
		return RTC.RTC_OK
	
	#	##
	#	# 
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The activated action (Active state entry action)
	#	# former rtc_active_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	# 
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onActivated(self, ec_id):
	#
	#	return RTC.RTC_OK
	
		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
	def onDeactivated(self, ec_id):
		self._d_warning_signal.data = False
		self._d_gripper_control_signal.data = 0
		self._d_robotarm_signal.data = [0 for i in range(7)]

		self._warning_signalOut.write()
		self._gripper_control_signalOut.write()
		self._robotarm_signalOut.write()
		return RTC.RTC_OK
	
		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
	def onExecute(self, ec_id):
		if not self._is_failuer_detected1In.read().data or not self._is_failuer_detected2In.read().data:
			self._d_warning_signal.data = True
		else:
			self._d_warning_signal.data = False

		if self._is_failuer_detected1In.read().data:
			self._d_gripper_control_signal.data = self._gripper_control_signal1In.read().data
			self._d_robotarm_signal.data = self._robotarm_control_signal1In.read().data
		elif self._is_failuer_detected2In.read().data:
			self._d_gripper_control_signal.data = self._gripper_control_signal2In.read().data
			self._d_robotarm_signal.data = self._robotarm_control_signal2In.read().data
		else:
			self._d_gripper_control_signal.data = self._gripper_control_signal1In.read().data
			self._d_robotarm_signal.data = self._robotarm_control_signal1In.read().data
			#self._d_gripper_control_signal.data = 0
			#self._d_robotarm_signal.data = [0 for i in range(7)]

		self._warning_signalOut.write()
		self._gripper_control_signalOut.write()
		self._robotarm_signalOut.write()
		return RTC.RTC_OK
	
	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK
	



def SignalSelectorInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=signalselector_spec)
    manager.registerFactory(profile,
                            SignalSelector,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    SignalSelectorInit(manager)

    # Create a component
    comp = manager.createComponent("SignalSelector")

def main():
	mgr = OpenRTM_aist.Manager.init(sys.argv)
	mgr.setModuleInitProc(MyModuleInit)
	mgr.activateManager()
	mgr.runManager()

if __name__ == "__main__":
	main()

