#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file SystemManagerRTC.py
 @brief SystemManagerRTC
 @date $Date$


"""
import sys
sys.path.append(".")
import time

# Import RTM module
import RTC
import OpenRTM_aist

# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">

# </rtc-template>

import SystemManagerState
import SystemManagerTeaching


# This module's spesification
# <rtc-template block="module_spec">
systemmanagerrtc_spec = ["implementation_id", "SystemManagerRTC",
        "type_name",         "SystemManagerRTC",
        "description",       "SystemManagerRTC",
        "version",           "1.0.0",
        "vendor",            "Takahashi",
        "category",          "Manager",
        "activity_type",     "STATIC",
        "max_instance",      "1",
        "language",          "Python",
        "lang_type",         "SCRIPT",
        ""]
# </rtc-template>

##
# @class SystemManagerRTC
# @brief SystemManagerRTC
#
#
class SystemManagerRTC(OpenRTM_aist.DataFlowComponentBase):

	##
	# @brief constructor
	# @param manager Maneger Object
	#
    def __init__(self, manager):
        OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

        self._d_arm_cur_pos = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._arm_cur_posIn = OpenRTM_aist.InPort("arm_cur_pos", self._d_arm_cur_pos)

        self._d_teach_start = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._teach_startIn = OpenRTM_aist.InPort("teach_start", self._d_teach_start)

        self._d_teach_set = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._teach_setIn = OpenRTM_aist.InPort("teach_set", self._d_teach_set)

        self._d_teach_cancel = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._teach_cancelIn = OpenRTM_aist.InPort("teach_cancel", self._d_teach_cancel)

        self._d_task_start = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._task_startIn = OpenRTM_aist.InPort("tasK_start", self._d_task_start)

        self._d_task_restart = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._task_restartIn = OpenRTM_aist.InPort("tasK_restart", self._d_task_restart)

        self._d_task_cancel = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._task_cancelIn = OpenRTM_aist.InPort("tasK_cancel", self._d_task_cancel)

        self._d_arm_pos = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._arm_posOut = OpenRTM_aist.OutPort("arm_pos", self._d_arm_pos)

        self._d_grip = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._gripOut = OpenRTM_aist.OutPort("grip", self._d_grip)

        # initialize of configuration-data.
        # <rtc-template block="init_conf_param">

        # </rtc-template>

        self._state = SystemManagerState.SystemState()
        self._teach = SystemManagerTeaching.TeachingManager()
        self.log = OpenRTM_aist.Manager.instance().getLogbuf("SystemManager")
        self._current_arm_pos = [float(0) for i in range(7)]

    ##
    #
    # The initialize action (on CREATED->ALIVE transition)
    # formaer rtc_init_entry()
    #
	# @return RTC::ReturnCode_t
	#
	#
    def onInitialize(self):
        # Bind variables and configuration variable

        # Set InPort buffers
        self.addInPort("arm_cur_pos",self._arm_cur_posIn)
        self.addInPort("teach_start",self._teach_startIn)
        self.addInPort("teach_set",self._teach_setIn)
        self.addInPort("teach_cancel",self._teach_cancelIn)
        self.addInPort("task_start",self._task_startIn)
        self.addInPort("task_restart",self._task_restartIn)
        self.addInPort("task_cancel",self._task_cancelIn)

		# Set OutPort buffers
        self.addOutPort("arm_pos",self._arm_posOut)
        self.addOutPort("grip",self._gripOut)

		# Set service provider to Ports

		# Set service consumers to Ports

        # Set CORBA Service Ports

        return RTC.RTC_OK

	#	##
	#	#
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	#
	#	# @return RTC::ReturnCode_t
	#
	#	#
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK

		##
		#
		# The activated action (Active state entry action)
		# former rtc_active_entry()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onActivated(self, ec_id):

        self._state.clear()
        self._state.set_goal(self._teach.get_points())

        return RTC.RTC_OK

		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onDeactivated(self, ec_id):

        return RTC.RTC_OK

        ##
        #
        # The execution action that is invoked periodically
        # former rtc_active_do()
        #
        # @param ec_id target ExecutionContext Id
        #
        # @return RTC::ReturnCode_t
        #
        #
    def onExecute(self, ec_id):

        if self._task_startIn.isNew():
            if self._task_startIn.read().data and self._state.can_task_start():
                self.log.RTC_INFO("task is started")
                self._state.task_start()

        if self._task_restartIn.isNew():
            if self._task_restartIn.read().data and self._state.can_task_start():
                self.log.RTC_INFO("task is restarted")
                self._state.task_start()

        if self._task_cancelIn.isNew():
            if self._task_cancelIn.read().data and self._state.is_task_started():
                self.log.RTC_INFO("task is canceled")
                self._state.task_stop()
                self._state.clear()
                self._arm_control()

        if True:
            if self._state.is_task_started():
                grip, pos = self._state.get_goal()
                # check current positon & goal position for each joints
                for i in range(7):
                    self._state.next_state()
                    self._arm_control()
                    time.sleep(5)

        return RTC.RTC_OK

	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK

    def _arm_control(self):
        grip, pos = self._state.get_goal()
        self.log.RTC_INFO("grip: " + str(grip))
        self.log.RTC_INFO("pos: " + str(pos))
        self._d_grip.data = grip
        self._gripOut.write()
        self._d_arm_pos.data = pos
        self._arm_posOut.write()


def SystemManagerRTCInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=systemmanagerrtc_spec)
    manager.registerFactory(profile,
                            SystemManagerRTC,
                            OpenRTM_aist.Delete)


def MyModuleInit(manager):
    SystemManagerRTCInit(manager)

    # Create a component
    comp = manager.createComponent("SystemManagerRTC")


def main():
    mgr = OpenRTM_aist.Manager.init(sys.argv)
    mgr.setModuleInitProc(MyModuleInit)
    mgr.activateManager()
    mgr.runManager()

if __name__ == "__main__":
    main()
