#!/usr/bin/env python
## -*- coding: utf-8 -*-

class SystemState:

    def __init__(self):
        self._task_started = False
        self._teach_started = False
        self._state = 0
        self._max_state = 13
        self._p = [[0 for i in range(7)] for j in range(5)]

    def clear(self):
        self._task_started = False
        self._teach_started = False
        self._state = 0

    def task_start(self):
        self._task_started = True

    def task_stop(self):
        self._task_started = False

    def is_task_started(self):
        return self._task_started

    def can_task_start(self):
        return not self._task_started and not self._teach_started

    def teach_start(self):
        self._teach_started = True

    def teach_stop(self):
        self._teach_started = False

    def is_teach_started(self):
        return self._teach_started

    def can_teach_start(self):
        return not self._task_started and not self._teach_started

    def next_state(self):
        self._state = (self._state + 1) % (self._max_state + 1)
        if self._state == 0:
            self._state = 1

    def stay_state(self):
        if self._state == 0:
            self._state = self._max_state
        else:
            self._state -= 1

    def set_goal(self, p):
        print 'set goal 1: ' + str(p[0])
        print 'set goal 2: ' + str(p[1])
        print 'set goal 3: ' + str(p[2])
        print 'set goal 4: ' + str(p[3])
        print 'set goal 5: ' + str(p[4])
        self._p[0] = map(float, p[0])
        self._p[1] = map(float, p[1])
        self._p[2] = map(float, p[2])
        self._p[3] = map(float, p[3])
        self._p[4] = map(float, p[4])

    def get_goal(self):
        if self._state == 0:
            #print 'initialize'
            grip = 0
            pos = [0, 0, 0, 25.87, 0, 3.53, 0]

        elif self._state == 1:
            #print 'move to item'
            grip = 0
            pos = self._p[0]

        elif self._state == 2:
            #print 'turn on vacuum & down tool'
            grip = 1
            pos = self._p[1]

        elif self._state == 3:
            #print 'up tool'
            grip = 1
            pos = self._p[0]

        elif self._state == 4:
            #print 'move to goal immediately'
            grip = 1
            pos = self._p[2]

        elif self._state == 5:
            #print 'move to goal'
            grip = 1
            pos = self._p[3]

        elif self._state == 6:
            #print 'down tool'
            grip = 1
            pos = self._p[4]

        elif self._state == 7:
            #print 'turn off vacuum & up tool'
            grip = 2
            pos = self._p[3]

        elif self._state == 8:
            #print 'turn on vacuum & down tool'
            grip = 1
            pos = self._p[4]

        elif self._state == 9:
            #print 'up tool'
            grip = 1
            pos = self._p[3]

        elif self._state == 10:
            #print 'move to goal immediately'
            grip = 1
            pos = self._p[2]

        elif self._state == 11:
            #print 'move to item'
            grip = 1
            pos = self._p[0]

        elif self._state == 12:
            #print 'down tool'
            grip = 1
            pos = self._p[1]

        elif self._state == 13:
            #print 'up tool'
            grip = 2
            pos = self._p[0]

        else:
            #print 'unknown state'
            grip = 0
            pos = [0, 0, 0, 0, 0, 0, 0]

        return grip, pos
