#!/usr/bin/env python
## -*- coding: utf-8 -*-

import csv
import math


class TeachingManager:

    def __init__(self):
        self._org_points = [[0 for i in range(7)] for j in range(5)]
        self._points_ptr = 0
        self._tp_file = 'teaching_data.csv'

        # restore teaching points
        try:
            with open(self._tp_file, 'rb') as f:
                reader = csv.reader(f)
                row = 0
                for p in reader:
                    self._org_points[row] = p
                    row += 1
        except:
            print 'cannot open teaching file: ' + self._tp_file

        self._points = self._org_points

    def clear(self):
        self._points = [[0 for i in range(7)] for j in range(5)]
        self._points = self._org_points
        self._points_ptr = 0

    def set(self, p):
        if self._points_ptr < 5:
            self._points[self._points_ptr] = map(math.degrees, p)
            self._points_ptr += 1

        if self._points_ptr > 4:
            self._org_points = self._points
            # record teaching points
            try:
                with open(self._tp_file, 'w') as f:
                    writer = csv.writer(f, lineterminator='\n')
                    writer.writerows(self._points)
            except:
                print 'cannot save teaching file: ' + self._tp_file
            return -1
        else:
            return 0

    def get_points(self):
        return self._points
