#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-


import Tkinter as tk
import tkFont
import Queue

class Application(tk.Frame):
    def __init__(self, master=None):
        self._label_height = 2
        self._button_height = 3
        self._button_width = 10
        self._button_border = 5
        self._q = Queue.Queue()
        self._active = False
        tk.Frame.__init__(self, master)
        # create a custom font
        self._label_font = tkFont.Font(family="Helvetica", size=25, weight="bold")
        self._button_font = tkFont.Font(family="Helvetica", size=20, underline=1)
        self.pack(expand=1, fill=tk.BOTH, anchor=tk.NW)
        self._create_widgets()

    def activate(self):
        self._active = True
        return

    def deactivate(self):
        self._active = False
        while not self._q.empty():
            self._q.get()
        return

    def get_button(self):
        if self._q.empty():
            button = 'none'
        else:
            try:
                button = self._q.get(block=False)
            except Queue.Empty:
                button = 'none'
        return button

    def _push_button(self, button):
        if self._active:
            print 'push: ' + button
            self._q.put(button)
        return

    def _create_label(self, string):
        return tk.Label(self,
                        text=string,
                        height=self._label_height,
                        font=self._label_font)

    def _create_button(self, string, color_type, param):
        if color_type == 'yellow':
            bg_color = 'lightyellow'
            active_bg_color='yellow'
        elif color_type == 'blue':
            bg_color = 'azure'
            active_bg_color = 'aqua'
        else:
            bg_color = 'lightyellow'
            active_bg_color='yellow'

        return tk.Button(self,
                         text=string,
                         bd=self._button_border,
                         bg=bg_color,
                         activebackground=active_bg_color,
                         height=self._button_height,
                         width=self._button_width,
                         font=self._button_font,
                         command=lambda: self._push_button(param))


    def _create_widgets(self):
        # set teach label
        self.lbl_tch = self._create_label('Teaching')
        self.lbl_tch.grid(column=0, row=0)

        # set teach buttons
        self.btn_tch_start = self._create_button('Start', 'yellow', 'teach_start')
        self.btn_tch_start.grid(column=0, row=1)
        self.btn_tch_set = self._create_button('Set', 'yellow', 'teach_set')
        self.btn_tch_set.grid(column=1, row=1)
        self.btn_tch_cancel = self._create_button('Cancel', 'yellow', 'teach_cancel')
        self.btn_tch_cancel.grid(column=2, row=1)

        # set task label
        self.lbl_tsk = self._create_label('Task')
        self.lbl_tsk.grid(column=0, row=2)

        # set task buttons
        self.btn_tsk_start = self._create_button('Start', 'blue', 'task_start')
        self.btn_tsk_start.grid(column=0, row=3)
        self.btn_tsk_restart = self._create_button('Restart', 'blue', 'task_restart')
        self.btn_tsk_restart.grid(column=1, row=3)
        self.btn_tsk_cancel = self._create_button('Cancel', 'blue', 'task_cancel')
        self.btn_tsk_cancel.grid(column=2, row=3)


def test():
    app = Application()
    app.activate()
    app.mainloop()

