#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file TkButtonManagerRTC.py
 @brief TkButtonManagerRTC
 @date $Date$


"""
import sys
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist


# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>

import TkButtonManager

tkButtonManager = TkButtonManager.Application()

# This module's spesification
# <rtc-template block="module_spec">
tkbuttonmanagerrtc_spec = ["implementation_id", "TkButtonManagerRTC",
    "type_name",         "TkButtonManagerRTC",
    "description",       "TkButtonManagerRTC",
    "version",           "1.0.0",
    "vendor",            "takahashi",
    "category",          "Sensor",
    "activity_type",     "STATIC",
    "max_instance",      "1",
    "language",          "Python",
    "lang_type",         "SCRIPT",
""]
# </rtc-template>

##
# @class TkButtonManagerRTC
# @brief TkButtonManagerRTC
#
#
class TkButtonManagerRTC(OpenRTM_aist.DataFlowComponentBase):

	##
	# @brief constructor
	# @param manager Maneger Object
	#
    def __init__(self, manager):
        OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

        self._d_teach_start = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._teach_startOut = OpenRTM_aist.OutPort("teach_start", self._d_teach_start)

        self._d_teach_set = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._teach_setOut = OpenRTM_aist.OutPort("teach_set", self._d_teach_set)

        self._d_teach_cancel = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._teach_cancelOut = OpenRTM_aist.OutPort("teach_cancel", self._d_teach_cancel)

        self._d_task_start = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._task_startOut = OpenRTM_aist.OutPort("task_start", self._d_task_start)

        self._d_task_restart = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._task_restartOut = OpenRTM_aist.OutPort("task_restart", self._d_task_restart)

        self._d_task_cancel = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._task_cancelOut = OpenRTM_aist.OutPort("task_cancel", self._d_task_cancel)

        # initialize of configuration-data.
        # <rtc-template block="init_conf_param">

        # </rtc-template>

        self.log = OpenRTM_aist.Manager.instance().getLogbuf("TkButtonManager")
        self._button_mgr = tkButtonManager

    ##
    #
    # The initialize action (on CREATED->ALIVE transition)
    # formaer rtc_init_entry()
    #
    # @return RTC::ReturnCode_t
    #
    #
    def onInitialize(self):
        # Bind variables and configuration variable

        # Set InPort buffers

        # Set OutPort buffers
        self.addOutPort("teach_start", self._teach_startOut)
        self.addOutPort("teach_set", self._teach_setOut)
        self.addOutPort("teach_cancel", self._teach_cancelOut)
        self.addOutPort("task_start", self._task_startOut)
        self.addOutPort("task_restart", self._task_restartOut)
        self.addOutPort("task_cancel", self._task_cancelOut)

        # Set service provider to Ports

        # Set service consumers to Ports

        # Set CORBA Service Ports

        return RTC.RTC_OK

    #   ##
    #   #
    #   # The finalize action (on ALIVE->END transition)
    #   # formaer rtc_exiting_entry()
    #   #
    #   # @return RTC::ReturnCode_t
	#
	#	#
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
    #   # @return RTC::ReturnCode_t
    #   #
    #   #
    #def onShutdown(self, ec_id):
    #
    #   return RTC.RTC_OK

        ##
        #
        # The activated action (Active state entry action)
        # former rtc_active_entry()
        #
        # @param ec_id target ExecutionContext Id
        #
        # @return RTC::ReturnCode_t
        #
        #
    def onActivated(self, ec_id):

        self._button_mgr.activate()

        return RTC.RTC_OK

        ##
        #
        # The deactivated action (Active state exit action)
        # former rtc_active_exit()
        #
        # @param ec_id target ExecutionContext Id
        #
        # @return RTC::ReturnCode_t
        #
        #
    def onDeactivated(self, ec_id):

        self._button_mgr.deactivate()

        return RTC.RTC_OK

        ##
        #
        # The execution action that is invoked periodically
        # former rtc_active_do()
        #
        # @param ec_id target ExecutionContext Id
        #
        # @return RTC::ReturnCode_t
        #
        #
    def onExecute(self, ec_id):

        button = self._button_mgr.get_button()

        if button != 'none':
            self.log.RTC_INFO("button handling: " + button)

            if button == 'teach_start':
                self._d_teach_start.data = 1
                self._teach_startOut.write()

            elif button == 'teach_set':
                self._d_teach_set.data = 1
                self._teach_setOut.write()

            elif button == 'teach_cancel':
                self._d_teach_cancel.data = 1
                self._teach_cancelOut.write()

            elif button == 'task_start':
                self._d_task_start.data = 1
                self._task_startOut.write()

            elif button == 'task_restart':
                self._d_task_restart.data = 1
                self._task_restartOut.write()

            elif button == 'task_cancel':
                self._d_task_cancel.data = 1
                self._task_cancelOut.write()

        return RTC.RTC_OK

    #   ##
    #   #
    #   # The aborting action when main logic error occurred.
    #   # former rtc_aborting_entry()
    #   #
    #   # @param ec_id target ExecutionContext Id
    #   #
    #   # @return RTC::ReturnCode_t
    #   #
    #   #
    #def onAborting(self, ec_id):
    #
    #   return RTC.RTC_OK

    #   ##
    #   #
    #   # The error action in ERROR state
    #   # former rtc_error_do()
    #   #
    #   # @param ec_id target ExecutionContext Id
    #   #
    #   # @return RTC::ReturnCode_t
    #   #
    #   #
    #def onError(self, ec_id):
    #
    #   return RTC.RTC_OK

    #   ##
    #   #
    #   # The reset action that is invoked resetting
    #   # This is same but different the former rtc_init_entry()
    #   #
    #   # @param ec_id target ExecutionContext Id
    #   #
    #   # @return RTC::ReturnCode_t
    #   #
    #   #
    #def onReset(self, ec_id):
    #
    #   return RTC.RTC_OK

    #   ##
    #   #
    #   # The state update action that is invoked after onExecute() action
    #   # no corresponding operation exists in OpenRTm-aist-0.2.0
    #   #
    #   # @param ec_id target ExecutionContext Id
    #   #
    #   # @return RTC::ReturnCode_t
    #   #

    #   #
    #def onStateUpdate(self, ec_id):
    #
    #   return RTC.RTC_OK

    #   ##
    #   #
    #   # The action that is invoked when execution context's rate is changed
    #   # no corresponding operation exists in OpenRTm-aist-0.2.0
    #   #
    #   # @param ec_id target ExecutionContext Id
    #   #
    #   # @return RTC::ReturnCode_t
    #   #
    #   #
    #def onRateChanged(self, ec_id):
    #
    #   return RTC.RTC_OK


def TkButtonManagerRTCInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=tkbuttonmanagerrtc_spec)
    manager.registerFactory(profile,
                            TkButtonManagerRTC,
                            OpenRTM_aist.Delete)


def MyModuleInit(manager):
    TkButtonManagerRTCInit(manager)

    # Create a component
    comp = manager.createComponent("TkButtonManagerRTC")


def main():
    mgr = OpenRTM_aist.Manager.init(sys.argv)
    mgr.setModuleInitProc(MyModuleInit)
    mgr.activateManager()
    mgr.runManager(True)
    tkButtonManager.mainloop()

if __name__ == "__main__":
    main()
