#!/usr/bin/env python
## -*- coding: utf-8 -*-
import zmq
import json
import time
import threading
import Queue

class Controller():

    def __init__(self):
        self._stub = False
        self._moving = False
        self._moving_time = 0
        self._ctx = zmq.Context()
        self._sock = self._ctx.socket(zmq.REQ)
        self._sock.connect('tcp://localhost:5555')
        self._send_command_q = Queue.Queue()
        self._stop_event = threading.Event()
        self._thread = threading.Thread(target=self.run)
        self._thread.start()

    def run(self):
        while not self._stop_event.is_set():
            command = self._send_command_q.get()
            print json.dumps(command)
            if self._stub == False:
                self._sock.send(json.dumps(command))
                state = self._sock.recv()
                time.sleep(0.01)

            if command["command"] == "--ts":
                self._moving = True
                time.sleep(self._moving_time)
                self._moving = False

            self._send_command_q.task_done()

    def stop(self):
        self._stop_event.set()
        self.reset() # to put quueue
        self._thread.join()
        self._sock.close()
        self._ctx.term()

    def set_mode(self, stub=False):
        self._stub = stub

    def send_command(self, command):
        self._send_command_q.put(command)

    def clear_command(self):
        c = {
            "command": "--tc",
            "joint_id": "all"
        }
        self.send_command(c)
        return

    def reset(self):
        c = {
            "command": "--reset",
            "joint_id": "all",
        }
        self.send_command(c)
        return

    def servo_on(self):
        c = {
            "command": "--servo",
            "servo_state": "ON",
            "joint_id": "all",
        }
        self.send_command(c)
        return

    def mode_point(self):
        c = {
            "command": "--mode",
            "mode_id": "20",
            "joint_id": "all"
        }
        self.send_command(c)
        return

    def mode_free(self):
        c = {
            "command": "--mode",
            "mode_id": "5",
            "joint_id": "all"
        }
        self.send_command(c)
        return

    def move_home(self, speed):
        self.move([0,0,0,0,0,0,0],speed,0)
        return

    def servo_off(self):
        c = {
            "command": "--servo",
            "servo_state": "OFF",
            "joint_id": "all",
        }
        self.send_command(c);
        return

    def is_move(self):
        return self._moving

    def move(self, j, speed, sleep):
        for i in range(7):
            c = {
                "command": "--tpts",
                "joint_id": str(i + 1),
                "pos": str(j[i]),
                "time": str(speed)
            }
            self.send_command(c)

        c = {
            "command": "--ts",
            "joint_id": "all",
        }
        self._moving_time = speed + sleep
        self.send_command(c)
        return
