#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file ToroboArmControllerRTC.py
 @brief ToroboArmController
 @date $Date$


"""
import sys
sys.path.append(".")
import time

# Import RTM module
import RTC
import OpenRTM_aist

import ManipulatorCommonInterface_Common_idl
import ManipulatorCommonInterface_Middle_idl

# Import Service implementation class
# <rtc-template block="service_impl">
from ManipulatorCommonInterface_Common_idl_example import *
from ManipulatorCommonInterface_Middle_idl_example import *

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">

# </rtc-template>

from datetime import datetime

import ToroboArmController
import ToroboArmControllerState

# This module's spesification
# <rtc-template block="module_spec">
toroboarmcontrollerrtc_spec = ["implementation_id", "ToroboArmControllerRTC", 
        "type_name",         "ToroboArmControllerRTC", 
        "description",       "ToroboArmController", 
        "version",           "1.0.0", 
        "vendor",            "Takahashi", 
        "category",          "Controlle", 
        "activity_type",     "STATIC", 
        "max_instance",      "1", 
        "language",          "Python", 
        "lang_type",         "SCRIPT",
        "conf.default.stub_mode", "off",

        "conf.__widget__.stub_mode", "radio",
        "conf.__constraints__.stub_mode", "(off, on)",

        "conf.__type__.stub_mode", "string",
        ""]
# </rtc-template>

##
# @class ToroboArmControllerRTC
# @brief ToroboArmController
# 
# 
class ToroboArmControllerRTC(OpenRTM_aist.DataFlowComponentBase):

	##
	# @brief constructor
	# @param manager Maneger Object
	# 
    def __init__(self, manager):
        OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

        self._d_pos = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._posIn = OpenRTM_aist.InPort("pos", self._d_pos)

        self._d_mode = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._modeIn = OpenRTM_aist.InPort("mode", self._d_mode)

        self._d_status = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._statusOut = OpenRTM_aist.OutPort("status", self._d_status)

        self._commonPort = OpenRTM_aist.CorbaPort("common")
        self._common = ManipulatorCommonInterface_Common_i ()

        self._middlePort = OpenRTM_aist.CorbaPort("middle")
        self._middle = ManipulatorCommonInterface_Middle_i ()


        # initialize of configuration-data.
        # <rtc-template block="init_conf_param">
        """
         - Name:  stub_mode
         - DefaultValue: off
        """
        self._stub_mode = ['off']

        # </rtc-template>

        self._controller = ToroboArmController.Controller()
        self._state = ToroboArmControllerState.ControllerState()
        self._last_send_status = 0
        self._target_pos = [0 for i in range(7)]

        self.log = OpenRTM_aist.Manager.instance().getLogbuf("ToroboArmController")

	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
    def onInitialize(self):
        # Bind variables and configuration variable
        self.bindParameter("stub_mode", self._stub_mode, "off")

        # Set InPort buffers
        self.addInPort("pos",self._posIn)
        self.addInPort("mode",self._modeIn)

        # Set OutPort buffers
        self.addOutPort("status",self._statusOut)

        # Set service provider to Ports
        self._commonPort.registerProvider("common", "JARA_ARM::ManipulatorCommonInterface_Common", self._common)
        self._middlePort.registerProvider("middle", "JARA_ARM::ManipulatorCommonInterface_Middle", self._middle)

        # Set service consumers to Ports

        # Set CORBA Service Ports
        self.addPort(self._commonPort)
        self.addPort(self._middlePort)

        return RTC.RTC_OK

    #	##
    #	# 
    #	# The finalize action (on ALIVE->END transition)
    #	# formaer rtc_exiting_entry()
    #	# 
    #	# @return RTC::ReturnCode_t
    #
    #	# 
    #def onFinalize(self):
    #
    #	return RTC.RTC_OK

    #	##
    #	#
    #	# The startup action when ExecutionContext startup
    #	# former rtc_starting_entry()
    #	# 
    #	# @param ec_id target ExecutionContext Id
    #	#
    #	# @return RTC::ReturnCode_t
    #	#
    #	#
    #def onStartup(self, ec_id):
    #
    #	return RTC.RTC_OK

    #	##
    #	#
    #	# The shutdown action when ExecutionContext stop
    #	# former rtc_stopping_entry()
    #	#
    #	# @param ec_id target ExecutionContext Id
    #	#
    #	# @return RTC::ReturnCode_t
    #	#
    #	#
    def onShutdown(self, ec_id):

        self._controller.stop()

        return RTC.RTC_OK

		##
		#
		# The activated action (Active state entry action)
		# former rtc_active_entry()
		#
		# @param ec_id target ExecutionContext Id
		# 
		# @return RTC::ReturnCode_t
		#
		#
    def onActivated(self, ec_id):

        self._state.clear()
        self._state.set_move_speed(3, 2)

        if self._stub_mode == ['on']:
            self._controller.set_mode(True)

        self._controller.reset()
        self._controller.servo_on()
        self._controller.mode_point()
        self._controller.clear_command()
        speed,interval = self._state.get_move_speed()
        self._controller.move_home(speed)
        self._last_send_status = datetime.now()

        return RTC.RTC_OK

		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onDeactivated(self, ec_id):

        speed,interval = self._state.get_move_speed()
        self._controller.move_home(speed)
        self._controller.servo_off()
        self._controller.reset()

        return RTC.RTC_OK

		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onExecute(self, ec_id):

        if self._modeIn.isNew():
            mode = self._modeIn.read()
            if mode.data == 10:
                self.log.RTC_INFO("teaching mode")
                self._state.set_teaching(True)
                self._controller.mode_free()
            else:
                self.log.RTC_INFO("normal mode")
                self._state.set_teaching(False)
                self._controller.mode_point()

        if self._posIn.isNew():
            #if self._state.can_move():
            if True:
                val = self._posIn.read()
                if len(val.data) == 7:
                    # ignore same target
                    #if val.data != self._target_pos:
                    if True:
                        self.log.RTC_INFO("goal_pos: %lf, %lf, %lf, %lf, %lf, %lf, %lf",
                                          (val.data[0],
                                           val.data[1],
                                           val.data[2],
                                           val.data[3],
                                           val.data[4],
                                           val.data[5],
                                           val.data[6]))
                        self._state.set_idle(False)
                        self._d_status.data = self._state.get_status_id()
                        self._statusOut.write()
                        speed, interval = self._state.get_move_speed()
                        self._controller.move(val.data, speed, interval)
                        self._target_pos = val.data
                        time.sleep(1)

        return RTC.RTC_OK

	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK


def ToroboArmControllerRTCInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=toroboarmcontrollerrtc_spec)
    manager.registerFactory(profile,
                            ToroboArmControllerRTC,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    ToroboArmControllerRTCInit(manager)

    # Create a component
    comp = manager.createComponent("ToroboArmControllerRTC")

def main():
    mgr = OpenRTM_aist.Manager.init(sys.argv)
    mgr.setModuleInitProc(MyModuleInit)
    mgr.activateManager()
    mgr.runManager()

if __name__ == "__main__":
    main()

