#!/usr/bin/env python
## -*- coding: utf-8 -*-


class ControllerState:

    def __init__(self):
        self._idle = False
        self._pause = False
        self._stop = False
        self._slow = False
        self._teaching = False
        self._move_speed = 0
        self._move_interval = 0

    def clear(self):
        self._idle = False
        self._pause = False
        self._stop = False
        self._slow = False
        self._teaching = False
        self._move_speed = 0
        self._move_interval = 0

    def set_move_speed(self, speed, interval):
        self._move_speed = speed
        self._move_interval = interval

    def get_move_speed(self):
        if self._slow:
            return self._move_speedi * 3, self._move_interval *3
        elif self._stop or self._pause or self._teaching:
            return 0, 0
        else:
            return self._move_speed, self._move_interval

    def set_idle(self, val):
        self._idle = val

    def is_idle(self):
        return self._idle

    def set_slow(self, val):
        self._slow = val

    def is_slow(self):
        return self._slow

    def set_pause(self, val):
        self._pause = val

    def is_pause(self):
        return self._pause

    def set_stop(self, val):
        self._stop = val

    def is_stop(self):
        return self._stop

    def set_teaching(self, val):
        self._teaching = val

    def is_teaching(self):
        return self._teaching

    def get_status_id(self):
        if self._teaching:
            # teaching
            return 10
        elif self._stop:
            # stop
            return 4
        elif self._pause:
            # pause
            return 3
        elif self._idle:
            # idle
            return 0
        elif self._idle:
            # moving(slow)
            return 2
        else:
            # moving
            return 1

    def can_move(self):
        return not self._stop and not self._pause and not self._teaching and self._idle
