#! /usr/bin/env python
# -*- coding: utf-8 -*-

import time
import random
import zmq
import json
import math
import threading

class monitor(threading.Thread):

    def __init__(self):
        self._pos = [0 for i in range(7)]
        self._vel = [0 for i in range(7)]
        self._trq = [0 for i in range(7)]
        self._cur = [0 for i in range(7)]
        self._tmp = [0 for i in range(7)]
        self._stub_mode = False

        self._start_event = threading.Event()
        self._thread = threading.Thread(target = self.run)
        self._thread.setDaemon(True)
        self._thread.start()

    def run(self):
        self._start_event.wait()
        if not self._stub_mode:
            # initialize ZMQ context
            context = zmq.Context()
            sock = context.socket(zmq.SUB)
            sock.connect("tcp://localhost:5554")
            sock.setsockopt(zmq.SUBSCRIBE, b"ToroboArmManager")

        while True:
            if self._stub_mode:
                time.sleep(1)
            else:
                try:
                    [address, contents] = sock.recv_multipart()
                except:
                    time.sleep(0.1)
                    pass

                # Parse contents
                state = json.loads(contents)

            idx = random.randint(0, 4)
            for i in range(7):
                if self._stub_mode:
                    pos = [
                        [-46.69,47.65,3.92,35.61,-2.21,94.15,2.11],
                        [-47.05,58.37,4.02,50.70,-2.22,69.44,2.19],
                        [-2.29,11.42,2.45,65.18,-0.94,100.23,10.03],
                        [32.98,35.21,4.65,64.01,-4.48,77.17,60.51],
                        [34.55,46.29,6.53,72.20,-8.44,62.24,64.54]
                    ]
                    self._pos[i] = pos[idx][i]
                    self._vel[i] = random.uniform(0, 180)
                    self._trq[i] = random.uniform(0, 10)
                    self._cur[i] = random.uniform(0, 10)
                    self._tmp[i] = random.uniform(0, 10)
                else:
                    self._pos[i] = state["jointState"][i]["position"]
                    self._vel[i] = state["jointState"][i]["velocity"]
                    self._trq[i] = state["jointState"][i]["torque"]
                    self._cur[i] = state["jointState"][i]["currect"]
                    self._tmp[i] = state["jointState"][i]["temperature"]

            if not self._start_event.is_set():
                self._pos = [0 for i in range(7)]
                self._vel = [0 for i in range(7)]
                self._trq = [0 for i in range(7)]
                self._cur = [0 for i in range(7)]
                self._tmp = [0 for i in range(7)]
                self._start_event.wait()


    def get_pos(self):
        return self._pos

    def get_vel(self):
        return self._vel

    def get_trq(self):
        return self._trq

    def get_cur(self):
        return self._cur

    def get_tmp(self):
        return self._tmp

    def start(self, mode):
        self._stub_mode = mode
        self._start_event.set()

    def stop(self):
        self._start_event.clear()

