#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file ToroboArmMonitorRTC.py
 @brief ToroboArmMonitorRTC
 @date $Date$


"""
import sys
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist


# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>

import ToroboArmMonitor

# This module's spesification
# <rtc-template block="module_spec">
toroboarmmonitorrtc_spec = ["implementation_id", "ToroboArmMonitorRTC", 
		 "type_name",         "ToroboArmMonitorRTC", 
		 "description",       "ToroboArmMonitorRTC", 
		 "version",           "1.0.0", 
		 "vendor",            "takahashi", 
		 "category",          "Sensor", 
		 "activity_type",     "STATIC", 
		 "max_instance",      "1", 
		 "language",          "Python", 
		 "lang_type",         "SCRIPT",
		 "conf.default.stub_mode", "off",

		 "conf.__widget__.stub_mode", "radio",
		 "conf.__constraints__.stub_mode", "(off, on)",

         "conf.__type__.stub_mode", "string",
		 ""]
# </rtc-template>

##
# @class ToroboArmMonitorRTC
# @brief ToroboArmMonitorRTC
# 
# 
class ToroboArmMonitorRTC(OpenRTM_aist.DataFlowComponentBase):

	##
	# @brief constructor
	# @param manager Maneger Object
	# 
    def __init__(self, manager):
        OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

        self._d_current_pos = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._current_posOut = OpenRTM_aist.OutPort("current_pos", self._d_current_pos)

        self._d_current_vel = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._current_velOut = OpenRTM_aist.OutPort("current_vel", self._d_current_vel)

        self._d_current_trq = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._current_trqOut = OpenRTM_aist.OutPort("current_trq", self._d_current_trq)

        self._d_current_cur = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._current_curOut = OpenRTM_aist.OutPort("current_cur", self._d_current_cur)

        self._d_current_tmp = RTC.TimedFloatSeq(RTC.Time(0, 0), [])
        self._current_tmpOut = OpenRTM_aist.OutPort("current_tmp", self._d_current_tmp)



		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
        """
         - Name:  stub_mode
         - DefaultValue: off
        """
        self._stub_mode = ['off']

		# </rtc-template>

        self._monitor = ToroboArmMonitor.monitor()
        self.log = OpenRTM_aist.Manager.instance().getLogbuf("ToroboArmMonitor")


	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry() 
	# 
	# @return RTC::ReturnCode_t
	# 
	#
    def onInitialize(self):
		# Bind variables and configuration variable
        self.bindParameter("stub_mode", self._stub_mode, "off")

		# Set InPort buffers

		# Set OutPort buffers
        self.addOutPort("current_pos",self._current_posOut)
        self.addOutPort("current_vel",self._current_velOut)
        self.addOutPort("current_trq",self._current_trqOut)
        self.addOutPort("current_cur",self._current_curOut)
        self.addOutPort("current_tmp",self._current_tmpOut)

		# Set service provider to Ports

		# Set service consumers to Ports

		# Set CORBA Service Ports

        return RTC.RTC_OK

	#	##
	#	# 
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK
	
		##
		#
		# The activated action (Active state entry action)
		# former rtc_active_entry()
		#
		# @param ec_id target ExecutionContext Id
		# 
		# @return RTC::ReturnCode_t
		#
		#
    def onActivated(self, ec_id):

        self.log.RTC_INFO("start monitoring: stub=" + str(self._stub_mode))

        if self._stub_mode == ['on']:
            self._monitor.start(True)
        else:
            self._monitor.start(False)

        return RTC.RTC_OK

		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onDeactivated(self, ec_id):

        self._monitor.stop()

        return RTC.RTC_OK

		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onExecute(self, ec_id):

        self._d_current_pos.data = self._monitor.get_pos()
        self._current_posOut.write()

        self._d_current_vel.data = self._monitor.get_vel()
        self._current_velOut.write()

        self._d_current_trq.data = self._monitor.get_trq()
        self._current_trqOut.write()

        self._d_current_cur.data = self._monitor.get_cur()
        self._current_curOut.write()

        self._d_current_tmp.data = self._monitor.get_tmp()
        self._current_tmpOut.write()

        self.log.RTC_DEBUG("current_pos: " + str(self._d_current_pos.data))
        self.log.RTC_DEBUG("current_vel: " + str(self._d_current_vel.data))
        self.log.RTC_DEBUG("current_trq: " + str(self._d_current_trq.data))
        self.log.RTC_DEBUG("current_cur: " + str(self._d_current_cur.data))
        self.log.RTC_DEBUG("current_tmp: " + str(self._d_current_tmp.data))

        return RTC.RTC_OK

	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK
	
	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK
	



def ToroboArmMonitorRTCInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=toroboarmmonitorrtc_spec)
    manager.registerFactory(profile,
                            ToroboArmMonitorRTC,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    ToroboArmMonitorRTCInit(manager)

    # Create a component
    comp = manager.createComponent("ToroboArmMonitorRTC")

def main():
    mgr = OpenRTM_aist.Manager.init(sys.argv)
    mgr.setModuleInitProc(MyModuleInit)
    mgr.activateManager()
    mgr.runManager()

if __name__ == "__main__":
    main()

