#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Python -*-

"""
 @file VacuumControllerRTC.py
 @brief Vacuum Controller
 @date $Date$


"""
import sys
import time
sys.path.append(".")

# Import RTM module
import RTC
import OpenRTM_aist


# Import Service implementation class
# <rtc-template block="service_impl">

# </rtc-template>

# Import Service stub modules
# <rtc-template block="consumer_import">
# </rtc-template>


# This module's spesification
# <rtc-template block="module_spec">
vacuumcontrollerrtc_spec = ["implementation_id", "VacuumControllerRTC",
        "type_name",         "VacuumControllerRTC",
        "description",       "Vacuum Controller",
        "version",           "1.0.0",
        "vendor",            "Takahashi",
        "category",          "Controlle",
        "activity_type",     "STATIC",
        "max_instance",      "1",
        "language",          "Python",
        "lang_type",         "SCRIPT",
        "conf.default.stub_mode", "off",

        "conf.__widget__.stub_mode", "radio",
        "conf.__constraints__.stub_mode", "(off, on)",

        "conf.__type__.stub_mode", "string",
        ""]
# </rtc-template>

##
# @class VacuumControllerRTC
# @brief Vacuum Controller
#
#
class VacuumControllerRTC(OpenRTM_aist.DataFlowComponentBase):

	##
	# @brief constructor
	# @param manager Maneger Object
	#
    def __init__(self, manager):
        OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

        self._d_grip_in = RTC.TimedOctet(RTC.Time(0, 0), 0)
        self._grip_inIn = OpenRTM_aist.InPort("grip_in", self._d_grip_in)

        self._d_pressure_out = RTC.TimedFloat(RTC.Time(0, 0), 0)
        self._pressure_outOut = OpenRTM_aist.OutPort("pressure_out", self._d_pressure_out)

		# initialize of configuration-data.
		# <rtc-template block="init_conf_param">
        """
        - Name:  stub_mode
        - DefaultValue: off
        """
        self._stub_mode = ['off']

		# </rtc-template>

        self._current_state = 0
        self.log = OpenRTM_aist.Manager.instance().getLogbuf("VacuumController")

	##
	#
	# The initialize action (on CREATED->ALIVE transition)
	# formaer rtc_init_entry()
	#
	# @return RTC::ReturnCode_t
	#
	#
    def onInitialize(self):
        # Bind variables and configuration variable
        self.bindParameter("stub_mode", self._stub_mode, "off")

        # Set InPort buffers
        self.addInPort("grip_in", self._grip_inIn)

        # Set OutPort buffers
        self.addOutPort("pressure_out", self._pressure_outOut)

        # Set service provider to Ports

        # Set service consumers to Ports

        # Set CORBA Service Ports

        return RTC.RTC_OK

	#	##
	#	#
	#	# The finalize action (on ALIVE->END transition)
	#	# formaer rtc_exiting_entry()
	#	# 
	#	# @return RTC::ReturnCode_t
	#
	#	# 
	#def onFinalize(self):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The startup action when ExecutionContext startup
	#	# former rtc_starting_entry()
	#	# 
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onStartup(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The shutdown action when ExecutionContext stop
	#	# former rtc_stopping_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onShutdown(self, ec_id):
	#
	#	return RTC.RTC_OK

		##
		#
		# The activated action (Active state entry action)
		# former rtc_active_entry()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onActivated(self, ec_id):

        self.log.RTC_INFO("grip: setup")
        if self._stub_mode == ['off']:
          import RPi.GPIO as GPIO
          self._gpio = GPIO

          self._gpio.setmode(self._gpio.BCM)
          self._gpio.setup(14, self._gpio.OUT)
          self._gpio.setup(15, self._gpio.OUT)
          self._gpio.output(14, True)
          self._gpio.output(15, True)

        return RTC.RTC_OK

		##
		#
		# The deactivated action (Active state exit action)
		# former rtc_active_exit()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onDeactivated(self, ec_id):
        self.log.RTC_INFO("grip: cleanup")
        if self._stub_mode == ['off']:
          self._gpio.output(14, True)
          self._gpio.output(15, True)
          self._gpio.cleanup()

        return RTC.RTC_OK

		##
		#
		# The execution action that is invoked periodically
		# former rtc_active_do()
		#
		# @param ec_id target ExecutionContext Id
		#
		# @return RTC::ReturnCode_t
		#
		#
    def onExecute(self, ec_id):

        if self._grip_inIn.isNew():
            grip = self._grip_inIn.read().data
            # ignore same request
            if grip != self._current_state:
                self.log.RTC_INFO("grip: " + str(grip))
                if self._stub_mode == ['off']:
                    if grip == 1:
                        # grip
                        self._gpio.output(14, False)
                        self._gpio.output(15, True)
                    if grip == 2:
                        # release
                        self._gpio.output(14, True)
                        self._gpio.output(15, False)
                    else:
                        # idle
                        self._gpio.output(14, True)
                        self._gpio.output(15, True)

                self._current_state = grip

        return RTC.RTC_OK

	#	##
	#	#
	#	# The aborting action when main logic error occurred.
	#	# former rtc_aborting_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onAborting(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The error action in ERROR state
	#	# former rtc_error_do()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onError(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The reset action that is invoked resetting
	#	# This is same but different the former rtc_init_entry()
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onReset(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The state update action that is invoked after onExecute() action
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#

	#	#
	#def onStateUpdate(self, ec_id):
	#
	#	return RTC.RTC_OK

	#	##
	#	#
	#	# The action that is invoked when execution context's rate is changed
	#	# no corresponding operation exists in OpenRTm-aist-0.2.0
	#	#
	#	# @param ec_id target ExecutionContext Id
	#	#
	#	# @return RTC::ReturnCode_t
	#	#
	#	#
	#def onRateChanged(self, ec_id):
	#
	#	return RTC.RTC_OK




def VacuumControllerRTCInit(manager):
    profile = OpenRTM_aist.Properties(defaults_str=vacuumcontrollerrtc_spec)
    manager.registerFactory(profile,
                            VacuumControllerRTC,
                            OpenRTM_aist.Delete)

def MyModuleInit(manager):
    VacuumControllerRTCInit(manager)

    # Create a component
    comp = manager.createComponent("VacuumControllerRTC")

def main():
    mgr = OpenRTM_aist.Manager.init(sys.argv)
    mgr.setModuleInitProc(MyModuleInit)
    mgr.activateManager()
    mgr.runManager()

if __name__ == "__main__":
    main()

