/*
 * CCSVLoader.cpp
 *
 *  Created on: 2016/09/19
 *      Author: vivitter
 */

#include "CCSVLoader.h"

CCSVLoader::CCSVLoader() {
	// TODO Auto-generated constructor stub

}

CCSVLoader::~CCSVLoader() {
	// TODO Auto-generated destructor stub
}


list<list<float>> CCSVLoader::getDataList(char* csvFileName, char devider) {
	list<list<float>> dataList;

	// Load CSV File
	ifstream ifs(csvFileName);
	if(!ifs) {
		cout << "CSV file does not exist." << endl;
		return dataList;
	}

	// Read from file
	string str;
	while(getline(ifs, str)){
		string token;
		istringstream stream(str);
		list<float> singleLineDataList;
		bool isHeader = false;

		// Split line with devider and get data
		while(getline(stream, token, devider)){
			float temp = 0.0;
			try {
				temp=stof(token);
			} catch (const invalid_argument &e) {
				isHeader = true;
//				cerr << e.what() << endl;
				break;
			}
			// Add data to line list
			singleLineDataList.push_back(temp);
		}

		if(!isHeader){
			// Push to Whole Data List
			dataList.push_back(singleLineDataList);
		}else{
			isHeader = false;
		}
	}

	return dataList;
}
