/*
 * MasterControllerClient.h
 *
 *  Created on: 2016/09/17
 *      Author: vivitter
 */

#ifndef SRC_CMASTERCONTROLLERCLIENT_H_
#define SRC_CMASTERCONTROLLERCLIENT_H_

#include <string.h>
#include <stdio.h>
#include <iostream>
#include <time.h>
#include <cstdint>
#include <inttypes.h>

#ifdef __linux__
#include <jsoncpp/json/json.h>
#include <jsoncpp/json/writer.h>
#elif __APPLE__
#include <json/json.h>
#include <json/writer.h>

#endif

#include "CSendData.h"
#include "CSerialPort.h"

#include "CCSVLoader.h"

#define BUF_SIZE 38400
#define PVT_BUFF_SIZE 950

typedef struct PvtPoint {
	char jointId[20];
	float position;
	float velocity;
	float time;
}PVT_POINT;

class CMasterControllerClient : public CSerialPort {

private:
	char _buf[MPCOM_BUFF_SIZE];
	int _remain;
	int _crcErrorCnt;
	bool findHeader1;
	bool findHeader2;

	DMA_RX_DATA curState;

	uint32_t searchPacket(uint8_t* readBytes, uint32_t length, DMA_RX_DATA* rxData);
	bool parseData(uint8_t* packetBytes, DMA_RX_DATA* recvPacket);
	void sendDataToMCU(CSendData* sendData);

	void setJointOrder(char* jointId, ePacketOrder order, CSendData* sendData);
	void setValue(char* jointId, int valueNum, float value, CSendData* sendData);

	// PVT点送信中かを管理するためのフラグ
	bool pvtPointSending = false;

	bool isEqual(const char* str1, const char* str2);
	int strSplit(char* str, const char* delim, char* res[]);

public:
	CMasterControllerClient(char* deviceName, unsigned long baudRate);
	virtual ~CMasterControllerClient();

	bool isPvtPointSending() const {
		return pvtPointSending;
	}

	void setPvtPointSending(bool pvtPointSending = false) {
		this->pvtPointSending = pvtPointSending;
	}

	const DMA_RX_DATA& getCurState() const {
		return curState;
	}

	void setCurState(const DMA_RX_DATA& curState) {
		this->curState = curState;
	}

	list<list<float>> pvtPointList;

	// Execute Command
	string execCommand(char* commandJson);

	// Show Current Status
	uint16_t receiveStatus();
	void showCuurentStatus();

	// Servo Control
	void sendServoOn(char* jointId);
	void sendServoOff(char* jointId);

	// Brake
	void sendBrakeOn(char* jointId);
	void sendBrakeOff(char* jointId);

	// Reset Command
	void sendReset(char* jointId);

	// Control Mode Settings
	void sendCtrlMode(char* jointId, unsigned char ctrlMode);

	// PID Parameters
	void sendParamKp(char* jointName, float kp);
	void sendParamKi(char* jointName, float ki);
	void sendParamKd(char* jointName, float kd);
	void sendParamDa(char* jointName, float da);

	// Reference Value Settings
	void sendRefCurrent(char* jointId, float refCur);
	void sendRefPosition(char* jointId, float refPos);
	void sendRefVelocity(char* jointId, float refPos);
	void sendRefTorque(char* jointId, float refTorque);

	// New Trajectory Control
	void sendTrajectoryPTLinear(char* jointId, float refPos, float transitionTime);
	void sendTrajectoryPTSin(char* jointId, float refPos, float transitionTime);
	void setTrajectoryPVT(char* jointId, float position, float velocity, float time);
	void setTrajectoryPVT(list<PVT_POINT> pvtPointList);
	void setTrajectoryPVT(PVT_POINT* pvtPoints);
	void sendTrajectoryPVT(char* filepath);
	void clearTrajectoryViaPoints(char* jointId);
	void clearMasterTrajectoryViaPointsBuffer(char* jointId);
	//void startTrajectoryControl();
	void startTrajectoryControl(char* jointId);


	// // Trajectory Control
	// void setTrajectory(char* jointId, float refPos, float transitionTime);
	// void setAngTrajectory(char* jointId, float refPos);
	// void startTrafectoryControl(char* jointId);
	//
	// // PVT Control
	// void setPvtPoints(char* jointId, float position, float velocity, float time);
	// void setPvtPoints(list<PVT_POINT> pvtPointList);
	// void setPvtPoints(PVT_POINT* pvtPoints);
	// void sendPvtPoints(char* filepath);
	// void startPvtControl();
	// void clearPvtBuffer();

	// Get Current state as JSON String
	string getCurStateJson();
};

#endif /* SRC_CMASTERCONTROLLERCLIENT_H_ */
