/*
 * SendData.cpp
 *
 *  Created on: 2016/08/13
 *      Author: vivitter
 */

#include "CSendData.h"

/*
 * コンストラクタ
 */
CSendData::CSendData() {
	this->header1 = MPCOM_HEADER1;
	this->header2 = MPCOM_HEADER2;
	this->armOrder = PACKET_ORDER_NONE;
	for(int i=0; i<MAX_JOINT_NUM; i++) {
		this->joint[i].ID = (uint8_t)i;
		this->setJointOrder(i, PACKET_ORDER_NONE);
		for(int j=0; j<4; j++)
			this->setValue(i, j+1, 0.0);
	}
}

/*
 * デストラクタ
 */
CSendData::~CSendData() {
	// TODO Auto-generated destructor stub
}

/*
 * Getter & Setter
 */
void CSendData::setHeader() {
	this->header1 = MPCOM_HEADER1;
	this->header2 = MPCOM_HEADER2;
}
void CSendData::setValue(int jointId, int index, float value) {
	switch(index) {
	case 1:
		this->joint[jointId].value1 = value;
		break;
	case 2:
		this->joint[jointId].value2 = value;
		break;
	case 3:
		this->joint[jointId].value3 = value;
		break;
	case 4:
		this->joint[jointId].value4 = value;
		break;
	}
}
void CSendData::setTimeStamp() {
}
void CSendData::setArmOrder(uint8_t order) {
	this->armOrder = order;
}
void CSendData::setJointOrder(int jointId, uint8_t order) {
	this->joint[jointId].jointOrder = order;
}
void CSendData::setTxJoint() {
}

/*
 * データ送信オブジェクトをバイト型に変換して返す。
 */
uint8_t* CSendData::getPacketBytes(unsigned char* bytes) {
	DMA_TX_DATA* stSendData = new DMA_TX_DATA;
	// Header
	stSendData->BUFF.DATA.HEADER1=MPCOM_HEADER1;
	stSendData->BUFF.DATA.HEADER2=MPCOM_HEADER2;
	// Timestamp
//	time_t epoch_time;
//	stSendData->BUFF.DATA.timeStamp = (uint64_t)time(NULL);
	stSendData->BUFF.DATA.timeStamp = clock();
	// Arm Order
	stSendData->BUFF.DATA.armOrder = this->armOrder;
	for(int i=0; i<MAX_JOINT_NUM; i++){
		stSendData->BUFF.DATA.joint[i] = this->joint[i];
	}

	// Set CRC Code
	this->crcCode = crc.calcCRC16(stSendData->BUFF.ALL, (MPCOM_TX_DATA_SIZE));
	stSendData->BUFF.DATA.CRC_CODE = this->crcCode;

	return stSendData->BUFF.ALL;
}

// 送信データを表示する（デバッグ用途）
void CSendData::showSendData() {
	for(int i=0; i<MAX_JOINT_NUM; i++){
		cout << "ID    : " << hex << (int)this->joint[i].ID << endl;
		cout << "ORDER : " << hex << (int)this->joint[i].jointOrder << endl;
		cout << "VALUE1: " << this->joint[i].value1 << endl;
		cout << "VALUE2: " << this->joint[i].value2 << endl;
		cout << "VALUE3: " << this->joint[i].value3 << endl;
		cout << "VALUE4: " << this->joint[i].value4 << endl;
		cout << "---------------------------" << endl;
	}
}
