/*
 * SendData.h
 *
 *  Created on: 2016/08/13
 *      Author: vivitter
 */

#ifndef SENDDATA_H_
#define SENDDATA_H_
#include <iostream>
#include <time.h>
#include <stdio.h>
#include <cstdint>

#include "CCrc.h"
#include "CommonDefine.h"
using namespace std;

//!< バッファサイズ
#define MPCOM_READ_SIZE				(4096)
#define MPCOM_BUFF_SIZE				(8192)

//!< CRCの設定
#define MPCOM_CRC_SIZE				(2)

//!< パケット定義
#define MPCOM_HEADER1				(0xAB)	//!< Packet Header 1
#define MPCOM_HEADER2				(0xCD)	//!< Packet Header 2
#define MPCOM_HEADER_SIZE			(2)
#define MPCOM_TIMESTAMP_SIZE		(sizeof(uint64_t))	//!< time stamp
#define MPCOM_HOST_TIMESTAMP_SIZE	(sizeof(uint64_t))	//!< host time stamp
#define MPCOM_DURATION_SIZE			(sizeof(float))
#define MPCOM_ARM_ORDER_SIZE		(sizeof(uint8_t))

#define MPCOM_RX_JOINT_DATA_SIZE	(sizeof(RX_JOINT))
#define MPCOM_RX_MESSAGE_LENGTH		(MPCOM_TIMESTAMP_SIZE + MPCOM_DURATION_SIZE + MPCOM_HOST_TIMESTAMP_SIZE + MPCOM_RX_JOINT_DATA_SIZE * MAX_JOINT_NUM)
#define MPCOM_RX_DATA_SIZE			(MPCOM_HEADER_SIZE + MPCOM_RX_MESSAGE_LENGTH)
#define MPCOM_DMA_RX_DATA_SIZE		(MPCOM_RX_DATA_SIZE + MPCOM_CRC_SIZE)

#define MPCOM_TX_JOINT_DATA_SIZE	(sizeof(TX_JOINT))
#define MPCOM_TX_DATA_SIZE			(MPCOM_HEADER_SIZE + MPCOM_TIMESTAMP_SIZE + MPCOM_ARM_ORDER_SIZE + MPCOM_TX_JOINT_DATA_SIZE * MAX_JOINT_NUM)
#define MPCOM_DMA_TX_DATA_SIZE		(MPCOM_TX_DATA_SIZE + MPCOM_CRC_SIZE)

enum ePacketOrder
{
	PACKET_ORDER_NONE						= (0x00),

	PACKET_ORDER_RESET						= (0xA0),
	PACKET_ORDER_SERVO_OFF					= (0xA1),
	PACKET_ORDER_SERVO_ON					= (0xA2),
	PACKET_ORDER_RUN_MODE					= (0xA3),

	PACKET_ORDER_PARAM_KP					= (0xB0),
	PACKET_ORDER_PARAM_KI					= (0xB1),
	PACKET_ORDER_PARAM_KD					= (0xB2),
	PACKET_ORDER_PARAM_DAMPER				= (0xB4),

	PACKET_ORDER_BRAKE_OFF				= (0xC0),
	PACKET_ORDER_BRAKE_ON					= (0xC1),

	PACKET_ORDER_CURRENT					= (0x10),
	PACKET_ORDER_POSITION					= (0x11),
	PACKET_ORDER_VELOCITY					= (0x12),
	PACKET_ORDER_TORQUE						= (0x13),

	PACKET_ORDER_TRAJ_VIA_CLEAR         = (0x30),
  PACKET_ORDER_TRAJ_CTRL_START        = (0x35),
  PACKET_ORDER_TRAJ_VIA_APPEND_P      = (0x3A),
  PACKET_ORDER_TRAJ_VIA_APPEND_PT_LINEAR  = (0x3B),
  PACKET_ORDER_TRAJ_VIA_APPEND_PT_SIN     = (0x3C),
  PACKET_ORDER_TRAJ_VIA_APPEND_PVT    = (0x3D),
};

enum eJointType
{
	JOINT_TYPE_ARM = 0,
	JOINT_TYPE_HAND = 1,
};

// High level control mode
#define HIGH_LEVEL_CONTROL_MODE_NUM 10
enum eHighLevelControlMode
{
	MTR_HIGH_CTRL_MODE_POSITION,
	MTR_HIGH_CTRL_MODE_VELOCITY,
	MTR_HIGH_CTRL_MODE_CURRENT,
	MTR_HIGH_CTRL_MODE_TORQUE,
	MTR_HIGH_CTRL_MODE_POS_WC,
	MTR_HIGH_CTRL_MODE_WEIGHT_COMP,
	MTR_HIGH_CTRL_MODE_IMPEDANCE,
	MTR_HIGH_CTRL_MODE_SPRING,
	MTR_HIGH_CTRL_MODE_TRAJ_DYNA,
	MTR_HIGH_CTRL_MODE_TRAJ,
};
const int ctrlModeID[HIGH_LEVEL_CONTROL_MODE_NUM] = {0, 1, 2, 3, 4, 5, 6, 7, 20, 21};

enum eTrajStatus
{
	STOP                     = 0,     //!<
	START                       ,     //!<
	RUNNING                     ,     //!<
	NEXT_POINT                  ,     //!<
	COMPLETE                    ,     //!<
	BUFFER_OVERFLOW_ERROR       ,     //!<
	BUFFER_UNDERFLOW_ERROR      ,     //!<
	INVALID_POSITION_ERROR      ,     //!<
	INVALID_VELOCITY_ERROR      ,     //!<
	INVALID_ACCELERATION_ERROR  ,     //!<
	INVALID_TIME_ERROR          ,     //!<
	INVALID_ITRP_MODE_ERROR     ,     //!<
	GENERATE_ERROR              ,     //!<
	START_ERROR                 ,     //!<
	POSDIFF_DETECT_ERROR        ,     //!<
	NOT_COMPLETE_ERROR          ,     //!<
};

/*----------------------------------------------------------------------
Struct Definition
----------------------------------------------------------------------*/
#pragma pack(1)
typedef struct
{
	uint8_t								type;						//!< Slave Mcu Type
	uint8_t               comStatus;     //!< 通信状態
	uint8_t               systemMode;    //!< システムモード
	uint8_t               ctrlMode;      //!< 制御モード
	uint32_t							ewStatus;      //!< エラーステータス
	uint8_t               trjStatus;     //!< 軌道制御ステータス
	uint16_t							trjViaRemain;  //!< 軌道制御経由点残数
	float                refCurrent;    //!< 目標電流[A]
	float                refPosition;   //!< 目標位置[deg]
	float                refVelocity;   //!< 目標速度[deg/s]
	float                refTorque;     //!< 目標トルク[Nm]
	float                current;       //!< 現在電流 [A]
	float                position;      //!< 現在角度 [deg]
	float                velocity;      //!< 現在角速度 [deg/s]
	float                torque;        //!< 現在トルク[Nm]
	float                temperature;   //!< 現在温度 [℃]
	float                kp;            //!< Pゲイン
	float                ki;            //!< Iゲイン
	float                kd;            //!< Dゲイン
	float                damper;        //!< ダンパーゲイン
} RX_JOINT;

typedef struct
{
	uint8_t ID;
	uint8_t jointOrder;
	float  value1;
	float  value2;
	float  value3;
	float  value4;
} TX_JOINT;

//!< 受信パケット
typedef struct
{
	union
	{
		uint8_t ALL[MPCOM_DMA_RX_DATA_SIZE];
		struct
		{
			uint8_t   HEADER1;
			uint8_t   HEADER2;

			uint64_t  timeStamp;
			uint64_t  hostTimeStamp;
			float    duration;

			RX_JOINT joint[MAX_JOINT_NUM];

			//!< CRCコード
			uint16_t   CRC_CODE;
		} DATA;
	} BUFF;
} DMA_RX_DATA;

//!< 送信パケット
typedef struct
{
	union
	{
		uint8_t ALL[MPCOM_DMA_TX_DATA_SIZE];
		struct
		{
			uint8_t   HEADER1;
			uint8_t   HEADER2;

			uint64_t  timeStamp;
			uint8_t   armOrder;
			TX_JOINT joint[MAX_JOINT_NUM];

			//!< CRCコード
			uint16_t   CRC_CODE;
		} DATA;
	} BUFF;
} DMA_TX_DATA;
#pragma pack()



class CSendData {
private:
	// Header
	uint8_t   header1;
	uint8_t   header2;
	// TimeStamp
	uint64_t  timeStamp;
	uint8_t   armOrder;

	// Joint Status
	TX_JOINT joint[MAX_JOINT_NUM];
	// CRC
	uint16_t   crcCode;

	CCrc crc;


public:
	CSendData();
	virtual ~CSendData();
	void setHeader();
	void setTimeStamp();

	void setArmOrder(uint8_t order);
	void setJointOrder(int jointId, uint8_t order);
	void setValue(int jointId, int index, float value);
	void setTxJoint();
	uint8_t* getPacketBytes(uint8_t* bytes);

	// For Debug
	void showSendData();
};

#endif /* SENDDATA_H_ */
