/*
 * CSerialPort.h
 *
 *  Created on: 2016/09/17
 *      Author: vivitter
 */

#ifndef SRC_CSERIALPORT_H_
#define SRC_CSERIALPORT_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <cstdint>

class CSerialPort {
private:
	int fd;
	struct termios oldtio, newtio;
	char* deviceName;
	unsigned long baudRate;

	int rate_to_constant(unsigned long baudrate);

public:
	CSerialPort(char* deviceName, unsigned long baudRate);
	CSerialPort();
	virtual ~CSerialPort();

	int connect(char* deviceName, unsigned long baudRate);
	void disconnect(void);

	int send(unsigned char* buffer, int bufSize);
	int recv(unsigned char* buffer, int bufSize);

	unsigned long getBaudRate() const {
		return baudRate;
	}

	void setBaudRate(unsigned long baudRate) {
		this->baudRate = baudRate;
	}

	char* getDeviceName() const {
		return deviceName;
	}

	void setDeviceName(char* deviceName) {
		this->deviceName = deviceName;
	}
};

#endif /* SRC_CSERIALPORT_H_ */
