﻿/**
 * @file  BoardDefine.h
 * @brief ボード固有情報定義
 *
 * @par   Copyright © 2016 Tokyo Robotics Inc. All rights reserved.
 */
#ifndef __BOARD_DEFINE_H__
#define __BOARD_DEFINE_H__
/*----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------*/
#include <cstdint>

/*----------------------------------------------------------------------
 Macro Definitions
 ----------------------------------------------------------------------*/
#define SLAVE_MCU_NUM	(7)         //!< 接続するスレーブMCUの数（指定できる最大値は6)
#define MAX_JOINT_NUM	(7)         //!< PCとの通信を考慮した最大の関節数(必ずSALVE_MCU_NUM<=MAX_JOINT_NUM)

/*----------------------------------------------------------------------
 Enum Definitions
 ----------------------------------------------------------------------*/
typedef enum
{
    //!< Error: Servo off
    SLAVE_ERROR_OVER_POSITION =     0,          //!< 過位置エラー
    SLAVE_ERROR_OVER_VELOCITY =     1,          //!< 過速度エラー
    SLAVE_ERROR_OVER_CURRENT =      2,          //!< 過電流エラー
    SLAVE_ERROR_OVER_TORQUE =       3,          //!< 過トルクエラー
    SLAVE_ERROR_OVER_TEMPERATURE =  4,          //!< 過熱エラー
    SLAVE_ERROR_MASTER_COM_LOST =   5,          //!< with Master Communication Lost
    SLAVE_ERROR_RESERVE1 =          6,          //!< Reserve
    SLAVE_ERROR_RESERVE2 =          7,          //!< Reserve

    //!< Warning: Not servo off
    SLAVE_WARNING_INVALID_EVENT = 8,            //!< 不正イベント設定エラー
    SLAVE_WARNING_DUTY_OUT_RANGE = 9,           //!< Duty out range
    SLAVE_WARNING_ENCD_OUT_READ_FAIL = 10,      //!< 出力軸エンコーダ角読み取り失敗エラー
    SLAVE_WARNING_TORQUE_GET_FAIL = 11,         //!< トルクセンサ値取得失敗エラー
    SLAVE_WARNING_ESCON_INOPERATIVE = 12,       //!< ESCON動作不能状態エラー
    SLAVE_WARNING_RESERVE1 = 13,                //!< Reserve
    SLAVE_WARNING_RESERVE2 = 14,                //!< Reserve
    SLAVE_WARNING_RESERVE3 = 15,                //!< Reserve
} eSlaveErrorWarningStatus;

typedef enum
{
    //!< Error: Servo off immediately
    MASTER_ERROR_OVER_POSITION = 16,            //!< 過位置エラー
    MASTER_ERROR_OVER_VELOCITY = 17,            //!< 過速度エラー
    MASTER_ERROR_OVER_CURRENT = 18,             //!< 過電流エラー
    MASTER_ERROR_OVER_TORQUE = 19,              //!< 過トルクエラー
    MASTER_ERROR_OVER_TEMPERATURE = 20,         //!< 過熱エラー
    MASTER_ERROR_RESERVE1 = 21,                 //!< Reserve
    MASTER_ERROR_RESERVE2 = 22,                 //!< Reserve
    MASTER_ERROR_RESERVE3 = 23,                 //!< Reserve

    //!< Warning: Not servo off
    MASTER_WARNING_INVALID_EVENT = 24,          //!< 不正イベント設定エラー
    MASTER_WARNING_INVALID_CONTROL_MODE = 25,   //!< 不正制御モード設定エラー
    MASTER_WARNING_SLAVE_COM_LOST = 26,         //!< with Master Communication Lost
    MASTER_WARNING_PC_COM_LOST = 27,            //!< with Master Communication Lost
    MASTER_WARNING_RESERVE1 = 28,               //!< Reserve
    MASTER_WARNING_RESERVE2 = 29,               //!< Reserve
    MASTER_WARNING_RESERVE3 = 30,               //!< Reserve
    MASTER_WARNING_RESERVE4 = 31,               //!< Reserve
} eMasterErrorWarningStatus;

/*----------------------------------------------------------------------
 Struct Definitions
 ----------------------------------------------------------------------*/
#pragma pack(1)
typedef union
{
    uint16_t WORD;
    struct
    {
        // Error: Servo off immediately
        uint8_t SLAVE_ERROR_OVER_POSITION :1;
        uint8_t SLAVE_ERROR_OVER_VELOCITY :1;
        uint8_t SLAVE_ERROR_OVER_CURRENT :1;
        uint8_t SLAVE_ERROR_OVER_TORQUE :1;
        uint8_t SLAVE_ERROR_OVER_TEMPERATURE :1;
        uint8_t SLAVE_ERROR_MASTER_COM_LOST :1;
        uint8_t SLAVE_ERROR_RESERVE1 :1;
        uint8_t SLAVE_ERROR_RESERVE2 :1;
        // Warning: Not servo off
        uint8_t SLAVE_WARNING_INVALID_EVENT :1;
        uint8_t SLAVE_WARNING_DUTY_OUT_RANGE :1;
        uint8_t SLAVE_WARNING_ENCD_OUT_READ_FAIL :1;
        uint8_t SLAVE_WARNING_TORQUE_GET_FAIL :1;
        uint8_t SLAVE_WARNING_ESCON_INOPERATIVE :1;
        uint8_t SLAVE_WARNING_RESERVE1 :1;
        uint8_t SLAVE_WARNING_RESERVE2 :1;
        uint8_t SLAVE_WARNING_RESERVE3 :1;
    } BIT;
} SLAVE_ERROR_WARNING_STATUS;
#pragma pack()

#pragma pack(1)
typedef union
{
    uint16_t WORD;
    struct
    {
        // Error: Servo off immediately
        uint8_t MASTER_ERROR_OVER_POSITION :1;
        uint8_t MASTER_ERROR_OVER_VELOCITY :1;
        uint8_t MASTER_ERROR_OVER_CURRENT :1;
        uint8_t MASTER_ERROR_OVER_TORQUE :1;
        uint8_t MASTER_ERROR_OVER_TEMPERATURE :1;
        uint8_t MASTER_ERROR_RESERVE1 :1;
        uint8_t MASTER_ERROR_RESERVE2 :1;
        uint8_t MASTER_ERROR_RESERVE3 :1;
        // Warning: Not servo off
        uint8_t MASTER_WARNING_INVALID_EVENT :1;
        uint8_t MASTER_WARNING_INVALID_CONTROL_MODE :1;
        uint8_t MASTER_WARNING_SLAVE_COM_LOST :1;
        uint8_t MASTER_WARNING_PC_COM_LOST :1;
        uint8_t MASTER_WARNING_RESERVE1 :1;
        uint8_t MASTER_WARNING_RESERVE2 :1;
        uint8_t MASTER_WARNING_RESERVE3 :1;
        uint8_t MASTER_WARNING_RESERVE4 :1;
    } BIT;
} MASTER_ERROR_WARNING_STATUS;
#pragma pack()

#pragma pack(1)
typedef union
{
    uint32_t ALL;
    struct
    {
        SLAVE_ERROR_WARNING_STATUS  SLAVE;
        MASTER_ERROR_WARNING_STATUS MASTER;
    } FLAGS;
} ERROR_WARNING_STATUS;
#pragma pack()

#endif
