#!/bin/bash

function UrgRTC()
{
  echo "### download UrgRTC"
  git clone https://github.com/sugarsweetrobotics/UrgRTC.git

  echo "### compile UrgRTC"
  ( \
    cd UrgRTC && \
    rm -rf urglib && \
    git clone https://github.com/sugarsweetrobotics/urglib.git && \
    cd build && \
    cmake .. && \
    make \
  )
  return 0
}

function LRFViewer()
{
  echo "### download TkLRFViewer"
  sudo apt-get install tix
  svn export http://svn.openrtm.org/OpenRTM-aist-Python/trunk/OpenRTM-aist-Python/OpenRTM_aist/examples/TkLRFViewer/
  return 0
}

function OpenCVCamera()
{
  echo "### download OpenCVCamera"
  svn export http://svn.openrtm.org/ImageProcessing/trunk/ImageProcessing/opencv/components/OpenCVCamera/
  echo "### compile OpenCVCamera"
  ( \
    cd OpenCVCamera && \
    mkdir -p build && \
    cd build && \
    cmake .. && \
    make \
  )
  return 0
}

function CameraViewer()
{
  echo "### download CameraViewer"
  svn export http://svn.openrtm.org/ImageProcessing/trunk/ImageProcessing/opencv/components/CameraViewer/
  echo "### compile CameraViewer"
  ( \
    cd CameraViewer && \
    mkdir -p build && \
    cd build && \
    cmake .. && \
    make \
  )
  return 0
}

function RTnoProxy()
{
  echo "### download RTnoProxy"
  git clone https://github.com/sugarsweetrobotics/RTnoProxy.git
  echo "### compile RTnoProxy"
  ( \
    cd RTnoProxy && \
    mkdir -p build && \
    cd build && \
    cmake .. && \
    make \
  )
  return 0
}

UrgRTC
LRFViewer
OpenCVCamera
CameraViewer
RTnoProxy

exit 0
