#!/bin/bash

readonly dist=ununtu
readonly rtmver=112

function base_package()
{
  sudo apt-get -qq update
  apt-get install -y curl bc default-jre python-pip bsdmainutils apt-utils aptitude iputils-ping net-tools
  return 0
}

function openrtm_cxx()
{
  curl -O http://svn.openrtm.org/OpenRTM-aist/tags/RELEASE_${rtmver}/OpenRTM-aist/build/pkg_install_${dist}.sh
  chmod a+x pkg_install_${dist}.sh
  sudo ./pkg_install_${dist}.sh -c
  return 0
}

function openrtm_python()
{
  curl -O http://svn.openrtm.org/OpenRTM-aist-Python/tags/RELEASE_${rtmver}/OpenRTM-aist-Python/installer/install_scripts/pkg_install_python_${dist}.sh
  chmod a+x pkg_install_python_${dist}.sh
  sudo ./pkg_install_python_${dist}.sh -y
  return 0
}

function rtshell()
{
  sudo pip install -U pip
  sudo pip install rtshell
  sudo mkdir -p /etc/bash_completion.d/
  sudo cp /usr/local/lib/python2.7/dist-packages/rtshell/data/bash_completion /etc/bash_completion.d/
  return 0
}

function openrtp()
{
  curl -O http://openrtm.org/pub/openrtp/packages/1.1.2.v20160526/eclipse442-openrtp112v20160526-linux-gtk-x86_64.tar.gz
  tar xzf eclipse442-openrtp112v20160526-linux-gtk-x86_64.tar.gz
  rm -rf eclipse442-openrtp112v20160526-linux-gtk-x86_64.tar.gz
  sudo ln -s /eclipse/openrtp /usr/bin/
  return 0
}


base_package
openrtm_cxx
openrtm_python
rtshell
openrtp

exit 0
