#!/bin/bash


function run_raspi_1() {
  (cd AreaMonitor && python AreaMonitor.py) &
  (cd MutualMonitorSender && python MutualMonitorSender.py) &
  (cd GripperSafetyController && python GripperSafetyController.py) &
  (cd RobotArmSafetyController && python RobotArmSafetyController.py) &
  (cd MutualMonitor && python MutualMonitor.py) &
  (cd UrgRTC && ./build/src/UrgRTCComp) &
  return 0
}

function run_raspi_2() {
  (cd AreaMonitor && python AreaMonitor.py) &
  (cd MutualMonitorSender && python MutualMonitorSender.py) &
  (cd GripperSafetyController && python GripperSafetyController.py) &
  (cd RobotArmSafetyController && python RobotArmSafetyController.py) &
  (cd MutualMonitor && python MutualMonitor.py) &
  (cd UrgRTC && ./build/src/UrgRTCComp) &
  return 0
}

function run_raspi_3() {
  armmng &
  (cd SignalSelector && python SignalSelector.py) &
  (cd ToroboArmControllerRTC && python ToroboArmControllerRTC.py) &
  (cd ToroboArmMonitorRTC && python ToroboArmMonitorRTC.py) &
  (cd VacuumControllerRTC && python VacuumControllerRTC.py) &
  return 0
}

function run_pc() {
  (cd SystemManager && python SystemManagerRTC.py) &
  (cd TkButtonManager && python TkButtonManagerRTC.py) &
  (cd DisplayWarning && python DisplayWarning.py) &
  return 0
}



# MAIN ROUTINE
# ============

while (( $# > 0 ))
do
  case "$1" in
    '-h'|'--help' )
      exit 1
      ;;
    '--rp1' )
      run_raspi_1
      ;;
    '--rp2' )
      run_raspi_2
      ;;
    '--rp3' )
      run_raspi_3
      ;;
    '--pc' )
      run_pc
      ;;
    *)
      echo "[ERROR] invalid option $1 !!"
      ;;
  esac
  shift
done

exit 1
